//+------------------------------------------------------------------+
//|                                                    WndEvents.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include "Defines.mqh"
#include "WndContainer.mqh"
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
class CWndEvents : public CWndContainer
  {
protected:
   //---     
   CChart            m_chart;
   //---     
   long              m_chart_id;
   int               m_subwin;
   //---  
   string            m_program_name;
   //---   
   string            m_indicator_shortname;
   //---   
   int               m_active_window_index;
   //---   
   int               m_subwindow_handle;
   //---   
   string            m_subwindow_shortname;
   //---        
   int               m_subwindows_total;
   //---
private:
   //---  
   int               m_id;
   long              m_lparam;
   double            m_dparam;
   string            m_sparam;
   //---
protected:
                     CWndEvents(void);
                    ~CWndEvents(void);
   //---    
   virtual void      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam) {}
   //--- 
   void              OnTimerEvent(void);
   //---
public:
   //---   
   void              ChartEvent(const int id,const long &lparam,const double &dparam,const string &sparam);
   //---
private:
   void              ChartEventCustom(void);
   void              ChartEventClick(void);
   void              ChartEventMouseMove(void);
   void              ChartEventObjectClick(void);
   void              ChartEventEndEdit(void);
   void              ChartEventChartChange(void);
   //---     
   void              CheckElementsEvents(void);

   //---   
   void              DetermineSubwindow(void);
   //---   
   void              DeleteExpertSubwindow(void);
   //---      
   void              CheckExpertSubwindowNumber(void);
   //---      
   void              CheckSubwindowNumber(void);
   //---     
   void              ResizeLockedWindow(void);

   //---   
   void              InitChartEventsParams(const int id,const long lparam,const double dparam,const string sparam);
   //---  
   void              MovingWindow(void);
   //---      
   void              CheckElementsEventsTimer(void);
   //---   
   void              SetChartState(void);
   //---
protected:
   //---  
   void              ResetWindow(void);
   //---  
   void              Destroy(void);
   //---
private:
   //--- / 
   bool              OnWindowRollUp(void);
   bool              OnWindowUnroll(void);
   //---    
   bool              OnWindowChangeXSize(void);
   bool              OnWindowChangeYSize(void);
   //---       
   bool              OnHideBackContextMenus(void);
   //---    
   bool              OnHideContextMenus(void);

   //---   
   bool              OnOpenDialogBox(void);
   //---   
   bool              OnCloseDialogBox(void);
   //---      
   bool              OnResetWindowColors(void);
   //---       
   bool              OnZeroPriorities(void);
   //---       
   bool              OnSetPriorities(void);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CWndEvents::CWndEvents(void) : m_chart_id(0),
                               m_subwin(0),
                               m_active_window_index(0),
                               m_indicator_shortname(""),
                               m_program_name(PROGRAM_NAME),
                               m_subwindow_handle(INVALID_HANDLE),
                               m_subwindow_shortname(""),
                               m_subwindows_total(1)

  {
//---  
   if(!::MQLInfoInteger(MQL_TESTER))
      ::EventSetMillisecondTimer(TIMER_STEP_MSC);
//---  ID  
   m_chart.Attach();
//---     
   m_chart.EventMouseMove(true);
//---   
   DetermineSubwindow();
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CWndEvents::~CWndEvents(void)
  {
//---  
   ::EventKillTimer();
//---  
   m_chart.MouseScroll(true);
   m_chart.SetInteger(CHART_DRAG_TRADE_LEVELS,true);
//---     
   m_chart.EventMouseMove(false);
//---   
   m_chart.Detach();
//---   
   DeleteExpertSubwindow();
//---     
   ::Comment("");
  }
//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CWndEvents::InitChartEventsParams(const int id,const long lparam,const double dparam,const string sparam)
  {
   m_id     =id;
   m_lparam =lparam;
   m_dparam =dparam;
   m_sparam =sparam;
  }
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+
void CWndEvents::ChartEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
//---   , 
   if(CWndContainer::WindowsTotal()<1)
      return;
//---    
   InitChartEventsParams(id,lparam,dparam,sparam);
//---   
   m_mouse.OnEvent(id,lparam,dparam,sparam);
//---  
   ChartEventCustom();
//---    
   CheckElementsEvents();
//---   
   ChartEventMouseMove();
//---    
   ChartEventChartChange();
  }
//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
void CWndEvents::CheckElementsEvents(void)
  {
   int elements_total=CWndContainer::ElementsTotal(m_active_window_index);
   for(int e=0; e<elements_total; e++)
      m_wnd[m_active_window_index].m_elements[e].OnEvent(m_id,m_lparam,m_dparam,m_sparam);
//---     
   OnEvent(m_id,m_lparam,m_dparam,m_sparam);
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT_CUSTOM                                        |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventCustom(void)
  {
//---    
   if(OnWindowRollUp())
      return;
//---    
   if(OnWindowUnroll())
      return;
//---        X
   if(OnWindowChangeXSize())
      return;
//---        Y
   if(OnWindowChangeYSize())
      return;
//---         
   if(OnHideBackContextMenus())
      return;
//---       
   if(OnHideContextMenus())
      return;

//---      
   if(OnOpenDialogBox())
      return;
//---      
   if(OnCloseDialogBox())
      return;
//---         
   if(OnResetWindowColors())
      return;
//---          
   if(OnZeroPriorities())
      return;
//---          
   if(OnSetPriorities())
      return;
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT CLICK                                         |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventClick(void)
  {
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT MOUSE MOVE                                    |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventMouseMove(void)
  {
//--- ,      
   if(m_id!=CHARTEVENT_MOUSE_MOVE)
      return;
//---  
   MovingWindow();
//---   
   SetChartState();
//---  
   m_chart.Redraw();
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT OBJECT CLICK                                  |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventObjectClick(void)
  {
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT OBJECT ENDEDIT                                |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventEndEdit(void)
  {
  }
//+------------------------------------------------------------------+
//|  CHARTEVENT CHART CHANGE                                  |
//+------------------------------------------------------------------+
void CWndEvents::ChartEventChartChange(void)
  {
//---    
   if(m_id!=CHARTEVENT_CHART_CHANGE)
      return;
//---      
   CheckExpertSubwindowNumber();
//---      
   CheckSubwindowNumber();
//---  
   MovingWindow();
//---     
   ResizeLockedWindow();
//---  
   m_chart.Redraw();
  }
//+------------------------------------------------------------------+
//|                                                            |
//+------------------------------------------------------------------+
void CWndEvents::OnTimerEvent(void)
  {
//---   ,   
   if(CWndContainer::WindowsTotal()<1)
      return;
//---      
   CheckElementsEventsTimer();
//---  
   m_chart.Redraw();
  }
//+------------------------------------------------------------------+
//|  ON_WINDOW_ROLLUP                                         |
//+------------------------------------------------------------------+
bool CWndEvents::OnWindowRollUp(void)
  {
//---    
   if(m_id!=CHARTEVENT_CUSTOM+ON_WINDOW_ROLLUP)
      return(false);
//---       
   if(m_lparam==m_windows[0].Id() && (int)m_dparam==m_subwin)
     {
      int elements_total=CWndContainer::ElementsTotal(0);
      for(int e=0; e<elements_total; e++)
        {
         //---     
         if(m_wnd[0].m_elements[e].ClassName()!="CWindow")
            m_wnd[0].m_elements[e].Hide();
        }
      //---   
      m_windows[0].ResetColors();
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_WINDOW_UNROLL                                         |
//+------------------------------------------------------------------+
bool CWndEvents::OnWindowUnroll(void)
  {
//---   " "
   if(m_id!=CHARTEVENT_CUSTOM+ON_WINDOW_UNROLL)
      return(false);
//---   
   int awi=m_active_window_index;
//---       
   if(m_lparam==m_windows[awi].Id() && (int)m_dparam==m_subwin)
     {
      int elements_total=CWndContainer::ElementsTotal(awi);
      for(int e=0; e<elements_total; e++)
        {
         //---        ...
         if(m_wnd[awi].m_elements[e].ClassName()!="CWindow")
           {
            //--- ...  ,   
            if(!m_wnd[awi].m_elements[e].IsDropdown())
               m_wnd[awi].m_elements[e].Show();
            //---   ,   
            if(m_wnd[awi].m_elements[e].AutoYResizeMode())
               m_wnd[awi].m_elements[e].ChangeHeightByBottomWindowSide();
           }
         else
           {
            //---  ,   
            if(m_windows[awi].AutoYResizeMode())
               m_windows[awi].ChangeWindowHeight(m_chart.HeightInPixels(m_subwin)-3);
           }
        }
      //---   
      m_windows[0].ResetColors();
      //---   ,     
      int tabs_total=CWndContainer::TabsTotal(awi);
      for(int t=0; t<tabs_total; t++)
         m_wnd[awi].m_tabs[t].ShowTabElements();
      //---    ,      -
      int treeview_total=CWndContainer::TreeViewListsTotal(awi);
      for(int tv=0; tv<treeview_total; tv++)
         m_wnd[awi].m_treeview_lists[tv].ShowTabElements();
     }
//---    
   MovingWindow();
   m_chart.Redraw();
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_WINDOW_CHANGE_XSIZE                                   |
//+------------------------------------------------------------------+
bool CWndEvents::OnWindowChangeXSize(void)
  {
//---   "  "
   if(m_id!=CHARTEVENT_CUSTOM+ON_WINDOW_CHANGE_XSIZE)
      return(false);
//---   
   int awi=m_active_window_index;
//---    
   if(m_lparam!=m_windows[awi].Id())
      return(true);
//---      
   int elements_total=CWndContainer::ElementsTotal(awi);
   for(int e=0; e<elements_total; e++)
     {
      //---  ,    
      if(m_wnd[awi].m_elements[e].ClassName()=="CWindow")
         continue;
      //---   ,   
      if(m_wnd[awi].m_elements[e].AutoXResizeMode())
         m_wnd[awi].m_elements[e].ChangeWidthByRightWindowSide();
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_WINDOW_CHANGE_YSIZE                                   |
//+------------------------------------------------------------------+
bool CWndEvents::OnWindowChangeYSize(void)
  {
//---   "  "
   if(m_id!=CHARTEVENT_CUSTOM+ON_WINDOW_CHANGE_YSIZE)
      return(false);
//---   
   int awi=m_active_window_index;
//---    
   if(m_lparam!=m_windows[awi].Id())
      return(true);
//---      
   int elements_total=CWndContainer::ElementsTotal(awi);
   for(int e=0; e<elements_total; e++)
     {
      //---  ,    
      if(m_wnd[awi].m_elements[e].ClassName()=="CWindow")
         continue;
      //---   ,   
      if(m_wnd[awi].m_elements[e].AutoYResizeMode())
         m_wnd[awi].m_elements[e].ChangeHeightByBottomWindowSide();
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_HIDE_BACK_CONTEXTMENUS                                |
//+------------------------------------------------------------------+
bool CWndEvents::OnHideBackContextMenus(void)
  {
//---         
   if(m_id!=CHARTEVENT_CUSTOM+ON_HIDE_BACK_CONTEXTMENUS)
      return(false);
//---       
   int awi=m_active_window_index;
   int context_menus_total=CWndContainer::ContextMenusTotal(awi);
   for(int i=context_menus_total-1; i>=0; i--)
     {
      //---       
      CContextMenu *cm=m_wnd[awi].m_context_menus[i];
      CMenuItem    *mi=cm.PrevNodePointer();
      //---       , ...
      if(::CheckPointer(mi)==POINTER_INVALID)
         continue;
      //---      , ...
      if(mi.Id()==m_lparam)
        {
         //--- ... ,      ,  
         if(!cm.MouseFocus())
            cm.Hide();
         //---       , ...
         if(::CheckPointer(mi.PrevNodePointer())==POINTER_INVALID)
           {
            //--- ... 
            m_windows[awi].IsLocked(false);
           }
         //---  
         break;
        }
      else
        {
         //---   
         cm.Hide();
        }
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_HIDE_CONTEXTMENUS                                     |
//+------------------------------------------------------------------+
bool CWndEvents::OnHideContextMenus(void)
  {
//---       
   if(m_id!=CHARTEVENT_CUSTOM+ON_HIDE_CONTEXTMENUS)
      return(false);
//---    
   int awi=m_active_window_index;
   int cm_total=CWndContainer::ContextMenusTotal(awi);
   for(int i=0; i<cm_total; i++)
      m_wnd[awi].m_context_menus[i].Hide();
//---   
   int menu_bars_total=CWndContainer::MenuBarsTotal(awi);
   for(int i=0; i<menu_bars_total; i++)
      m_wnd[awi].m_menu_bars[i].State(false);
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_OPEN_DIALOG_BOX                                       |
//+------------------------------------------------------------------+
bool CWndEvents::OnOpenDialogBox(void)
  {
//---      
   if(m_id!=CHARTEVENT_CUSTOM+ON_OPEN_DIALOG_BOX)
      return(false);
//--- ,     
   if(m_sparam!=m_program_name)
      return(true);
//---    
   int window_total=CWndContainer::WindowsTotal();
   for(int w=0; w<window_total; w++)
     {
      //---   
      if(m_windows[w].Id()==m_lparam)
        {
         //---      ,     
         m_windows[w].PrevActiveWindowIndex(m_active_window_index);
         //---  
         m_windows[w].State(true);
         //---         
         m_windows[w].SetZorders();
         //---    
         m_active_window_index=w;
         //---      
         int elements_total=CWndContainer::ElementsTotal(w);
         for(int e=0; e<elements_total; e++)
           {
            //---     
            if(m_wnd[w].m_elements[e].ClassName()=="CWindow" || 
               m_wnd[w].m_elements[e].IsDropdown())
               continue;
            //---   
            m_wnd[w].m_elements[e].Show();
            //---        
            m_wnd[w].m_elements[e].SetZorders();
           }
         //---   
         int tooltips_total=CWndContainer::TooltipsTotal(m_windows[w].PrevActiveWindowIndex());
         for(int t=0; t<tooltips_total; t++)
            m_wnd[m_windows[w].PrevActiveWindowIndex()].m_tooltips[t].FadeOutTooltip();
         //---   ,     
         int tabs_total=CWndContainer::TabsTotal(w);
         for(int t=0; t<tabs_total; t++)
            m_wnd[w].m_tabs[t].ShowTabElements();
         //---    ,      -
         int treeview_total=CWndContainer::TreeViewListsTotal(w);
         for(int tv=0; tv<treeview_total; tv++)
            m_wnd[w].m_treeview_lists[tv].ShowTabElements();
        }
      //---    ,     
      else
        {
         //---  
         m_windows[w].State(false);
         //---         
         int elements_total=CWndContainer::ElementsTotal(w);
         for(int e=0; e<elements_total; e++)
            m_wnd[w].m_elements[e].ResetZorders();
        }
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_CLOSE_DIALOG_BOX                                      |
//+------------------------------------------------------------------+
bool CWndEvents::OnCloseDialogBox(void)
  {
//---      
   if(m_id!=CHARTEVENT_CUSTOM+ON_CLOSE_DIALOG_BOX)
      return(false);
//---    
   int window_total=CWndContainer::WindowsTotal();
   for(int w=0; w<window_total; w++)
     {
      //---   
      if(m_windows[w].Id()==m_lparam)
        {
         //---  
         m_windows[w].State(false);
         //---  
         int elements_total=CWndContainer::ElementsTotal(w);
         for(int e=0; e<elements_total; e++)
            m_wnd[w].m_elements[e].Hide();
         //---   
         m_windows[int(m_dparam)].State(true);
         //---  
         m_chart.Redraw();
         break;
        }
     }
//---    
   m_active_window_index=int(m_dparam);
//---          
   int elements_total=CWndContainer::ElementsTotal(m_active_window_index);
   for(int e=0; e<elements_total; e++)
      m_wnd[m_active_window_index].m_elements[e].SetZorders();
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_RESET_WINDOW_COLORS                                   |
//+------------------------------------------------------------------+
bool CWndEvents::OnResetWindowColors(void)
  {
//---      
   if(m_id!=CHARTEVENT_CUSTOM+ON_RESET_WINDOW_COLORS)
      return(false);
//---    ,    
   int index=WRONG_VALUE;
//---    
   int window_total=CWndContainer::WindowsTotal();
   for(int w=0; w<window_total; w++)
     {
      //---   
      if(m_windows[w].Id()==m_lparam)
        {
         //---  
         index=w;
         //---   
         m_windows[w].ResetColors();
         break;
        }
     }
//--- ,    
   if(index==WRONG_VALUE)
      return(true);
//---      
   int elements_total=CWndContainer::ElementsTotal(index);
   for(int e=0; e<elements_total; e++)
      m_wnd[index].m_elements[e].ResetColors();
//---  
   m_chart.Redraw();
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_ZERO_PRIORITIES                                       |
//+------------------------------------------------------------------+
bool CWndEvents::OnZeroPriorities(void)
  {
//---          
   if(m_id!=CHARTEVENT_CUSTOM+ON_ZERO_PRIORITIES)
      return(false);
//---
   int elements_total=CWndContainer::ElementsTotal(m_active_window_index);
   for(int e=0; e<elements_total; e++)
     {
      //---      ,  id      ...
      if(m_lparam!=m_wnd[m_active_window_index].m_elements[e].Id())
        {
         //--- ...   
         if(m_wnd[m_active_window_index].m_elements[e].ClassName()=="CMenuItem" ||
            m_wnd[m_active_window_index].m_elements[e].ClassName()=="CContextMenu")
            continue;
         //---
         m_wnd[m_active_window_index].m_elements[e].ResetZorders();
        }
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|  ON_SET_PRIORITIES                                        |
//+------------------------------------------------------------------+
bool CWndEvents::OnSetPriorities(void)
  {
//---          
   if(m_id!=CHARTEVENT_CUSTOM+ON_SET_PRIORITIES)
      return(false);
//---
   int elements_total=CWndContainer::ElementsTotal(m_active_window_index);
   for(int e=0; e<elements_total; e++)
      m_wnd[m_active_window_index].m_elements[e].SetZorders();
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void CWndEvents::MovingWindow(void)
  {
   int awi=m_active_window_index;
//---  
   int x=m_windows[awi].X();
   int y=m_windows[awi].Y();
   m_windows[awi].Moving(x,y);
//---   
   int elements_total=CWndContainer::ElementsTotal(awi);
   for(int e=0; e<elements_total; e++)
      m_wnd[awi].m_elements[e].Moving(x,y);
  }
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
void CWndEvents::CheckElementsEventsTimer(void)
  {
   int awi=m_active_window_index;
   int elements_total=CWndContainer::ElementsTotal(awi);
   for(int e=0; e<elements_total; e++)
      m_wnd[awi].m_elements[e].OnEventTimer();
  }
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
void CWndEvents::DetermineSubwindow(void)
  {
//--- ,    ""
   if(PROGRAM_TYPE==PROGRAM_SCRIPT)
      return;
//---   
   ::ResetLastError();
//---    
   if(PROGRAM_TYPE==PROGRAM_EXPERT)
     {
      //--- ,        
      if(!EXPERT_IN_SUBWINDOW)
         return;
      //---   - ( )
      m_subwindow_handle=iCustom(::Symbol(),::Period(),"::Indicators\\SubWindow.ex5");
      //---    ,     
      if(m_subwindow_handle==INVALID_HANDLE)
         ::Print(__FUNCTION__," >        ::Indicators\\SubWindow.ex5 !");
      //---   ,   ,      ,
      //      ,        
      else
        {
         //---     
         int subwindows_total=(int)::ChartGetInteger(m_chart_id,CHART_WINDOWS_TOTAL);
         //---      
         if(::ChartIndicatorAdd(m_chart_id,subwindows_total,m_subwindow_handle))
           {
            //---         
            m_subwin           =subwindows_total;
            m_subwindows_total =subwindows_total+1;
            //---       
            m_subwindow_shortname=::ChartIndicatorName(m_chart_id,m_subwin,0);
           }
         //---    
         else
            ::Print(__FUNCTION__," >     !  : ",::GetLastError());
        }
      //---
      return;
     }
//---    
   m_subwin=::ChartWindowFind();
//---     , 
   if(m_subwin<0)
     {
      ::Print(__FUNCTION__," >     : ",::GetLastError());
      return;
     }
//---      
   if(m_subwin>0)
     {
      //---       
      int total=::ChartIndicatorsTotal(m_chart_id,m_subwin);
      //---       
      string indicator_name=::ChartIndicatorName(m_chart_id,m_subwin,total-1);
      //---      ,     
      if(total!=1)
        {
         ::Print(__FUNCTION__," >      .");
         ::ChartIndicatorDelete(m_chart_id,m_subwin,indicator_name);
         return;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CWndEvents::DeleteExpertSubwindow(void)
  {
//--- ,    
   if(PROGRAM_TYPE!=PROGRAM_EXPERT)
      return;
//--- ,   
   if(m_subwindow_handle==INVALID_HANDLE)
      return;
//---     
   int windows_total=(int)::ChartGetInteger(m_chart_id,CHART_WINDOWS_TOTAL);
//---   
   for(int w=0; w<windows_total; w++)
     {
      //---      ( SubWindow.ex5)
      string indicator_name=::ChartIndicatorName(m_chart_id,w,0);
      //---   ,     
      if(indicator_name!=m_subwindow_shortname || w!=m_subwin)
         continue;
      //---   
      if(!::ChartIndicatorDelete(m_chart_id,m_subwin,indicator_name))
         ::Print(__FUNCTION__," >     !  : ",::GetLastError());
     }
  }
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
void CWndEvents::CheckExpertSubwindowNumber(void)
  {
//--- ,    
   if(PROGRAM_TYPE!=PROGRAM_EXPERT)
      return;
//---     
   int subwindows_total=(int)::ChartGetInteger(m_chart_id,CHART_WINDOWS_TOTAL);
//--- ,        
   if(subwindows_total==m_subwindows_total)
      return;
//---    
   m_subwindows_total=subwindows_total;
//---     
   bool is_subwindow=false;
//---   
   for(int sw=0; sw<subwindows_total; sw++)
     {
      //---  ,    
      if(is_subwindow)
         break;
      //---     /
      int indicators_total=::ChartIndicatorsTotal(m_chart_id,sw);
      //---      
      for(int i=0; i<indicators_total; i++)
        {
         //---    
         string indicator_name=::ChartIndicatorName(m_chart_id,sw,i);
         //---     ,   
         if(indicator_name!=m_subwindow_shortname)
            continue;
         //--- ,    
         is_subwindow=true;
         //---    ,  
         //            
         if(sw!=m_subwin)
           {
            //---   
            m_subwin=sw;
            //---         
            int elements_total=CWndContainer::ElementsTotal(0);
            for(int e=0; e<elements_total; e++)
               m_wnd[0].m_elements[e].SubwindowNumber(m_subwin);
           }
         //---
         break;
        }
     }
//---     ,  
   if(!is_subwindow)
     {
      ::Print(__FUNCTION__," >       !");
      //---    
      ::ExpertRemove();
     }
  }
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
void CWndEvents::CheckSubwindowNumber(void)
  {
//--- ,    
   if(PROGRAM_TYPE!=PROGRAM_INDICATOR)
      return;
//---        
   if(m_subwin!=0 && m_subwin!=::ChartWindowFind())
     {
      //---   
      DetermineSubwindow();
      //---    
      int windows_total=CWndContainer::WindowsTotal();
      for(int w=0; w<windows_total; w++)
        {
         int elements_total=CWndContainer::ElementsTotal(w);
         for(int e=0; e<elements_total; e++)
            m_wnd[w].m_elements[e].SubwindowNumber(m_subwin);
        }
     }
  }
//+------------------------------------------------------------------+
//|                     |
//+------------------------------------------------------------------+
void CWndEvents::ResizeLockedWindow(void)
  {
//--- ,    
   if(CWndContainer::WindowsTotal()<1)
      return;
//---      ,     
   if(m_windows[0].IsLocked() && (m_windows[0].AutoXResizeMode() || m_windows[0].AutoXResizeMode()))
     {
      int elements_total=CWndContainer::ElementsTotal(0);
      for(int e=0; e<elements_total; e++)
        {
         //---   
         if(m_wnd[0].m_elements[e].ClassName()=="CWindow")
           {
            m_wnd[0].m_elements[e].OnEvent(m_id,m_lparam,m_dparam,m_sparam);
            continue;
           }
         //---   ,    
         if(m_wnd[0].m_elements[e].AutoXResizeMode())
            m_wnd[0].m_elements[e].ChangeWidthByRightWindowSide();
         //---   ,    
         if(m_wnd[0].m_elements[e].AutoYResizeMode())
            m_wnd[0].m_elements[e].ChangeHeightByBottomWindowSide();
         //---   
         m_wnd[0].m_elements[e].Moving(m_windows[0].X(),m_windows[0].Y());
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void CWndEvents::ResetWindow(void)
  {
   if(CWndContainer::WindowsTotal()<1)
      return;
//---
   int awi=m_active_window_index;
//---
   m_windows[awi].Reset();
//---
   int elements_total=CWndContainer::ElementsTotal(awi);
   for(int e=0; e<elements_total; e++)
     {
      if(m_wnd[awi].m_elements[e].IsVisible())
         m_wnd[awi].m_elements[e].Reset();
     }
//---
   int tabs_total=CWndContainer::TabsTotal(awi);
   for(int e=0; e<tabs_total; e++)
      m_wnd[awi].m_tabs[e].ShowTabElements();
  }
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
void CWndEvents::Destroy(void)
  {
//---    
   m_active_window_index=0;
//---   
   int window_total=CWndContainer::WindowsTotal();
//---    
   for(int w=0; w<window_total; w++)
     {
      //---   
      if(m_windows[w].WindowType()==W_MAIN)
         m_windows[w].State(true);
      //---   
      else
         m_windows[w].State(false);
     }
//---   
   for(int w=0; w<window_total; w++)
     {
      int elements_total=CWndContainer::ElementsTotal(w);
      for(int e=0; e<elements_total; e++)
        {
         //---   ,   
         if(::CheckPointer(m_wnd[w].m_elements[e])==POINTER_INVALID)
            continue;
         //---   
         m_wnd[w].m_elements[e].Delete();
        }
      //---   
      ::ArrayFree(m_wnd[w].m_objects);
      ::ArrayFree(m_wnd[w].m_elements);
      ::ArrayFree(m_wnd[w].m_menu_bars);
      ::ArrayFree(m_wnd[w].m_context_menus);
      ::ArrayFree(m_wnd[w].m_tooltips);
      ::ArrayFree(m_wnd[w].m_drop_lists);
      ::ArrayFree(m_wnd[w].m_scrolls);
      ::ArrayFree(m_wnd[w].m_labels_tables);
      ::ArrayFree(m_wnd[w].m_tables);
      ::ArrayFree(m_wnd[w].m_canvas_tables);
      ::ArrayFree(m_wnd[w].m_tabs);
      ::ArrayFree(m_wnd[w].m_calendars);
      ::ArrayFree(m_wnd[w].m_drop_calendars);
      ::ArrayFree(m_wnd[w].m_treeview_lists);
      ::ArrayFree(m_wnd[w].m_file_navigators);
     }
//---   
   ::ArrayFree(m_wnd);
   ::ArrayFree(m_windows);
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
void CWndEvents::SetChartState(void)
  {
   int awi=m_active_window_index;
//---   ,    
   bool condition=false;
//---  
   int windows_total=CWndContainer::WindowsTotal();
   for(int i=0; i<windows_total; i++)
     {
      //---   ,    
      if(!m_windows[i].IsVisible())
         continue;
      //---      
      m_windows[i].OnEvent(m_id,m_lparam,m_dparam,m_sparam);
      //---   ,  
      if(m_windows[i].MouseFocus())
        {
         condition=true;
         break;
        }
     }
//---   
   if(!condition)
     {
      //---     
      int drop_lists_total=CWndContainer::DropListsTotal(awi);
      for(int i=0; i<drop_lists_total; i++)
        {
         //---     
         CListView *lv=m_wnd[awi].m_drop_lists[i];
         //---    ()
         if(lv.IsVisible())
           {
            //---         
            if(m_wnd[awi].m_drop_lists[i].MouseFocus() || lv.ScrollState())
              {
               condition=true;
               break;
              }
           }
        }
     }
//---  
   if(!condition)
     {
      int drop_calendars_total=CWndContainer::DropCalendarsTotal(awi);
      for(int i=0; i<drop_calendars_total; i++)
        {
         if(m_wnd[awi].m_drop_calendars[i].GetCalendarPointer().MouseFocus())
           {
            condition=true;
            break;
           }
        }
     }
//---    
   if(!condition)
     {
      //---      
      int context_menus_total=CWndContainer::ContextMenusTotal(awi);
      for(int i=0; i<context_menus_total; i++)
        {
         //---     
         if(m_wnd[awi].m_context_menus[i].MouseFocus())
           {
            condition=true;
            break;
           }
        }
     }
//---    
   if(!condition)
     {
      int scrolls_total=CWndContainer::ScrollsTotal(awi);
      for(int i=0; i<scrolls_total; i++)
        {
         if(((CScroll*)m_wnd[awi].m_scrolls[i]).ScrollState())
           {
            condition=true;
            break;
           }
        }
     }
//---      
   for(int i=0; i<windows_total; i++)
      m_windows[i].CustomEventChartState(condition);
  }
//+------------------------------------------------------------------+
