//+------------------------------------------------------------------+
//|                                                        Mouse.mqh |
//|                        Copyright 2016, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Charts\Chart.mqh>
//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+
class CMouse
  {
private:
   //---     
   CChart            m_chart;
   //--- 
   int               m_x;
   int               m_y;
   //---  ,    
   int               m_subwin;
   //---    X
   datetime          m_time;
   //---  ()   Y
   double            m_level;
   //---     (/)
   bool              m_left_button_state;
   //---
public:
                     CMouse(void);
                    ~CMouse(void);
   //---  
   void              OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);

   //---  
   int               X(void)               const { return(m_x);                 }
   int               Y(void)               const { return(m_y);                 }
   //--- (1)   ,    , (2)    X, 
   //    (3)  ()   Y
   int               SubWindowNumber(void) const { return(m_subwin);            }
   datetime          Time(void)            const { return(m_time);              }
   double            Level(void)           const { return(m_level);             }
   //---      (/)
   bool              LeftButtonState(void) const { return(m_left_button_state); }
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CMouse::CMouse(void) : m_x(0),
                       m_y(0),
                       m_subwin(WRONG_VALUE),
                       m_time(NULL),
                       m_level(0.0),
                       m_left_button_state(false)
  {
//---  ID  
   m_chart.Attach();
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CMouse::~CMouse(void)
  {
//---   
   m_chart.Detach();
  }
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
void CMouse::OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
//---    
   if(id==CHARTEVENT_MOUSE_MOVE)
     {
      //---      
      m_x                 =(int)lparam;
      m_y                 =(int)dparam;
      m_left_button_state =(bool)int(sparam);
      //---   
      if(!::ChartXYToTimePrice(0,m_x,m_y,m_subwin,m_time,m_level))
         return;
      //---    Y
      if(m_subwin>0)
         m_y=m_y-m_chart.SubwindowY(m_subwin);
     }
  }
//+------------------------------------------------------------------+
