//+------------------------------------------------------------------+
//|                                            PercentageofTrend.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum 0.00
#property indicator_maximum 1.00
#property indicator_level1 0.20
#property indicator_level2 0.80

#property indicator_buffers 2
#property indicator_plots   1
//--- plot Period1
#property indicator_label1  "Period"
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrForestGreen,clrDarkGray,clrCrimson
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

//--- input parameters
input int               InpPeriod=20;
input double            UpTrendLevel=0.8;
input double            DnTrendLevel=0.2;
//--- indicator buffers
double         PeriodBuffer[];
double         ColorsBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator digits
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//--- indicator buffers mapping
   SetIndexBuffer(0,PeriodBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ColorsBuffer,INDICATOR_COLOR_INDEX);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int max=InpPeriod;
   int pos;
   int bars=Bars(_Symbol,_Period);
   if(bars<max) return(0);
   if(prev_calculated>max) pos=prev_calculated;
   else pos = max;
   for(int i=pos; i<rates_total;i++)
     {
      double   HighValue1= 0;
      double   LowValue1 = 0;

      for(int cnt=i-InpPeriod+1; cnt<i+1;cnt++)
        {
         if(high[cnt]>HighValue1) HighValue1=high[cnt];
        }

      for(int cnt=i-InpPeriod+1; cnt<i+1;cnt++)
        {
         if(cnt==i-InpPeriod+1) LowValue1=low[cnt];
         if(low[cnt]<LowValue1) LowValue1=low[cnt];
        }

      PeriodBuffer[i]=(close[i]-LowValue1)/(HighValue1-LowValue1);

      if(PeriodBuffer[i]>=UpTrendLevel)
         ColorsBuffer[i]=0;
      else if(PeriodBuffer[i]<=DnTrendLevel)
                               ColorsBuffer[i]=2;
      else
         ColorsBuffer[i]=1;
     }
   return(rates_total);
  }
//+------------------------------------------------------------------+
