//+------------------------------------------------------------------+
//|                                                      Element.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include "Mouse.mqh"
#include "Objects.mqh"
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
class CElement
  {
protected:
   //---      
   CColors           m_clr;
   //---      
   CMouse           *m_mouse;
   //---         
   CChartObject     *m_objects[];

   //--- (1)    (2) , (3)  
   string            m_class_name;
   string            m_program_name;
   ENUM_PROGRAM_TYPE m_program_type;
   //---     
   long              m_chart_id;
   int               m_subwin;
   //---    
   int               m_id;
   int               m_index;
   //---   
   int               m_x;
   int               m_y;
   int               m_x2;
   int               m_y2;
   //--- 
   int               m_x_size;
   int               m_y_size;
   //--- 
   int               m_x_gap;
   int               m_y_gap;
   //---  
   bool              m_is_visible;
   bool              m_is_dropdown;
   //--- 
   bool              m_mouse_focus;
   //---      
   ENUM_BASE_CORNER  m_corner;
   ENUM_ANCHOR_POINT m_anchor;
   //---    
   int               m_gradient_colors_total;
   //---     
   bool              m_auto_xresize_mode;
   bool              m_auto_yresize_mode;
   //---   /     - / 
   int               m_auto_xresize_right_offset;
   int               m_auto_yresize_bottom_offset;
   //---         
   bool              m_anchor_right_window_side;
   bool              m_anchor_bottom_window_side;
   //---
public:
                     CElement(void);
                    ~CElement(void);
   //--- (1)   (2)   
   void              MousePointer(CMouse &object)                    { m_mouse=::GetPointer(object);         }
   CMouse           *MousePointer(void)                        const { return(::GetPointer(m_mouse));        }
   //--- (1)     
   string            ClassName(void)                           const { return(m_class_name);                 }
   void              ClassName(const string class_name)              { m_class_name=class_name;              }
   //--- (1)   , (2)   , (3)    
   string            ProgramName(void)                         const { return(m_program_name);               }
   ENUM_PROGRAM_TYPE ProgramType(void)                         const { return(m_program_type);               }
   void              SubwindowNumber(const int number)               { m_subwin=number;                      }
   //---      
   CChartObject     *Object(const int index);
   //--- (1)    , (2)   
   int               ObjectsElementTotal(void)                 const { return(::ArraySize(m_objects));       }
   void              FreeObjectsArray(void)                          { ::ArrayFree(m_objects);               }
   //---     
   void              Id(const int id)                                { m_id=id;                              }
   int               Id(void)                                  const { return(m_id);                         }
   //---     
   void              Index(const int index)                          { m_index=index;                        }
   int               Index(void)                               const { return(m_index);                      }
   //---   
   int               X(void)                                   const { return(m_x);                          }
   void              X(const int x)                                  { m_x=x;                                }
   int               Y(void)                                   const { return(m_y);                          }
   void              Y(const int y)                                  { m_y=y;                                }
   int               X2(void)                                  const { return(m_x+m_x_size);                 }
   int               Y2(void)                                  const { return(m_y+m_y_size);                 }
   //--- 
   int               XSize(void)                               const { return(m_x_size);                     }
   void              XSize(const int x_size)                         { m_x_size=x_size;                      }
   int               YSize(void)                               const { return(m_y_size);                     }
   void              YSize(const int y_size)                         { m_y_size=y_size;                      }
   //---     (xy)
   int               XGap(void)                                const { return(m_x_gap);                      }
   void              XGap(const int x_gap)                           { m_x_gap=x_gap;                        }
   int               YGap(void)                                const { return(m_y_gap);                      }
   void              YGap(const int y_gap)                           { m_y_gap=y_gap;                        }
   //---   
   void              IsVisible(const bool flag)                      { m_is_visible=flag;                    }
   bool              IsVisible(void)                           const { return(m_is_visible);                 }
   //---   
   void              IsDropdown(const bool flag)                     { m_is_dropdown=flag;                   }
   bool              IsDropdown(void)                          const { return(m_is_dropdown);                }
   //--- (1) , (2)   
   bool              MouseFocus(void)                          const { return(m_mouse_focus);                }
   void              MouseFocus(const bool focus)                    { m_mouse_focus=focus;                  }
   void              GradientColorsTotal(const int total)            { m_gradient_colors_total=total;        }
   //--- (1)  -  , (2) /     
   bool              AutoXResizeMode(void)                     const { return(m_auto_xresize_mode);          }
   void              AutoXResizeMode(const bool flag)                { m_auto_xresize_mode=flag;             }
   int               AutoXResizeRightOffset(void)              const { return(m_auto_xresize_right_offset);  }
   void              AutoXResizeRightOffset(const int offset)        { m_auto_xresize_right_offset=offset;   }
   //--- (1)  -  , (2) /     
   bool              AutoYResizeMode(void)                     const { return(m_auto_yresize_mode);          }
   void              AutoYResizeMode(const bool flag)                { m_auto_yresize_mode=flag;             }
   int               AutoYResizeBottomOffset(void)             const { return(m_auto_yresize_bottom_offset); }
   void              AutoYResizeBottomOffset(const int offset)       { m_auto_yresize_bottom_offset=offset;  }
   //---  (/)    (1)   (2)   
   bool              AnchorRightWindowSide(void)               const { return(m_anchor_right_window_side);   }
   void              AnchorRightWindowSide(const bool flag)          { m_anchor_right_window_side=flag;      }
   bool              AnchorBottomWindowSide(void)              const { return(m_anchor_bottom_window_side);  }
   void              AnchorBottomWindowSide(const bool flag)         { m_anchor_bottom_window_side=flag;     }
   //---
public:
   //---   
   virtual void      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam) {}
   //--- 
   virtual void      OnEventTimer(void) {}
   //---  
   virtual void      Moving(const int x,const int y) {}
   //--- (1) , (2) , (3) , (4) 
   virtual void      Show(void) {}
   virtual void      Hide(void) {}
   virtual void      Reset(void) {}
   virtual void      Delete(void) {}
   //--- (1) , (2)       
   virtual void      SetZorders(void) {}
   virtual void      ResetZorders(void) {}
   //---   
   virtual void      ResetColors(void) {}
   //---      
   virtual void      ChangeWidthByRightWindowSide(void) {}
   //---      
   virtual void      ChangeHeightByBottomWindowSide(void) {}
   //---
protected:
   //---     
   bool              CheckWindowPointer(ENUM_POINTER_TYPE pointer_type);
   //---     -   
   void              AddToArray(CChartObject &object);
   //---   
   void              InitColorArray(const color outer_color,const color hover_color,color &color_array[]);
   //---   
   void              ChangeObjectColor(const string name,const bool mouse_focus,const ENUM_OBJECT_PROPERTY_INTEGER property,
                                       const color outer_color,const color hover_color,const color &color_array[]);

   //---     
   int               IdFromObjectName(const string object_name);
   //---      
   int               IndexFromObjectName(const string object_name);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CElement::CElement(void) : m_x(0),
                           m_y(0),
                           m_x2(0),
                           m_y2(0),
                           m_x_size(0),
                           m_y_size(0),
                           m_x_gap(0),
                           m_y_gap(0),
                           m_is_visible(true),
                           m_is_dropdown(false),
                           m_mouse_focus(false),
                           m_id(WRONG_VALUE),
                           m_index(WRONG_VALUE),
                           m_gradient_colors_total(3),
                           m_corner(CORNER_LEFT_UPPER),
                           m_anchor(ANCHOR_LEFT_UPPER),
                           m_program_name(PROGRAM_NAME),
                           m_program_type(PROGRAM_TYPE),
                           m_class_name(""),
                           m_auto_xresize_mode(false),
                           m_auto_yresize_mode(false),
                           m_auto_xresize_right_offset(0),
                           m_auto_yresize_bottom_offset(0),
                           m_anchor_right_window_side(false),
                           m_anchor_bottom_window_side(false)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CElement::~CElement(void)
  {
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+
CChartObject *CElement::Object(const int index)
  {
   int array_size=::ArraySize(m_objects);
//---    
   if(array_size<1)
     {
      ::Print(__FUNCTION__," >    ("+m_class_name+")  !");
      return(NULL);
     }
//---      
   int i=(index>=array_size)? array_size-1 :(index<0)? 0 : index;
//---   
   return(m_objects[i]);
  }
//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+
bool CElement::CheckWindowPointer(ENUM_POINTER_TYPE pointer_type)
  {
//---     
   if(pointer_type==POINTER_INVALID)
     {
      //---  
      string message=__FUNCTION__+" >        : "+ClassName()+"::WindowPointer(CWindow &object)";
      //---     
      ::Print(message);
      //---     
      return(false);
     }
//---    
   return(true);
  }
//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CElement::AddToArray(CChartObject &object)
  {
   int size=ObjectsElementTotal();
   ::ArrayResize(m_objects,size+1);
   m_objects[size]=::GetPointer(object);
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
void CElement::InitColorArray(const color outer_color,const color hover_color,color &color_array[])
  {
//---   
   color colors[2];
   colors[0]=outer_color;
   colors[1]=hover_color;
//---   
   m_clr.Gradient(colors,color_array,m_gradient_colors_total);
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
void CElement::ChangeObjectColor(const string name,const bool mouse_focus,const ENUM_OBJECT_PROPERTY_INTEGER property,
                                 const color outer_color,const color hover_color,const color &color_array[])
  {
   if(::ArraySize(color_array)<1)
      return;
//---    
   color current_color=(color)::ObjectGetInteger(m_chart_id,name,property);
//---    
   if(mouse_focus)
     {
      //--- ,     
      if(current_color==hover_color)
         return;
      //---     
      for(int i=0; i<m_gradient_colors_total; i++)
        {
         //---    ,   
         if(color_array[i]!=current_color)
            continue;
         //---
         color new_color=(i+1==m_gradient_colors_total)? color_array[i]: color_array[i+1];
         //---  
         ::ObjectSetInteger(m_chart_id,name,property,new_color);
         break;
        }
     }
//---     
   else
     {
      //--- ,     
      if(current_color==outer_color)
         return;
      //---     
      for(int i=m_gradient_colors_total-1; i>=0; i--)
        {
         //---    ,   
         if(color_array[i]!=current_color)
            continue;
         //---
         color new_color=(i-1<0)? color_array[i]: color_array[i-1];
         //---  
         ::ObjectSetInteger(m_chart_id,name,property,new_color);
         break;
        }
     }
  }
//+------------------------------------------------------------------+
//|                              |
//+------------------------------------------------------------------+
int CElement::IdFromObjectName(const string object_name)
  {
//---  id   
   int    length =::StringLen(object_name);
   int    pos    =::StringFind(object_name,"__",0);
   string id     =::StringSubstr(object_name,pos+2,length-1);
//---  id 
   return((int)id);
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
int CElement::IndexFromObjectName(const string object_name)
  {
   ushort u_sep=0;
   string result[];
   int    array_size=0;
//---   
   u_sep=::StringGetCharacter("_",0);
//---  
   ::StringSplit(object_name,u_sep,result);
   array_size=::ArraySize(result)-1;
//---     
   if(array_size-2<0)
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---   
   return((int)result[array_size-2]);
  }
//+------------------------------------------------------------------+
