//+------------------------------------------------------------------+
//|                                   eIncGUI_v2_Test_CVSrollBar.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CVScrollBar vsb;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CVSrollBar
   vsb.Init("CVSrollBar",100,1);
   vsb.SetPos(10,180);
   vsb.SetSubWindow("TestSubWindow");
   vsb.Show();

   w.Button("b1",0,10,20,350,20,"   10");
   w.Button("b2",0,10,45,350,20,"   50");
   w.Button("b3",0,10,70,350,20,"   90");   
   w.Button("b4",0,10,95,350,20," Min=100, Max=10000, SmallChange=100, LageChange=1000");
   w.Button("b5",0,10,120,350,20," Min=1, Max=100, SmallChange=1, LageChange=10");
   w.Button("b6",0,10,145,350,20," ");      
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   w.Delete("b5");
   w.Delete("b6");   
   vsb.Hide();  
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=vsb.Event(id,lparam,dparam,sparam);
      if(ev==1){
         Alert("CVSrollBar.   "+DoubleToString(vsb.Value(),0)); 
      }
      if(CHARTEVENT_CHART_CHANGE){
         vsb.SetSubWindow("TestSubWindow");
      }         
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            vsb.SetValue(10);
            g.SetState(sparam,false);
            g.Redraw();
         }
         if(sparam=="b2"){
            vsb.SetValue(50);
            g.SetState(sparam,false);
            g.Redraw();
         }         
         if(sparam=="b3"){
            vsb.SetValue(90);
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b4"){
            vsb.SetMin(100);
            vsb.SetMax(10000);
            vsb.SetSmallChange(100);
            vsb.SetLageChange(1000);
            vsb.Refresh();
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b5"){
            vsb.SetMin(1);
            vsb.SetMax(100);
            vsb.SetSmallChange(1);
            vsb.SetLageChange(10);
            vsb.Refresh();
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b6"){
            Alert(": "+IntegerToString(vsb.Value()));
            g.SetState(sparam,false);
            g.Redraw();
         }  
      }
}