//+------------------------------------------------------------------+
//|                                eIncGUI_v2_Test_CSpinInputBox.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};



input eColorScheme ColorScheme=DefaultScheme;

CSpinInputBox sib;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CSpinInputBox
   sib.Init("CSpinInputBox",50,0.1,"CSpinInputBox");
   sib.SetPos(10,150);
   sib.SetMaxValue(1);
   sib.SetMinValue(0.1);
   sib.SetReadOnly(false);
   sib.SetSubWindow("TestSubWindow");
   sib.Show();

   w.Button("b1",0,10,20,250,20," ReadOnly");
   w.Button("b2",0,10,45,250,20," Warning");
   w.Button("b3",0,10,70,250,20,"  1.5"); 
   w.Button("b4",0,10,95,250,20,"  0.5"); 
   w.Button("b5",0,10,120,250,20,"  -0.5"); 
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");   
   w.Delete("b3");   
   w.Delete("b4");   
   w.Delete("b5");   
   sib.Hide();   
   
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=sib.Event(id,lparam,dparam,sparam);
      if(ev==1){
         Alert("InputBox.   "+DoubleToString(sib.Value(),sib.Digits())+" ()");
      }
      if(ev==2){
         Alert("InputBox.   "+DoubleToString(sib.Value(),sib.Digits())+" ( )");
      }  
      if(CHARTEVENT_CHART_CHANGE){
         sib.SetSubWindow("TestSubWindow");
      }    
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            sib.SetReadOnly(!sib.ReadOnly());
            Sleep(100);
            g.SetState(sparam,false);
            g.Redraw();
         }
         if(sparam=="b2"){
            sib.SetWarning(!sib.Warning());
            Sleep(100);
            g.SetState(sparam,false);
            g.Redraw();
         }    
         if(sparam=="b3"){
            sib.SetValue(1.5);
            Sleep(100);
            g.SetState(sparam,false);
            g.Redraw();
         }    
         if(sparam=="b4"){
            sib.SetValue(0.5);
            Sleep(100);
            g.SetState(sparam,false);
            g.Redraw();
         }   
         if(sparam=="b5"){
            sib.SetValue(-0.5);
            Sleep(100);
            g.SetState(sparam,false);
            g.Redraw();
         }                               
      }
}