//+------------------------------------------------------------------+
//|                                      eIncGUI_v2_Test_CListMS.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CListMS lstm;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CListMS
   lstm.Init("CListMS",100,8);
   lstm.SetPos(10,200);
      for(int i=0;i<55;i++){
         lstm.AddItem("Item-"+IntegerToString(i));
      }  
   lstm.SetSubWindow("TestSubWindow");      
   lstm.Show();  
   lstm.SetSelected(0,true);           
   lstm.SetSelected(2,true);

   w.Button("b1",0,10,20,250,20," 1");
   w.Button("b2",0,10,45,250,20," 2");
   w.Button("b3",0,10,70,250,20,"   ");   
   w.Button("b4",0,10,95,250,20,"  ");   
   w.Button("b5",0,10,120,250,20,"  ");   
   w.Button("b6",0,10,145,250,20,"  ");   
   w.Button("b7",0,10,170,250,20," ");      
   w.Redraw();
   return(0);

   
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   w.Delete("b5");
   w.Delete("b6");  
   w.Delete("b7");   
   lstm.Hide();
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=lstm.Event(id,lparam,dparam,sparam);  
      if(ev==1){
         Alert("CListMS.     "+lstm.Text(lstm.LastChanged())); 
      }
      if(ev==2){
         Alert("CListMS.     "+lstm.Text(lstm.LastChanged())); 
      }
      if(CHARTEVENT_CHART_CHANGE){
         lstm.SetSubWindow("TestSubWindow");
      }          
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            lstm.Clear();
               for(int i=0;i<15;i++){
                  lstm.AddItem("Item(1)-"+IntegerToString(i));
               }  
            lstm.Refresh();                  
            g.SetState(sparam,false);
            g.Redraw();
         }
         if(sparam=="b2"){
            lstm.Clear();
               for(int i=0;i<25;i++){
                  lstm.AddItem("Item(2)-"+IntegerToString(i));
               }  
            lstm.Refresh();   
            g.SetState(sparam,false);
            g.Redraw();
         }      
         if(sparam=="b3"){
            int Selected=lstm.FirstSelected();
               if(Selected==-1){
                  Alert("  ");
               }
               else{
                  string NewText=IntegerToString(GetTickCount());
                     while(Selected!=-1){
                        lstm.SetText(Selected,NewText);
                        Selected=lstm.NextSelected();
                     }    
               }        
            g.SetState(sparam,false);
            g.Redraw();
         }  
          
         if(sparam=="b4"){
            if(lstm.Count()>0){
               lstm.DeleteItem(0);
               lstm.Refresh();
            }
            else{
               Alert(" ");
            }           
            g.SetState(sparam,false);
            g.Redraw();
         } 
         if(sparam=="b5"){
            int Selected=lstm.FirstSelected();
               if(Selected==-1){
                  Alert("  ");
               }
               else{    
                     while(Selected!=-1){
                        lstm.DeleteItem(Selected);
                        Selected=lstm.FirstSelected();
                     }
                  lstm.Refresh();
               }
            g.SetState(sparam,false);
            g.Redraw();
         } 
         if(sparam=="b6"){
               if(lstm.Count()>0){
                  lstm.DeleteItem(lstm.Count()-1);
                  lstm.Refresh();
               }
               else{
                  Alert(" ");
               }
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b7"){
            int Selected=lstm.FirstSelected();
               if(Selected==-1){
                  Alert("  ");
               }
               else{
                  string NewText=IntegerToString(GetTickCount());
                  Alert(" : ");
                     while(Selected!=-1){
                        Alert("    : "+IntegerToString(Selected)+", : "+lstm.Text(Selected));
                        lstm.SetText(Selected,NewText);
                        Selected=lstm.NextSelected();
                     }    
               }  
            g.SetState(sparam,false);
            g.Redraw();
         }  
     
         
      }
}