//+------------------------------------------------------------------+
//|                                        eIncGUI_v2_Test_CList.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CList lst;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CList
   lst.Init("CList",100,8);
   lst.SetPos(10,200);
      for(int i=0;i<15;i++){
         lst.AddItem("Item-"+IntegerToString(i));
      }  
   lst.SetSubWindow("TestSubWindow");             
   lst.Show();

   w.Button("b1",0,10,20,250,20," 1");
   w.Button("b2",0,10,45,250,20," 2");
   w.Button("b3",0,10,70,250,20,"   ");   
   w.Button("b4",0,10,95,250,20,"  ");   
   w.Button("b5",0,10,120,250,20,"  ");   
   w.Button("b6",0,10,145,250,20,"  ");   
   w.Button("b7",0,10,170,250,20," ");      
   w.Redraw();
   return(0);

   
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   w.Delete("b5");
   w.Delete("b6");  
   w.Delete("b7");   
   lst.Hide();
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=lst.Event(id,lparam,dparam,sparam);
      if(ev==1){
         Alert("CList.  "); 
      }
      if(ev==2){
         Alert("CList.   "+DoubleToString(lst.SelectedIndex(),0)+" ("+lst.SelectedText()+")"); 
      }  
      if(CHARTEVENT_CHART_CHANGE){
         lst.SetSubWindow("TestSubWindow");
      }        
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            lst.Clear();
               for(int i=0;i<15;i++){
                  lst.AddItem("Item(1)-"+IntegerToString(i));
               }  
            lst.Refresh();                  
            g.SetState(sparam,false);
            g.Redraw();
         }
         if(sparam=="b2"){
            lst.Clear();
               for(int i=0;i<25;i++){
                  lst.AddItem("Item(2)-"+IntegerToString(i));
               }  
            lst.Refresh();   
            g.SetState(sparam,false);
            g.Redraw();
         }       
         if(sparam=="b3"){
            if(lst.SelectedIndex()>=0){
               lst.SetText(lst.SelectedIndex(),IntegerToString(GetTickCount()));
            }
            else{
               Alert("  ");
            }               
            g.SetState(sparam,false);
            g.Redraw();
         }  
         
         if(sparam=="b4"){
            if(lst.Count()>0){
               lst.DeleteItem(0);
               lst.Refresh();
            }
            else{
               Alert(" ");
            }           
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b5"){
            if(lst.SelectedIndex()>=0){
               lst.DeleteItem(lst.SelectedIndex());
               lst.Refresh();
            }
            else{
               Alert("  ");
            }  
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b6"){
            if(lst.Count()>0){
               lst.DeleteItem(lst.Count()-1);
               lst.Refresh();
            }
            else{
               Alert(" ");
            }
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b7"){
            Alert(": "+IntegerToString(lst.SelectedIndex())+", : "+lst.SelectedText());
            g.SetState(sparam,false);
            g.Redraw();
         }           
         
      }
}