//+------------------------------------------------------------------+
//|                                   eIncGUI_v2_Test_CHProgress.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CHProgress hp;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CHProgress
   hp.Init("CHProgress",300);
   hp.SetPos(10,75);
   hp.SetSubWindow("TestSubWindow");
   hp.Show();

   w.Button("b1",0,10,20,250,20," (  )");
   w.Button("b2",0,10,45,250,20," (  3 .)");
   w.Redraw();
   return(0);

   
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");
   hp.Hide();
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            g.SetState(sparam,false);
            g.Redraw();
            hp.SetRefreshInterval(0);
            hp.Begin(0,100);
               for(int i=0;i<=100;i++){
                  hp.SetValue(i);
                  Sleep(100);
               }         
            hp.Reset();            
         }
      }
      if(CHARTEVENT_CHART_CHANGE){
         hp.SetSubWindow("TestSubWindow");
      }        
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b2"){
            g.SetState(sparam,false);
            g.Redraw();
            hp.SetRefreshInterval(3);
            hp.Begin(0,100);
               for(int i=0;i<=100;i++){
                  hp.SetValue(i);
                  Sleep(100);
               }         
            hp.Reset();            
         }
      }      
     
     
      
}