//+------------------------------------------------------------------+
//|                                       eIncGUI_v2_Test_CHMenu.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CHMenu hm;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CHMenu
   hm.Init("cHMenu",300,3);
      for(int i=0;i<9;i++){
         hm.AddItem("HMenuItem-"+IntegerToString(i),false);
      }
      
   hm.SetPos((int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS)/2-hm.Width()/2,(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS)/2-hm.Height()/2);
   hm.SetSubWindow("TestSubWindow");
   hm.Show();
   
   w.Canvas("c1",0,270,20,50,50);

   w.Button("b1",0,10,20,250,20,"  ");
   w.Redraw();
   return(0);

   
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("c1");
   w.Delete("b1");
   hm.Hide();
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=hm.Event(id,lparam,dparam,sparam); 
      if(ev>=0){
         int he,wi;
         Alert("CHMenu.    "+IntegerToString(ev)+"(X: "+IntegerToString(hm.LastClickedX())+", Y: "+IntegerToString(hm.LastClickedY())+", : "+IntegerToString(hm.LastClickedQuarter())+")");
            if(hm.Checked(ev)){
               hm.SetChecked(ev,false);
            }
            else{
               hm.SetChecked(ev,true);
            }
            switch(hm.LastClickedQuarter()){
               case 1:
                  g.SetXYDistance("c1",hm.LastClickedX(),hm.LastClickedY()+hm.Height()-1);
                  ChartRedraw();
               break;
               case 2:
                  wi=g.XSize("c1");
                  g.SetXYDistance("c1",hm.LastClickedX()+hm.LastClickedW()-wi,hm.LastClickedY()+hm.Height()-1);
                  ChartRedraw();
               break;
               case 3:
                  he=g.YSize("c1");
                  g.SetXYDistance("c1",hm.LastClickedX(),hm.LastClickedY()-he+1);
                  ChartRedraw();
               break;                  
               case 4:
                  he=g.YSize("c1");
                  wi=g.XSize("c1");
                  g.SetXYDistance("c1",hm.LastClickedX()+hm.LastClickedW()-wi,hm.LastClickedY()-he+1);
                  ChartRedraw();
               break;                  
            }
      }
      if(CHARTEVENT_CHART_CHANGE){
         hm.SetSubWindow("TestSubWindow");
      }  
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            Alert("CheckedExist()="+IntegerToString(hm.CheckedExist()));
            g.SetState(sparam,false);
            g.Redraw();
         }
      }
     
     
      
}