//+------------------------------------------------------------------+
//|                              eIncGUI_v2_Test_CDialerInputBox.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

CDialerInputBox dib;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // CDialerInputBox
   dib.Init("CDialerInputBox",80,4,"CDialerInputBox");
   dib.SetPos(10,125);
   dib.SetSubWindow("TestSubWindow");
   dib.Show();

   w.Button("b1",0,10,20,250,20," ReadOnly");
   w.Button("b2",0,10,45,250,20," Warning");
   w.Button("b3",0,10,70,250,20,"  1.5");   
   w.Button("b4",0,10,95,250,20," "); 
   w.Redraw();
   return(0);

   
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   dib.Hide();
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=dib.Event(id,lparam,dparam,sparam);
      if(ev==1){
         Alert("CDialerInputBox.  : "+DoubleToString(dib.Value()));
      }  
      if(CHARTEVENT_CHART_CHANGE){
         dib.SetSubWindow("TestSubWindow");
      }  
      
      
      if(CHARTEVENT_OBJECT_CLICK){
         if(sparam=="b1"){
            dib.SetReadOnly(!dib.ReadOnly());
            g.SetState(sparam,false);
            g.Redraw();
         }
         if(sparam=="b2"){
            dib.SetWarning(!dib.Warning());   
            g.SetState(sparam,false);
            g.Redraw();
         }   
         if(sparam=="b3"){
            dib.SetValue(1.5);
            g.SetState(sparam,false);
            g.Redraw();
         }  
         if(sparam=="b4"){
            Alert(": "+DoubleToString(dib.Value(),dib.Digits()));
            g.SetState(sparam,false);
            g.Redraw();
         }           

      }
      
}