//+------------------------------------------------------------------+
//|                                               SampleTrailing.mqh |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
#include <Expert\ExpertTrailing.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=                                     |
//| Type=Trailing                                                    |
//| Name=BreakEven                                                   |
//| Class=CSampleTrailing                                            |
//| Page=                                                            |
//| Parameter=Profit,int,20                                          |
//| Parameter=StopLevel,int,0                                        |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//|  CSampleTrailing.                                           |
//| :                     |
//|              Stop- " ".                 |
//|                 CExpertTrailing.      |
//+------------------------------------------------------------------+
class CSampleTrailing : public CExpertTrailing
  {
protected:
   int                m_profit;             //   
   int                m_stop_level;         //  

public:
                      CSampleTrailing();
   //---    
   void               Profit(int value)       { m_profit=value;     }
   void               StopLevel(int value)    { m_stop_level=value; }
   //---    
   virtual bool       ValidationSettings();
   //---     
   virtual bool       CheckTrailingStopLong(CPositionInfo* position,double& sl,double& tp);
   virtual bool       CheckTrailingStopShort(CPositionInfo* position,double& sl,double& tp);
  };
//+------------------------------------------------------------------+
//|  CSampleTrailing.                                     |
//| INPUT:  .                                                     |
//| OUTPUT: .                                                     |
//| REMARK: .                                                     |
//+------------------------------------------------------------------+
void CSampleTrailing::CSampleTrailing()
  {
//---    
   m_profit    =20;
   m_stop_level=0;
  }
//+------------------------------------------------------------------+
//|   .                                   |
//| INPUT:  .                                                     |
//| OUTPUT: true-  ,  false.             |
//| REMARK: .                                                     |
//+------------------------------------------------------------------+
bool CSampleTrailing::ValidationSettings()
  {
//---      Init
   if(m_symbol==NULL) return(false);
//---  
   if((m_profit-m_stop_level)*m_adjusted_point<=m_symbol.StopsLevel()*m_symbol.Point() && m_profit!=0.0)
     {
      printf(__FUNCTION__+":         ");
      return(false);
     }
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//|       .       |
//| INPUT:  position -   -,                  |
//|         sl       -     stop-,            |
//|         tp       -     take-.            |
//| OUTPUT: true-  ,  false.                |
//| REMARK: .                                                     |
//+------------------------------------------------------------------+
bool CSampleTrailing::CheckTrailingStopLong(CPositionInfo* position,double& sl,double& tp)
  {
//---  
   if(position==NULL) return(false);
//---  
   if(m_profit==0.0)  return(false);
//---   ?
   double open=position.PriceOpen();
   if(position.StopLoss()>=open) return(false);
//---  
   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;
   if(m_symbol.Bid()-open>m_profit*m_adjusted_point)
      sl=m_symbol.NormalizePrice(open+m_stop_level*m_adjusted_point);
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//|       .      |
//| INPUT:  position -   -,                  |
//|         sl       -     stop-,            |
//|         tp       -     take-.            |
//| OUTPUT: true-  ,  false.                |
//| REMARK: .                                                     |
//+------------------------------------------------------------------+
bool CSampleTrailing::CheckTrailingStopShort(CPositionInfo* position,double& sl,double& tp)
  {
//---  
   if(position==NULL) return(false);
//---  
   if(m_profit==0.0)  return(false);
//---   ?
   double open=position.PriceOpen();
   if(position.StopLoss()<=open) return(false);
//---  
   sl=EMPTY_VALUE;
   tp=EMPTY_VALUE;
   if(open-m_symbol.Ask()>m_profit*m_adjusted_point)
      sl=m_symbol.NormalizePrice(open-m_stop_level*m_adjusted_point);
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+