//+------------------------------------------------------------------+
//|                                     CUniChannelWidthControls.mqh |
//|                        Copyright 2016, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"

#include <IncGUI_v4.mqh>
#include <UniChannel/UniChannelDefines.mqh>

class CUniChannelWidthControls{
   protected:
      CSpinInputBox * m_value1;
      CSpinInputBox * m_value2;
      CComBox * m_price; 
      CComBox * m_method; 
      CComBox * m_lockto; 
      int m_last_y;

   public:
   
   int GetLastY(){
      return(m_last_y);
   }
   
   void SetPointers(CSpinInputBox & value1,
                        CSpinInputBox & value2,      
                        CComBox & price,
                        CComBox & method,
                        CComBox & lockto){
      m_value1=GetPointer(value1);
      m_value2=GetPointer(value2);      
      m_price=GetPointer(price);
      m_method=GetPointer(method); 
      m_lockto=GetPointer(lockto);       
   }
   
   void Hide(){
      m_value1.Hide();
      m_value2.Hide();
      m_price.Hide();
      m_method.Hide();
   }
   
   int Event(int id,long lparam,double dparam,string sparam){
      int e1=m_value1.Event(id,lparam,dparam,sparam);
      int e2=m_value2.Event(id,lparam,dparam,sparam);
      int e4=m_price.Event(id,lparam,dparam,sparam);
      int e5=m_method.Event(id,lparam,dparam,sparam);
      int e6=m_lockto.Event(id,lparam,dparam,sparam);      
      if(e1!=0 || e2!=0 || e4!=0 || e5!=0 || e6){
         return(1);
      }
      return(0);
   }
   
   virtual void InitControls(){
   }   
   
   virtual void Show(int x,int y){
   }   
   
   virtual int ControlsCount(){
      return(0);
   }    
};


class CUniChannelWidthControls_ATR:public CUniChannelWidthControls{
   void InitControls(){
      m_value1.Init("w_value1",SPIN_BOX_WIDTH,1," period");
   }
   
   void Show(int x,int y){
      m_value1.Show(x,y);
      y+=20;
      m_lockto.Show(x,y);
      m_last_y=y;
   }  
   
   int ControlsCount(){
      return(2);
   }    
};

class CUniChannelWidthControls_StdDev:public CUniChannelWidthControls{
   void InitControls(){
      m_value1.Init("w_value1",SPIN_BOX_WIDTH,1," period");
   }
   void Show(int x,int y){
      m_value1.Show(x,y);
      y+=20;
      m_lockto.Show(x,y);
      y+=20;
      m_method.Show(x,y);
      y+=20;
      m_price.Show(x,y);      
      m_last_y=y;
   }
   int ControlsCount(){
      return(4);
   }      
};

class CUniChannelWidthControls_InPoints:public CUniChannelWidthControls{
   void InitControls(){
      m_value1.Init("w_value1",SPIN_BOX_WIDTH,1," width (p)");
   }
   void Show(int x,int y){
      m_value1.Show(x,y);
      m_last_y=y;
   }  
   int ControlsCount(){
      return(1);
   }    
};

class CUniChannelWidthControls_Envelopes:public CUniChannelWidthControls{
   void InitControls(){
   }
   void Show(int x,int y){
      m_last_y=y-20;
   }  
   int ControlsCount(){
      return(0);
   }    
};

class CUniChannelWidthControls_PrCh:public CUniChannelWidthControls{
   void InitControls(){
      m_value1.Init("w_value1",SPIN_BOX_WIDTH,1," period");
   }
   void Show(int x,int y){
      m_value1.Show(x,y);
      y+=20;
      m_lockto.Show(x,y);      
      m_last_y=y;
   }  
   int ControlsCount(){
      return(2);
   }    
};

