//+------------------------------------------------------------------+
//|                                                       Target.mqh |
//|           Copyright 2016, Vasiliy Sokolov, St-Petersburg, Russia |
//|                                https://www.mql5.com/ru/users/c-4 |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, Vasiliy Sokolov."
#property link      "https://www.mql5.com/ru/users/c-4"
#include <Object.mqh>
//+------------------------------------------------------------------+
//|  -    .                   |
//| ,                |
//|      .               |
//+------------------------------------------------------------------+
class CTarget : public CObject
  {
private:
   string            m_symbol;        // ,     
   double            m_volume;        //  .      -  ,
                                      //    -  
public:
                     CTarget(string symbol,double volume);
   string            Symbol();
   double            Volume();
   bool              operator!=(CTarget *target)const;
   bool              operator==(CTarget *target)const;
   CTarget          *Clone(void);
  };
//+------------------------------------------------------------------+
//|              |
//|   .                                              |
//+------------------------------------------------------------------+
CTarget::CTarget(string symbol,double volume)
  {
   m_symbol = symbol;
   m_volume = volume;
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
string CTarget::Symbol(void)
  {
   return m_symbol;
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
double CTarget::Volume(void)
  {
   return m_volume;
  }
//+------------------------------------------------------------------+
//|     "".                    |
//+------------------------------------------------------------------+
bool CTarget::operator==(CTarget *target)const
  {
   if(target.Symbol() == m_symbol &&
      target.Volume() == m_volume)return true;
   return false;
  }
//+------------------------------------------------------------------+
//|     " ".                 |
//+------------------------------------------------------------------+
bool CTarget::operator!=(CTarget *target)const
  {
   return !(target == GetPointer(this));
  }
//+------------------------------------------------------------------+
//|   ,    .            |
//+------------------------------------------------------------------+
CTarget *CTarget::Clone(void)
  {
   CTarget *target=new CTarget(m_symbol,m_volume);
   return target;
  }
//+------------------------------------------------------------------+
