//+------------------------------------------------------------------+
//|                                                  PositionMT5.mqh |
//|           Copyright 2016, Vasiliy Sokolov, St-Petersburg, Russia |
//|                                https://www.mql5.com/ru/users/c-4 |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, Vasiliy Sokolov."
#property link      "https://www.mql5.com/ru/users/c-4"
#include <Object.mqh>
#include "Logs.mqh"
#include "Trailings\Trailing.mqh"
#include <Trade\Trade.mqh>

//+------------------------------------------------------------------+
//|   ,                  |
//+------------------------------------------------------------------+
class CPosition : public CObject
  {
private:
   ulong             m_id;                //   
   uint              m_magic;             //   ,     .
   ENUM_POSITION_TYPE m_direction;        //  
   double            m_entry_price;       //    
   string            m_symbol;            // ,    
   datetime          m_time_open;         //  
   string            m_entry_comment;     //  
   bool              m_is_closed;         // ,    
   CLog*             Log;                 // 
   CTrade            m_trade;             //  
public:
                     CPosition(void);
                     ~CPosition(void);
   uint              ExpertMagic(void);
   ulong             ID(void);
   ENUM_POSITION_TYPE Direction(void);
   double            EntryPrice(void);
   double            CurrentPrice(void);
   string            EntryComment(void);
   double            Profit(void);
   double            Volume(void);
   string            Symbol(void);
   datetime          TimeOpen(void);
   bool              CloseAtMarket(string comment="");
   double            StopLossValue(void);
   bool              StopLossValue(double sl);
   double            TakeProfitValue(void);
   bool              TakeProfitValue(double tp);
   bool              IsActive(void);
   CTrailing*        Trailing;
   CObject*          ExpertData;
  };
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+
void CPosition::CPosition(void) : m_id(0),
                                  m_entry_price(0.0),
                                  m_symbol(""),
                                  m_time_open(0)
  {
   m_id=PositionGetInteger(POSITION_IDENTIFIER);
   m_magic=(uint)PositionGetInteger(POSITION_MAGIC);
   m_direction=(ENUM_POSITION_TYPE)PositionGetInteger(POSITION_TYPE);
   m_entry_price=PositionGetDouble(POSITION_PRICE_OPEN);
   m_symbol=PositionGetString(POSITION_SYMBOL);
   m_time_open=(datetime)PositionGetInteger(POSITION_TIME);
   m_entry_comment=PositionGetString(POSITION_COMMENT);
   m_trade.SetExpertMagicNumber(m_magic);
  }
//+------------------------------------------------------------------+
//|   .                                  |
//+------------------------------------------------------------------+  
CPosition::~CPosition(void)
  {
   if(CheckPointer(Trailing) == POINTER_DYNAMIC)
      delete Trailing;
  }
//+------------------------------------------------------------------+
//|   .                                  |
//+------------------------------------------------------------------+
ENUM_POSITION_TYPE CPosition::Direction(void)
  {
   return m_direction;
  }
//+------------------------------------------------------------------+
//|    ,            |
//|   .                                     |
//+------------------------------------------------------------------+
uint CPosition::ExpertMagic(void)
  {
   return m_magic;
  }
//+------------------------------------------------------------------+
//|    .                     |
//+------------------------------------------------------------------+
ulong CPosition::ID(void)
  {
   return m_id;
  }
//+------------------------------------------------------------------+
//|     .                                 |
//+------------------------------------------------------------------+
double CPosition::EntryPrice(void)
  {
   return m_entry_price;
  }
//+------------------------------------------------------------------+
//|    .                                 |
//+------------------------------------------------------------------+  
double CPosition::CurrentPrice(void)
{
   double price = 0.0;   
   int digits = (int)SymbolInfoInteger(m_symbol, SYMBOL_DIGITS);
   if(Direction() == POSITION_TYPE_BUY)
      price = SymbolInfoDouble(m_symbol, SYMBOL_BID);
   else
      price = SymbolInfoDouble(m_symbol, SYMBOL_ASK);
   return NormalizeDouble(price, digits);
}
//+------------------------------------------------------------------+
//|     .                |
//+------------------------------------------------------------------+
string CPosition::EntryComment(void)
  {
   return m_entry_comment;
  }
//+------------------------------------------------------------------+
//|   ,         |
//| .                                                         |
//+------------------------------------------------------------------+
string CPosition::Symbol(void)
  {
   return m_symbol;
  }
//+------------------------------------------------------------------+
//|    .                               |
//+------------------------------------------------------------------+
datetime CPosition::TimeOpen(void)
  {
   return m_time_open;
  }
//+------------------------------------------------------------------+
//|    -   .    |
//|   -  ,  0.0            |
//+------------------------------------------------------------------+
double CPosition::StopLossValue(void)
{
   if(!IsActive())
      return 0.0;
   return PositionGetDouble(POSITION_SL);
}
//+------------------------------------------------------------------+
//|    -                      |
//+------------------------------------------------------------------+
bool CPosition::StopLossValue(double sl)
{
   if(!IsActive())
      return false;
   return m_trade.PositionModify(m_id, sl, TakeProfitValue());
}
//+------------------------------------------------------------------+
//|    -   .    |
//|   -  ,  0.0            |
//+------------------------------------------------------------------+
double CPosition::TakeProfitValue(void)
{
   if(!IsActive())
      return 0.0;
   return PositionGetDouble(POSITION_TP);
}
//+------------------------------------------------------------------+
//|    -                      |
//+------------------------------------------------------------------+
bool CPosition::TakeProfitValue(double tp)
  {
   if(!IsActive())
      return false;
   return m_trade.PositionModify(m_id, StopLossValue(), tp);
  }
//+------------------------------------------------------------------+
//|     ,       |
//|   comment                                       |
//+------------------------------------------------------------------+
bool CPosition::CloseAtMarket(string comment="")
  {
   if(!IsActive())
      return false;
   m_trade.PositionModify(m_id, 0.0, 0.0);
   ENUM_ACCOUNT_MARGIN_MODE mode=(ENUM_ACCOUNT_MARGIN_MODE)AccountInfoInteger(ACCOUNT_MARGIN_MODE);
   if(mode != ACCOUNT_MARGIN_MODE_RETAIL_HEDGING)
      return m_trade.PositionClose(m_symbol);
   return m_trade.PositionClose(m_id);
  }
//+------------------------------------------------------------------+
//|    .                                |
//+------------------------------------------------------------------+
double CPosition::Volume(void)
  {
   if(!IsActive())
      return 0.0;
   return PositionGetDouble(POSITION_VOLUME);
  }
//+------------------------------------------------------------------+
//|       .            |
//+------------------------------------------------------------------+
double CPosition::Profit(void)
  {
   if(!IsActive())
      return 0.0;
   return PositionGetDouble(POSITION_PROFIT);
  }
//+------------------------------------------------------------------+
//|  ,   .           |
//|   .                                              |
//+------------------------------------------------------------------+
bool CPosition::IsActive(void)
{
   ENUM_ACCOUNT_MARGIN_MODE mode=(ENUM_ACCOUNT_MARGIN_MODE)AccountInfoInteger(ACCOUNT_MARGIN_MODE);
   if(mode!=ACCOUNT_MARGIN_MODE_RETAIL_HEDGING)
      return PositionSelect(m_symbol);
   else
      return PositionSelectByTicket(m_id);
}
//+------------------------------------------------------------------+
//#include "Trailing.mqh"