//+------------------------------------------------------------------+
//|                                                      Message.mqh |
//|           Copyright 2016, Vasiliy Sokolov, St-Petersburg, Russia |
//|                                https://www.mql5.com/ru/users/c-4 |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, Vasiliy Sokolov."
#property link      "https://www.mql5.com/ru/users/c-4"
#include <Object.mqh>
#include <Arrays\ArrayObj.mqh>

#define UNKNOW_SOURCE "unknown"     //    
//+------------------------------------------------------------------+
//|                                                      |
//+------------------------------------------------------------------+
enum ENUM_MESSAGE_TYPE
  {
   MESSAGE_INFO,                    //  
   MESSAGE_WARNING,                 //  
   MESSAGE_ERROR                    //  
  };
//+------------------------------------------------------------------+
//| ,                          |
//+------------------------------------------------------------------+
class CMessage : public CObject
  {
private:
   ENUM_MESSAGE_TYPE m_type;               //  
   string            m_source;             //  
   string            m_text;               //  
   int               m_system_error_id;    //    .
   int               m_retcode;            //     .
   datetime          m_server_time;        //   ,    
   datetime          m_local_time;         //  ,    
   void              Init(ENUM_MESSAGE_TYPE type,string source,string text);
public:
                     CMessage(void);
                     CMessage(ENUM_MESSAGE_TYPE type);
                     CMessage(ENUM_MESSAGE_TYPE type,string source,string text);
   void              Type(ENUM_MESSAGE_TYPE type);
   ENUM_MESSAGE_TYPE Type(void);
   void              Source(string source);
   string            Source(void);
   void              Text(string text);
   string            Text(void);
   datetime          TimeServer(void);
   datetime          TimeLocal();
   void              SystemErrorID(int error);
   int               SystemErrorID();
   void              Retcode(int retcode);
   int               Retcode(void);
   string            ToConsoleType(void);
   string            ToCSVType(void);
  };
//+------------------------------------------------------------------+
//| -,     ,              |
//|      .             |
//+------------------------------------------------------------------+
CMessage::CMessage(void)
  {
   Init(MESSAGE_INFO,UNKNOW_SOURCE,"");
  }
//+------------------------------------------------------------------+
//|     ,  |
//|  .                                                       |
//+------------------------------------------------------------------+
CMessage::CMessage(ENUM_MESSAGE_TYPE type,string source,string text)
  {
   Init(type,source,text);
  }
//+------------------------------------------------------------------+
//|     .                     |
//+------------------------------------------------------------------+
CMessage::CMessage(ENUM_MESSAGE_TYPE type)
  {
   Init(type,UNKNOW_SOURCE,"");
  }
//+------------------------------------------------------------------+
//|    .                            |
//+------------------------------------------------------------------+
CMessage::Init(ENUM_MESSAGE_TYPE type,string source,string text)
  {
   m_server_time= TimeCurrent();
   m_local_time = TimeLocal();
   m_type=type;
   m_source=source;
   m_text=text;
   m_system_error_id=GetLastError();

  }
//+------------------------------------------------------------------+
//|   .                                        |
//+------------------------------------------------------------------+
ENUM_MESSAGE_TYPE CMessage::Type(void)
  {
   return m_type;
  }
//+------------------------------------------------------------------+
//|   .                                |
//+------------------------------------------------------------------+
void CMessage::Source(string source)
  {
   m_source=source;
  }
//+------------------------------------------------------------------+
//|   .                                   |
//+------------------------------------------------------------------+
string CMessage::Source(void)
  {
   return m_source;
  }
//+------------------------------------------------------------------+
//|   .                              |
//+------------------------------------------------------------------+
void CMessage::Text(string text)
  {
   m_text=text;
  }
//+------------------------------------------------------------------+
//|   .                                 |
//+------------------------------------------------------------------+
string CMessage::Text(void)
  {
   return m_text;
  }
//+------------------------------------------------------------------+
//|       .            |
//+------------------------------------------------------------------+
datetime CMessage::TimeServer(void)
  {
   return m_server_time;
  }
//+------------------------------------------------------------------+
//|       .          |
//+------------------------------------------------------------------+
datetime CMessage::TimeLocal(void)
  {
   return m_local_time;
  }
//+------------------------------------------------------------------+
//|        .         |
//+------------------------------------------------------------------+
string CMessage::ToConsoleType(void)
  {
   string dt= ";";
   string t = EnumToString(m_type);
   t=StringSubstr(t,8);
   string text=t+dt+m_source+dt+m_text+dt+
               TimeToString(m_server_time,TIME_DATE|TIME_MINUTES|TIME_SECONDS);
   return text;
  }
//+------------------------------------------------------------------+
//|        .       |
//+------------------------------------------------------------------+
string CMessage::ToCSVType(void)
  {
   string d="\t";  //  
   string msg=TimeToString(m_server_time,TIME_DATE|TIME_MINUTES|TIME_SECONDS)+d+EnumToString(m_type)+d+m_source+d+m_text;
   return msg;
  }
//+------------------------------------------------------------------+
//|    .                               |
//+------------------------------------------------------------------+
int CMessage::SystemErrorID(void)
  {
   return m_system_error_id;
  }
//+------------------------------------------------------------------+
//|   ,   .    |
//|      .                |
//| :     ,   |
//|    .           |
//|     .                                 |
//+------------------------------------------------------------------+
void CMessage::SystemErrorID(int error)
  {
   m_system_error_id=error;
  }
//+------------------------------------------------------------------+
//|     .            |
//| SystemErrorID   , . CMessage       |
//|     .                              |
//+------------------------------------------------------------------+
void CMessage::Retcode(int retcode)
  {
   m_retcode=retcode;
  }
//+------------------------------------------------------------------+
//|            |
//| .        ,     |
//|       .        |
//+------------------------------------------------------------------+
int CMessage::Retcode(void)
  {
   return m_retcode;
  }
//+------------------------------------------------------------------+
