//+------------------------------------------------------------------+
//|                                                      Program.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <EasyAndFastGUI\Controls\WndEvents.mqh>
//+------------------------------------------------------------------+
//|                                        |
//+------------------------------------------------------------------+
class CProgram : public CWndEvents
  {
private:
   //---  1
   CWindow           m_window1;
   //---      
   CMenuBar          m_menubar;
   CContextMenu      m_mb_contextmenu1;
   CContextMenu      m_mb_contextmenu2;
   CContextMenu      m_mb_contextmenu3;
   CContextMenu      m_mb_contextmenu4;
   //---  
   CStatusBar        m_status_bar;
   //---  
   CTreeView         m_treeview;
   //--- -
   CCheckBox         m_checkbox1;
   CCheckBox         m_checkbox2;
   CCheckBox         m_checkbox3;
   CCheckBox         m_checkbox4;
   //--- 
   CTable            m_table1;
   CTable            m_table2;
   CTable            m_table3;
   CTable            m_table4;
   //---
public:
                     CProgram(void);
                    ~CProgram(void);
   //--- /
   void              OnInitEvent(void);
   void              OnDeinitEvent(const int reason);
   //--- 
   void              OnTimerEvent(void);
   //---
protected:
   //---   
   virtual void      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);
   //---
public:
   //---   
   bool              CreateExpertPanel(void);
   //---
private:
   //---  1
   bool              CreateWindow1(const string text);

   //---      
#define MENUBAR_GAP_X         (1)
#define MENUBAR_GAP_Y         (20)
   bool              CreateMenuBar(void);
   bool              CreateMBContextMenu1(void);
   bool              CreateMBContextMenu2(void);
   bool              CreateMBContextMenu3(void);
   bool              CreateMBContextMenu4(void);
   //---  
#define STATUSBAR1_GAP_X      (1)
#define STATUSBAR1_GAP_Y      (237)
   bool              CreateStatusBar(void);
   //---  
#define TREEVIEW1_GAP_X       (2)
#define TREEVIEW1_GAP_Y       (43)
   bool              CreateTreeView(void);
   //--- -
#define CHECKBOX1_GAP_X       (190)
#define CHECKBOX1_GAP_Y       (53)
   bool              CreateCheckBox1(const string text);
#define CHECKBOX2_GAP_X       (190)
#define CHECKBOX2_GAP_Y       (53)
   bool              CreateCheckBox2(const string text);
#define CHECKBOX3_GAP_X       (190)
#define CHECKBOX3_GAP_Y       (53)
   bool              CreateCheckBox3(const string text);
#define CHECKBOX4_GAP_X       (190)
#define CHECKBOX4_GAP_Y       (53)
   bool              CreateCheckBox4(const string text);
   //--- 
#define TABLE1_GAP_X          (182)
#define TABLE1_GAP_Y          (81)
   bool              CreateTable1(void);
#define TABLE2_GAP_X          (182)
#define TABLE2_GAP_Y          (81)
   bool              CreateTable2(void);
#define TABLE3_GAP_X          (182)
#define TABLE3_GAP_Y          (81)
   bool              CreateTable3(void);
#define TABLE4_GAP_X          (182)
#define TABLE4_GAP_Y          (81)
   bool              CreateTable4(void);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CProgram::CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CProgram::~CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
void CProgram::OnInitEvent(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void CProgram::OnDeinitEvent(const int reason)
  {
//---  
   CWndEvents::Destroy();
  }
//+------------------------------------------------------------------+
//|                                                            |
//+------------------------------------------------------------------+
void CProgram::OnTimerEvent(void)
  {
   CWndEvents::OnTimerEvent();
//---        500 
   static int count=0;
   if(count<500)
     {
      count+=TIMER_STEP_MSC;
      return;
     }
//---  
   count=0;
//---       
   m_status_bar.ValueToItem(1,::TimeToString(::TimeLocal(),TIME_DATE|TIME_SECONDS));
//--- 
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void CProgram::OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
//---     
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_CONTEXTMENU_ITEM)
     {
      ::Print(__FUNCTION__," > id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
     }
//---     
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_LABEL)
     {
      ::Print(__FUNCTION__," > id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
     }
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
bool CProgram::CreateExpertPanel(void)
  {
//---   1   
   if(!CreateWindow1("EXPERT PANEL"))
      return(false);
//---   :
//     
   if(!CreateMenuBar())
      return(false);
//---  
   if(!CreateMBContextMenu1())
      return(false);
   if(!CreateMBContextMenu2())
      return(false);
   if(!CreateMBContextMenu3())
      return(false);
   if(!CreateMBContextMenu4())
      return(false);
//---   
   if(!CreateStatusBar())
      return(false);
//---   
   if(!CreateTreeView())
      return(false);
//--- -
   if(!CreateCheckBox1("Advisors > 01: Checkbox 1"))
      return(false);
   if(!CreateCheckBox2("Advisors > 02: Checkbox 2"))
      return(false);
   if(!CreateCheckBox3("Indicators > 01: Checkbox 3"))
      return(false);
   if(!CreateCheckBox4("Indicators > 02: Checkbox 4"))
      return(false);
//--- 
   if(!CreateTable1())
      return(false);
   if(!CreateTable2())
      return(false);
   if(!CreateTable3())
      return(false);
   if(!CreateTable4())
      return(false);
//---     
   m_treeview.ShowTabElements();
//---  
   m_chart.Redraw();
   return(true);
  }
//+------------------------------------------------------------------+
//|   1                            |
//+------------------------------------------------------------------+
bool CProgram::CreateWindow1(const string caption_text)
  {
//---      
   CWndContainer::AddWindow(m_window1);
//--- 
   int x=(m_window1.X()>0) ? m_window1.X() : 1;
   int y=(m_window1.Y()>0) ? m_window1.Y() : 20;
//--- 
   m_window1.Movable(true);
   m_window1.XSize(450);
   m_window1.YSize(262);
   m_window1.WindowBgColor(clrWhiteSmoke);
   m_window1.WindowBorderColor(clrLightSteelBlue);
   m_window1.CaptionBgColor(clrLightSteelBlue);
   m_window1.CaptionBgColorHover(clrLightSteelBlue);
//---  
   if(!m_window1.CreateWindow(m_chart_id,m_subwin,caption_text,x,y))
      return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateMenuBar(void)
  {
//---     
#define MENUBAR_TOTAL 3
//---    
   m_menubar.WindowPointer(m_window1);
//--- 
   int x=m_window1.X()+MENUBAR_GAP_X;
   int y=m_window1.Y()+MENUBAR_GAP_Y;
//---     
   int    width[MENUBAR_TOTAL] ={50,55,53};
   string text[MENUBAR_TOTAL]  ={"File","View","Help"};
//--- 
   m_menubar.MenuBackColor(C'225,225,225');
   m_menubar.MenuBorderColor(C'225,225,225');
   m_menubar.ItemBackColor(C'225,225,225');
   m_menubar.ItemBorderColor(C'225,225,225');
//---     
   for(int i=0; i<MENUBAR_TOTAL; i++)
      m_menubar.AddItem(width[i],text[i]);
//---   
   if(!m_menubar.CreateMenuBar(m_chart_id,m_subwin,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_menubar);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\script.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\script_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
//---
bool CProgram::CreateMBContextMenu1(void)
  {
//---     
#define CONTEXTMENU_ITEMS1 3
//---    
   m_mb_contextmenu1.WindowPointer(m_window1);
//---     
   m_mb_contextmenu1.PrevNodePointer(m_menubar.ItemPointerByIndex(0));
//---       
   m_menubar.AddContextMenuPointer(0,m_mb_contextmenu1);
//---   
   string items_text[CONTEXTMENU_ITEMS1]=
     {
      "ContextMenu 1 Item 1",
      "ContextMenu 1 Item 2",
      "ContextMenu 1 Item 3..."
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_SIMPLE
     };
//---    
   m_mb_contextmenu1.FixSide(FIX_BOTTOM);
   m_mb_contextmenu1.XSize(160);
   m_mb_contextmenu1.AreaBackColor(C'240,240,240');
   m_mb_contextmenu1.AreaBorderColor(clrSilver);
   m_mb_contextmenu1.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu1.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu1.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu1.LabelColor(clrBlack);
   m_mb_contextmenu1.LabelColorHover(clrWhite);
   m_mb_contextmenu1.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu1.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS1; i++)
      m_mb_contextmenu1.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu1.AddSeparateLine(1);
//---   
   m_mb_contextmenu1.ItemPointerByIndex(1).ItemState(false);
//---   
   if(!m_mb_contextmenu1.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu1);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu2(void)
  {
//---     
#define CONTEXTMENU_ITEMS2 3
//---    
   m_mb_contextmenu2.WindowPointer(m_window1);
//---     
   m_mb_contextmenu2.PrevNodePointer(m_menubar.ItemPointerByIndex(1));
//---       
   m_menubar.AddContextMenuPointer(1,m_mb_contextmenu2);
//---   
   string items_text[CONTEXTMENU_ITEMS2]=
     {
      "ContextMenu 2 Item 1",
      "ContextMenu 2 Item 2",
      "ContextMenu 2 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS2]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu2.FixSide(FIX_BOTTOM);
   m_mb_contextmenu2.XSize(160);
   m_mb_contextmenu2.AreaBackColor(C'240,240,240');
   m_mb_contextmenu2.AreaBorderColor(clrSilver);
   m_mb_contextmenu2.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu2.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu2.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu2.LabelColor(clrBlack);
   m_mb_contextmenu2.LabelColorHover(clrWhite);
   m_mb_contextmenu2.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu2.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS2; i++)
      m_mb_contextmenu2.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu2.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu2.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu2);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp"
//---
bool CProgram::CreateMBContextMenu3(void)
  {
//---     
#define CONTEXTMENU_ITEMS3 5
//---    
   m_mb_contextmenu3.WindowPointer(m_window1);
//---     
   m_mb_contextmenu3.PrevNodePointer(m_menubar.ItemPointerByIndex(2));
//---       
   m_menubar.AddContextMenuPointer(2,m_mb_contextmenu3);
//---   
   string items_text[CONTEXTMENU_ITEMS3]=
     {
      "ContextMenu 3 Item 1",
      "ContextMenu 3 Item 2",
      "ContextMenu 3 Item 3...",
      "ContextMenu 3 Item 4",
      "ContextMenu 3 Item 5"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp",
      "",""
     };
//---      
   string items_bmp_off[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS3]=
     {
      MI_SIMPLE,
      MI_HAS_CONTEXT_MENU,
      MI_SIMPLE,
      MI_CHECKBOX,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu3.FixSide(FIX_BOTTOM);
   m_mb_contextmenu3.XSize(160);
   m_mb_contextmenu3.AreaBackColor(C'240,240,240');
   m_mb_contextmenu3.AreaBorderColor(clrSilver);
   m_mb_contextmenu3.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu3.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu3.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu3.LabelColor(clrBlack);
   m_mb_contextmenu3.LabelColorHover(clrWhite);
   m_mb_contextmenu3.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu3.SeparateLineLightColor(clrWhite);
   m_mb_contextmenu3.RightArrowFileOff("Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp");
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS3; i++)
      m_mb_contextmenu3.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu3.AddSeparateLine(2);
//---   
   if(!m_mb_contextmenu3.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu3);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu4(void)
  {
//---     
#define CONTEXTMENU_ITEMS4 3
//---    
   m_mb_contextmenu4.WindowPointer(m_window1);
//---     
   m_mb_contextmenu4.PrevNodePointer(m_mb_contextmenu3.ItemPointerByIndex(1));
//---   
   string items_text[CONTEXTMENU_ITEMS4]=
     {
      "ContextMenu 4 Item 1",
      "ContextMenu 4 Item 2",
      "ContextMenu 4 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS4]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu4.XSize(160);
   m_mb_contextmenu4.AreaBackColor(C'240,240,240');
   m_mb_contextmenu4.AreaBorderColor(clrSilver);
   m_mb_contextmenu4.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu4.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu4.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu4.LabelColor(clrBlack);
   m_mb_contextmenu4.LabelColorHover(clrWhite);
   m_mb_contextmenu4.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu4.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS4; i++)
      m_mb_contextmenu4.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu4.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu4.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu4);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateStatusBar(void)
  {
#define STATUS_LABELS_TOTAL 2
//---    
   m_status_bar.WindowPointer(m_window1);
//--- 
   int x=m_window1.X()+STATUSBAR1_GAP_X;
   int y=m_window1.Y()+STATUSBAR1_GAP_Y;
//--- 
   int width[]={0,110};
//---    
   m_status_bar.YSize(24);
   m_status_bar.AreaColor(C'225,225,225');
   m_status_bar.AreaBorderColor(C'225,225,225');
//---         
   for(int i=0; i<STATUS_LABELS_TOTAL; i++)
      m_status_bar.AddItem(width[i]);
//---   
   if(!m_status_bar.CreateStatusBar(m_chart_id,m_subwin,x,y))
      return(false);
//---       
   m_status_bar.ValueToItem(0,"For Help, press F1");
//---      
   CWndContainer::AddToElementsArray(0,m_status_bar);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
bool CProgram::CreateTreeView(void)
  {
//---     
#define TREEVIEW_ITEMS 12
//---    
   m_treeview.WindowPointer(m_window1);
//--- 
   int x=m_window1.X()+TREEVIEW1_GAP_X;
   int y=m_window1.Y()+TREEVIEW1_GAP_Y;
//---     :
//      
#define A "Images\\EasyAndFastGUI\\Icons\\bmp16\\advisor.bmp"   // 
#define I "Images\\EasyAndFastGUI\\Icons\\bmp16\\indicator.bmp" // 
#define S "Images\\EasyAndFastGUI\\Icons\\bmp16\\script.bmp"    // 
   string path_bmp[TREEVIEW_ITEMS]=
     {A,A,A,I,I,I,S,S,S,S,S,S};
//---   ( )
   string item_text[TREEVIEW_ITEMS]=
     {"Advisors","01","02","Indicators","01","02","Scripts","01","02","03","04","05"};
//---     
   int prev_node_list_index[TREEVIEW_ITEMS]=
     {-1,0,0,-1,3,3,-1,6,6,6,6,6};
//---     
   int item_index[TREEVIEW_ITEMS]=
     {0,0,1,1,0,1,2,0,1,2,3,4};
//---   
   int node_level[TREEVIEW_ITEMS]=
     {0,1,1,0,1,1,0,1,1,1,1,1};
//---     
   int prev_node_item_index[TREEVIEW_ITEMS]=
     {-1,0,0,-1,1,1,-1,2,2,2,2,2};
//---     
   int items_total[TREEVIEW_ITEMS]=
     {2,0,0,2,0,0,5,0,0,0,0,0};
//---   
   bool item_state[TREEVIEW_ITEMS]=
     {true,false,false,true,false,false,false,false,false,false,false,false};
//---    
   m_treeview.TreeViewAreaWidth(180);
   m_treeview.VisibleItemsTotal(10);
   m_treeview.TabItemsMode(true);
   m_treeview.LightsHover(true);
   m_treeview.ShowItemContent(false);
   m_treeview.SelectedItemIndex((m_treeview.SelectedItemIndex()==WRONG_VALUE) ? 3 : m_treeview.SelectedItemIndex());
//---   
   m_treeview.GetScrollVPointer().AreaBorderColor(clrLightGray);
   m_treeview.GetContentScrollVPointer().AreaBorderColor(clrLightGray);
//---  
   for(int i=0; i<TREEVIEW_ITEMS; i++)
      m_treeview.AddItem(i,prev_node_list_index[i],item_text[i],path_bmp[i],
                         item_index[i],node_level[i],prev_node_item_index[i],items_total[i],0,item_state[i]);
//---   
   if(!m_treeview.CreateTreeView(m_chart_id,m_subwin,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_treeview);
   return(true);
  }
//+------------------------------------------------------------------+
//|   1                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateCheckBox1(string text)
  {
//---    
   m_checkbox1.WindowPointer(m_window1);
//---   1- -
   m_treeview.AddToElementsArray(0,m_checkbox1);
//--- 
   int x=m_window1.X()+CHECKBOX1_GAP_X;
   int y=m_window1.Y()+CHECKBOX1_GAP_Y;
//---    
   m_checkbox1.XSize(200);
   m_checkbox1.YSize(18);
   m_checkbox1.AreaColor(clrWhiteSmoke);
   m_checkbox1.LabelColor(clrBlack);
   m_checkbox1.LabelColorOff(clrBlack);
   m_checkbox1.LabelColorLocked(clrSilver);
//---   
   if(!m_checkbox1.CreateCheckBox(m_chart_id,m_subwin,text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_checkbox1);
   return(true);
  }
//+------------------------------------------------------------------+
//|   1                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateTable1(void)
  {
#define COLUMNS1_TOTAL (3)
#define ROWS1_TOTAL    (100)
//---    
   m_table1.WindowPointer(m_window1);
//---   1- -
   m_treeview.AddToElementsArray(0,m_table1);
//--- 
   int x=m_window1.X()+TABLE1_GAP_X;
   int y=m_window1.Y()+TABLE1_GAP_Y;
//---     
   int visible_columns_total =3;
   int visible_rows_total    =9;
//---    
   m_table1.XSize(267);
   m_table1.RowYSize(18);
   m_table1.FixFirstRow(true);
   m_table1.LightsHover(true);
   m_table1.SelectableRow(true);
   m_table1.TextAlign(ALIGN_CENTER);
   m_table1.HeadersColor(C'255,244,213');
   m_table1.HeadersTextColor(clrBlack);
   m_table1.GridColor(clrLightGray);
   m_table1.TableSize(COLUMNS1_TOTAL,ROWS1_TOTAL);
   m_table1.VisibleTableSize(visible_columns_total,visible_rows_total);
//---   
   if(!m_table1.CreateTable(m_chart_id,m_subwin,x,y))
      return(false);
//---  :
//      
   for(int c=0; c<COLUMNS1_TOTAL; c++)
     {
      for(int r=0; r<1; r++)
         m_table1.SetValue(c,r,"SYMBOL "+string(c));
     }
//---     (    )
   for(int c=0; c<COLUMNS1_TOTAL; c++)
     {
      for(int r=1; r<ROWS1_TOTAL; r++)
         m_table1.SetValue(c,r,string(c)+":"+string(r));
     }
//---     
   m_table1.UpdateTable();
//---      
   CWndContainer::AddToElementsArray(0,m_table1);
   return(true);
  }
//+------------------------------------------------------------------+
//|   2                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateCheckBox2(string text)
  {
//---    
   m_checkbox2.WindowPointer(m_window1);
//---   2- -
   m_treeview.AddToElementsArray(1,m_checkbox2);
//--- 
   int x=m_window1.X()+CHECKBOX2_GAP_X;
   int y=m_window1.Y()+CHECKBOX2_GAP_Y;
//---    
   m_checkbox2.XSize(200);
   m_checkbox2.YSize(18);
   m_checkbox2.AreaColor(clrWhiteSmoke);
   m_checkbox2.LabelColor(clrBlack);
   m_checkbox2.LabelColorOff(clrBlack);
   m_checkbox2.LabelColorLocked(clrSilver);
//---   
   if(!m_checkbox2.CreateCheckBox(m_chart_id,m_subwin,text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_checkbox2);
   return(true);
  }
//+------------------------------------------------------------------+
//|   2                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateTable2(void)
  {
#define COLUMNS2_TOTAL (3)
#define ROWS2_TOTAL    (70)
//---    
   m_table2.WindowPointer(m_window1);
//---   1- -
   m_treeview.AddToElementsArray(1,m_table2);
//--- 
   int x=m_window1.X()+TABLE2_GAP_X;
   int y=m_window1.Y()+TABLE2_GAP_Y;
//---     
   int visible_columns_total =3;
   int visible_rows_total    =9;
//---    
   m_table2.XSize(267);
   m_table2.RowYSize(18);
   m_table2.FixFirstRow(true);
   m_table2.LightsHover(true);
   m_table2.SelectableRow(true);
   m_table2.TextAlign(ALIGN_CENTER);
   m_table2.HeadersColor(C'255,244,213');
   m_table2.HeadersTextColor(clrBlack);
   m_table2.GridColor(clrLightGray);
   m_table2.TableSize(COLUMNS2_TOTAL,ROWS2_TOTAL);
   m_table2.VisibleTableSize(visible_columns_total,visible_rows_total);
//---   
   if(!m_table2.CreateTable(m_chart_id,m_subwin,x,y))
      return(false);
//---  :
//      
   for(int c=0; c<COLUMNS2_TOTAL; c++)
     {
      for(int r=0; r<1; r++)
         m_table2.SetValue(c,r,"SYMBOL "+string(c));
     }
//---     (    )
   for(int c=0; c<COLUMNS2_TOTAL; c++)
     {
      for(int r=1; r<ROWS2_TOTAL; r++)
         m_table2.SetValue(c,r,string(c)+":"+string(r));
     }
//---     
   m_table2.UpdateTable();
//---      
   CWndContainer::AddToElementsArray(0,m_table2);
   return(true);
  }
//+------------------------------------------------------------------+
//|   3                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateCheckBox3(string text)
  {
//---    
   m_checkbox3.WindowPointer(m_window1);
//---   3- -
   m_treeview.AddToElementsArray(2,m_checkbox3);
//--- 
   int x=m_window1.X()+CHECKBOX3_GAP_X;
   int y=m_window1.Y()+CHECKBOX3_GAP_Y;
//---    
   m_checkbox3.XSize(200);
   m_checkbox3.YSize(18);
   m_checkbox3.AreaColor(clrWhiteSmoke);
   m_checkbox3.LabelColor(clrBlack);
   m_checkbox3.LabelColorOff(clrBlack);
   m_checkbox3.LabelColorLocked(clrSilver);
//---   
   if(!m_checkbox3.CreateCheckBox(m_chart_id,m_subwin,text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_checkbox3);
   return(true);
  }
//+------------------------------------------------------------------+
//|   3                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateTable3(void)
  {
#define COLUMNS3_TOTAL (2)
#define ROWS3_TOTAL    (30)
//---    
   m_table3.WindowPointer(m_window1);
//---   3- -
   m_treeview.AddToElementsArray(2,m_table3);
//--- 
   int x=m_window1.X()+TABLE3_GAP_X;
   int y=m_window1.Y()+TABLE3_GAP_Y;
//---     
   int visible_columns_total =2;
   int visible_rows_total    =9;
//---    
   m_table3.XSize(267);
   m_table3.RowYSize(18);
   m_table3.FixFirstRow(true);
   m_table3.LightsHover(true);
   m_table3.SelectableRow(true);
   m_table3.TextAlign(ALIGN_CENTER);
   m_table3.HeadersColor(C'255,244,213');
   m_table3.HeadersTextColor(clrBlack);
   m_table3.GridColor(clrLightGray);
   m_table3.TableSize(COLUMNS3_TOTAL,ROWS3_TOTAL);
   m_table3.VisibleTableSize(visible_columns_total,visible_rows_total);
//---   
   if(!m_table3.CreateTable(m_chart_id,m_subwin,x,y))
      return(false);
//---  :
//      
   for(int c=0; c<COLUMNS3_TOTAL; c++)
     {
      for(int r=0; r<1; r++)
         m_table3.SetValue(c,r,"SYMBOL "+string(c));
     }
//---     (    )
   for(int c=0; c<COLUMNS3_TOTAL; c++)
     {
      for(int r=1; r<ROWS3_TOTAL; r++)
         m_table3.SetValue(c,r,string(c)+":"+string(r));
     }
//---     
   m_table3.UpdateTable();
//---      
   CWndContainer::AddToElementsArray(0,m_table3);
   return(true);
  }
//+------------------------------------------------------------------+
//|   4                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateCheckBox4(string text)
  {
//---    
   m_checkbox4.WindowPointer(m_window1);
//---   4- -
   m_treeview.AddToElementsArray(3,m_checkbox4);
//--- 
   int x=m_window1.X()+CHECKBOX4_GAP_X;
   int y=m_window1.Y()+CHECKBOX4_GAP_Y;
//---    
   m_checkbox4.XSize(200);
   m_checkbox4.YSize(18);
   m_checkbox4.AreaColor(clrWhiteSmoke);
   m_checkbox4.LabelColor(clrBlack);
   m_checkbox4.LabelColorOff(clrBlack);
   m_checkbox4.LabelColorLocked(clrSilver);
//---   
   if(!m_checkbox4.CreateCheckBox(m_chart_id,m_subwin,text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_checkbox4);
   return(true);
  }
//+------------------------------------------------------------------+
//|   4                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateTable4(void)
  {
#define COLUMNS4_TOTAL (2)
#define ROWS4_TOTAL    (20)
//---    
   m_table4.WindowPointer(m_window1);
//---   4- -
   m_treeview.AddToElementsArray(3,m_table4);
//--- 
   int x=m_window1.X()+TABLE4_GAP_X;
   int y=m_window1.Y()+TABLE4_GAP_Y;
//---     
   int visible_columns_total =2;
   int visible_rows_total    =9;
//---    
   m_table4.XSize(267);
   m_table4.RowYSize(18);
   m_table4.FixFirstRow(true);
   m_table4.LightsHover(true);
   m_table4.SelectableRow(true);
   m_table4.TextAlign(ALIGN_CENTER);
   m_table4.HeadersColor(C'255,244,213');
   m_table4.HeadersTextColor(clrBlack);
   m_table4.GridColor(clrLightGray);
   m_table4.TableSize(COLUMNS4_TOTAL,ROWS4_TOTAL);
   m_table4.VisibleTableSize(visible_columns_total,visible_rows_total);
//---   
   if(!m_table4.CreateTable(m_chart_id,m_subwin,x,y))
      return(false);
//---  :
//      
   for(int c=0; c<COLUMNS4_TOTAL; c++)
     {
      for(int r=0; r<1; r++)
         m_table4.SetValue(c,r,"SYMBOL "+string(c));
     }
//---     (    )
   for(int c=0; c<COLUMNS4_TOTAL; c++)
     {
      for(int r=1; r<ROWS4_TOTAL; r++)
         m_table4.SetValue(c,r,string(c)+":"+string(r));
     }
//---     
   m_table4.UpdateTable();
//---      
   CWndContainer::AddToElementsArray(0,m_table4);
   return(true);
  }
//+------------------------------------------------------------------+
