//+------------------------------------------------------------------+
//|                                                 WndContainer.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property strict
#include "Window.mqh"
#include "MenuBar.mqh"
#include "MenuItem.mqh"
#include "ContextMenu.mqh"
#include "SeparateLine.mqh"
#include "SimpleButton.mqh"
#include "IconButton.mqh"
#include "SplitButton.mqh"
#include "ButtonsGroup.mqh"
#include "IconButtonsGroup.mqh"
#include "RadioButtons.mqh"
#include "StatusBar.mqh"
#include "Tooltip.mqh"
#include "ListView.mqh"
#include "ComboBox.mqh"
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
class CWndContainer
  {
private:
   //---  
   int               m_counter_element_id;
   //---
protected:
   //---  
   CWindow          *m_windows[];
   //---   
   struct WindowElements
     {
      //---    
      CChartObject     *m_objects[];
      //---    
      CElement         *m_elements[];

      //---   :
      //      
      CContextMenu     *m_context_menus[];
      //---   
      CMenuBar         *m_menu_bars[];
      //---  
      CTooltip         *m_tooltips[];
      //---     
      CElement         *m_drop_lists[];
     };
   //---      
   WindowElements    m_wnd[];
   //---
protected:
                     CWndContainer(void);
                    ~CWndContainer(void);
   //---
public:
   //---    
   int               WindowsTotal(void) { return(::ArraySize(m_windows)); }
   //---    
   int               ObjectsElementsTotal(const int window_index);
   //---  
   int               ElementsTotal(const int window_index);
   //---   
   int               ContextMenusTotal(const int window_index);
   //---   
   int               MenuBarsTotal(const int window_index);
   //---   
   int               TooltipsTotal(const int window_index);
   //---   
   int               DropListsTotal(const int window_index);
   //---
protected:
   //---       
   void              AddWindow(CWindow &object);
   //---       
   template<typename T>
   void              AddToObjectsArray(const int window_index,T &object);
   //---     
   void              AddToArray(const int window_index,CChartObject &object);
   //---     
   void              AddToElementsArray(const int window_index,CElement &object);
   //---          
   template<typename T1,typename T2>
   void              AddToRefArray(T1 &object,T2 &ref_array[]);
   //---
private:
   //---        
   bool              AddContextMenuElements(const int window_index,CElement &object);
   //---        
   bool              AddMenuBarElements(const int window_index,CElement &object);
   //---        
   bool              AddSplitButtonElements(const int window_index,CElement &object);
   //---        
   bool              AddTooltipElements(const int window_index,CElement &object);
   //---       
   bool              AddListViewElements(const int window_index,CElement &object);
   //---        
   bool              AddComboBoxElements(const int window_index,CElement &object);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CWndContainer::CWndContainer(void) : m_counter_element_id(0)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CWndContainer::~CWndContainer(void)
  {
  }
//+------------------------------------------------------------------+
//|  -                 |
//+------------------------------------------------------------------+
int CWndContainer::ObjectsElementsTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_objects));
  }
//+------------------------------------------------------------------+
//|  -                |
//+------------------------------------------------------------------+
int CWndContainer::ElementsTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_elements));
  }
//+------------------------------------------------------------------+
//|  -          |
//+------------------------------------------------------------------+
int CWndContainer::ContextMenusTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_context_menus));
  }
//+------------------------------------------------------------------+
//|  -              |
//+------------------------------------------------------------------+
int CWndContainer::MenuBarsTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_menu_bars));
  }
//+------------------------------------------------------------------+
//|  -                |
//+------------------------------------------------------------------+
int CWndContainer::TooltipsTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_tooltips));
  }
//+------------------------------------------------------------------+
//|  -        |
//+------------------------------------------------------------------+
int CWndContainer::DropListsTotal(const int window_index)
  {
   if(window_index>=::ArraySize(m_wnd))
     {
      ::Print(PREVENTING_OUT_OF_RANGE);
      return(WRONG_VALUE);
     }
//---
   return(::ArraySize(m_wnd[window_index].m_drop_lists));
  }
//+------------------------------------------------------------------+
//|                    |
//+------------------------------------------------------------------+
void CWndContainer::AddWindow(CWindow &object)
  {
   int windows_total=::ArraySize(m_windows);
//---   ,   
   if(windows_total<1)
      m_counter_element_id=0;
//---     
   ::ArrayResize(m_wnd,windows_total+1);
   ::ArrayResize(m_windows,windows_total+1);
   m_windows[windows_total]=::GetPointer(object);
//---      
   int elements_total=::ArraySize(m_wnd[windows_total].m_elements);
   ::ArrayResize(m_wnd[windows_total].m_elements,elements_total+1);
   m_wnd[windows_total].m_elements[elements_total]=::GetPointer(object);
//---       
   AddToObjectsArray(windows_total,object);
//---     id  
   m_windows[windows_total].Id(m_counter_element_id);
   m_windows[windows_total].LastId(m_counter_element_id);
//---    
   m_counter_element_id++;
  }
//+------------------------------------------------------------------+
//|                    |
//+------------------------------------------------------------------+
template<typename T>
void CWndContainer::AddToObjectsArray(const int window_index,T &object)
  {
   int total=object.ObjectsElementTotal();
   for(int i=0; i<total; i++)
      AddToArray(window_index,object.Object(i));
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
void CWndContainer::AddToArray(const int window_index,CChartObject &object)
  {
   int size=::ArraySize(m_wnd[window_index].m_objects);
   ::ArrayResize(m_wnd[window_index].m_objects,size+1);
   m_wnd[window_index].m_objects[size]=::GetPointer(object);
  }
//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
void CWndContainer::AddToElementsArray(const int window_index,CElement &object)
  {
//---        
   if(::ArraySize(m_windows)<1)
     {
      ::Print(__FUNCTION__," >        "
              "        CWndContainer::AddWindow(CWindow &object).");
      return;
     }
//---     
   if(window_index>=::ArraySize(m_windows))
     {
      Print(PREVENTING_OUT_OF_RANGE," window_index: ",window_index,"; ArraySize(m_windows): ",::ArraySize(m_windows));
      return;
     }
//---     
   int size=::ArraySize(m_wnd[window_index].m_elements);
   ::ArrayResize(m_wnd[window_index].m_elements,size+1);
   m_wnd[window_index].m_elements[size]=::GetPointer(object);
//---       
   AddToObjectsArray(window_index,object);
//---     id  
   int windows_total=::ArraySize(m_windows);
   for(int w=0; w<windows_total; w++)
      m_windows[w].LastId(m_counter_element_id);
//---    
   m_counter_element_id++;

//---        
   if(AddContextMenuElements(window_index,object))
      return;
//---        
   if(AddMenuBarElements(window_index,object))
      return;
//---        
   if(AddSplitButtonElements(window_index,object))
      return;
//---        
   if(AddTooltipElements(window_index,object))
      return;
//---       
   if(AddListViewElements(window_index,object))
      return;
//---      -  
   if(AddComboBoxElements(window_index,object))
      return;
  }
//+------------------------------------------------------------------+
//|                  |
//+------------------------------------------------------------------+
bool CWndContainer::AddContextMenuElements(const int window_index,CElement &object)
  {
//--- ,     
   if(object.ClassName()!="CContextMenu")
      return(false);
//---     
   CContextMenu *cm=::GetPointer(object);
//---       
   int items_total=cm.ItemsTotal();
   for(int i=0; i<items_total; i++)
     {
      //---   
      int size=::ArraySize(m_wnd[window_index].m_elements);
      ::ArrayResize(m_wnd[window_index].m_elements,size+1);
      //---     
      CMenuItem *mi=cm.ItemPointerByIndex(i);
      //---    
      m_wnd[window_index].m_elements[size]=mi;
      //---          
      AddToObjectsArray(window_index,mi);
     }
//---     
   AddToRefArray(cm,m_wnd[window_index].m_context_menus);
   return(true);
  }
//+------------------------------------------------------------------+
//|                      |
//+------------------------------------------------------------------+
bool CWndContainer::AddMenuBarElements(const int window_index,CElement &object)
  {
//--- ,     
   if(object.ClassName()!="CMenuBar")
      return(false);
//---     
   CMenuBar *mb=::GetPointer(object);
//---       
   int items_total=mb.ItemsTotal();
   for(int i=0; i<items_total; i++)
     {
      //---   
      int size=::ArraySize(m_wnd[window_index].m_elements);
      ::ArrayResize(m_wnd[window_index].m_elements,size+1);
      //---     
      CMenuItem *mi=mb.ItemPointerByIndex(i);
      //---    
      m_wnd[window_index].m_elements[size]=mi;
      //---          
      AddToObjectsArray(window_index,mi);
     }
//---     
   AddToRefArray(mb,m_wnd[window_index].m_menu_bars);
   return(true);
  }
//+------------------------------------------------------------------+
//|                   |
//+------------------------------------------------------------------+
bool CWndContainer::AddSplitButtonElements(const int window_index,CElement &object)
  {
//--- ,     
   if(object.ClassName()!="CSplitButton")
      return(false);
//---     
   CSplitButton *sb=::GetPointer(object);
//---   
   int size=::ArraySize(m_wnd[window_index].m_elements);
   ::ArrayResize(m_wnd[window_index].m_elements,size+1);
//---    
   CContextMenu *cm=sb.GetContextMenuPointer();
//---      
   m_wnd[window_index].m_elements[size]=cm;
   AddToObjectsArray(window_index,cm);
//---       
   int items_total=cm.ItemsTotal();
   for(int i=0; i<items_total; i++)
     {
      //---   
      size=::ArraySize(m_wnd[window_index].m_elements);
      ::ArrayResize(m_wnd[window_index].m_elements,size+1);
      //---     
      CMenuItem *mi=cm.ItemPointerByIndex(i);
      //---    
      m_wnd[window_index].m_elements[size]=mi;
      //---          
      AddToObjectsArray(window_index,mi);
     }
//---     
   AddToRefArray(cm,m_wnd[window_index].m_context_menus);
   return(true);
  }
//+------------------------------------------------------------------+
//|                  |
//+------------------------------------------------------------------+
bool CWndContainer::AddTooltipElements(const int window_index,CElement &object)
  {
//--- ,     
   if(object.ClassName()!="CTooltip")
      return(false);
//---     
   CTooltip *t=::GetPointer(object);
//---     
   AddToRefArray(t,m_wnd[window_index].m_tooltips);
   return(true);
  }
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
bool CWndContainer::AddListViewElements(const int window_index,CElement &object)
  {
//--- ,    
   if(object.ClassName()!="CListView")
      return(false);
//---    
   CListView *lv=::GetPointer(object);
//---   
   int size=::ArraySize(m_wnd[window_index].m_elements);
   ::ArrayResize(m_wnd[window_index].m_elements,size+1);
//---    
   CScrollV *sv=lv.GetScrollVPointer();
//---    
   m_wnd[window_index].m_elements[size]=sv;
   AddToObjectsArray(window_index,sv);
   return(true);
  }
//+------------------------------------------------------------------+
//|           |
//+------------------------------------------------------------------+
bool CWndContainer::AddComboBoxElements(const int window_index,CElement &object)
  {
//--- ,     
   if(object.ClassName()!="CComboBox")
      return(false);
//---    -
   CComboBox *cb=::GetPointer(object);
//---
   for(int i=0; i<2; i++)
     {
      //---   
      int size=::ArraySize(m_wnd[window_index].m_elements);
      ::ArrayResize(m_wnd[window_index].m_elements,size+1);
      //---    
      if(i==0)
        {
         CListView *lv=cb.GetListViewPointer();
         m_wnd[window_index].m_elements[size]=lv;
         AddToObjectsArray(window_index,lv);
         //---     
         AddToRefArray(lv,m_wnd[window_index].m_drop_lists);
        }
      //---     
      else if(i==1)
        {
         CScrollV *sv=cb.GetScrollVPointer();
         m_wnd[window_index].m_elements[size]=sv;
         AddToObjectsArray(window_index,sv);
        }
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|   (T1)      (T2)      |
//+------------------------------------------------------------------+
template<typename T1,typename T2>
void CWndContainer::AddToRefArray(T1 &object,T2 &array[])
  {
   int size=::ArraySize(array);
   ::ArrayResize(array,size+1);
   array[size]=object;
  }
//+------------------------------------------------------------------+
