//+------------------------------------------------------------------+
//|                                                      Program.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <EasyAndFastGUI\Controls\WndEvents.mqh>
//+------------------------------------------------------------------+
//|                                        |
//+------------------------------------------------------------------+
class CProgram : public CWndEvents
  {
private:
   //--- 
   CWindow           m_window;
   //---      
   CMenuBar          m_menubar;
   CContextMenu      m_mb_contextmenu1;
   CContextMenu      m_mb_contextmenu2;
   CContextMenu      m_mb_contextmenu3;
   CContextMenu      m_mb_contextmenu4;
   //---    1
   CButtonsGroup     m_buttons_group1;
   //---  - 1
   CRadioButtons     m_radio_buttons1;
   //---    2
   CButtonsGroup     m_buttons_group2;
   //---  - 2,3,4
   CRadioButtons     m_radio_buttons2;
   CRadioButtons     m_radio_buttons3;
   CRadioButtons     m_radio_buttons4;
   //---     1
   CIconButtonsGroup m_icon_buttons_group1;
   //---
public:
                     CProgram(void);
                    ~CProgram(void);
   //--- /
   void              OnInitEvent(void);
   void              OnDeinitEvent(const int reason);
   //--- 
   void              OnTimerEvent(void);
   //---
protected:
   //---   
   virtual void      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);
   //---
public:
   //---   
   bool              CreateTradePanel(void);
   //---
private:
   //--- 
   bool              CreateWindow(const string text);
   //---      
#define MENUBAR_GAP_X        (1)
#define MENUBAR_GAP_Y        (20)
   bool              CreateMenuBar(void);
   bool              CreateMBContextMenu1(void);
   bool              CreateMBContextMenu2(void);
   bool              CreateMBContextMenu3(void);
   bool              CreateMBContextMenu4(void);
   //---    1
#define BUTTONS_GROUP1_GAP_X     (7)
#define BUTTONS_GROUP1_GAP_Y     (50)
   bool              CreateButtonsGroup1(void);
   //---  - 1
#define RADIO_BUTTONS1_GAP_X     (7)
#define RADIO_BUTTONS1_GAP_Y     (75)
   bool              CreateRadioButtons1();
   //---    2
#define BUTTONS_GROUP2_GAP_X     (7)
#define BUTTONS_GROUP2_GAP_Y     (100)
   bool              CreateButtonsGroup2(void);
   //---  - 2,3,4
#define RADIO_BUTTONS2_GAP_X     (7)
#define RADIO_BUTTONS2_GAP_Y     (125)
   bool              CreateRadioButtons2();
#define RADIO_BUTTONS3_GAP_X     (105)
#define RADIO_BUTTONS3_GAP_Y     (125)
   bool              CreateRadioButtons3();
#define RADIO_BUTTONS4_GAP_X     (203)
#define RADIO_BUTTONS4_GAP_Y     (125)
   bool              CreateRadioButtons4();
   //---     1
#define IBUTTONS_GROUP1_GAP_X    (7)
#define IBUTTONS_GROUP1_GAP_Y    (190)
   bool              CreateIconButtonsGroup1(void);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CProgram::CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CProgram::~CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
void CProgram::OnInitEvent(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void CProgram::OnDeinitEvent(const int reason)
  {
//---  
   CWndEvents::Destroy();
  }
//+------------------------------------------------------------------+
//|                                                            |
//+------------------------------------------------------------------+
void CProgram::OnTimerEvent(void)
  {
   CWndEvents::OnTimerEvent();
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void CProgram::OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
//---     
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_LABEL)
     {
      ::Print("id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
      return;
     }
//---     
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_CONTEXTMENU_ITEM)
     {
      ::Print(__FUNCTION__," > id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
      return;
     }
//---    
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_BUTTON)
     {
      ::Print("id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
      //---         
      //              
      if(lparam==m_buttons_group2.Id() && sparam==m_buttons_group2.SelectedButtonText())
        {
         //---    ,   
         if((int)dparam==0)
           {
            m_buttons_group1.ButtonsGroupState(true);
            m_radio_buttons1.RadioButtonsState(true);
            m_icon_buttons_group1.IconButtonsState(true);
           }
         //---    ,   
         else
           {
            m_buttons_group1.ButtonsGroupState(false);
            m_radio_buttons1.RadioButtonsState(false);
            m_icon_buttons_group1.IconButtonsState(false);
           }
        }
      return;
     }
  }
//+------------------------------------------------------------------+
//|                                             |
//+------------------------------------------------------------------+
bool CProgram::CreateTradePanel(void)
  {
//---     
   if(!CreateWindow("EXPERT PANEL"))
      return(false);
//---   :
//     
   if(!CreateMenuBar())
      return(false);
//---  
   if(!CreateMBContextMenu1())
      return(false);
   if(!CreateMBContextMenu2())
      return(false);
   if(!CreateMBContextMenu3())
      return(false);
   if(!CreateMBContextMenu4())
      return(false);
//---    1
   if(!CreateButtonsGroup1())
      return(false);
//---  - 1
   if(!CreateRadioButtons1())
      return(false);
//---    2
   if(!CreateButtonsGroup2())
      return(false);
//---  - 2,3,4
   if(!CreateRadioButtons2())
      return(false);
   if(!CreateRadioButtons3())
      return(false);
   if(!CreateRadioButtons4())
      return(false);
//---     1
   if(!CreateIconButtonsGroup1())
      return(false);
//---  
   m_chart.Redraw();
   return(true);
  }
//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
bool CProgram::CreateWindow(const string caption_text)
  {
//---      
   CWndContainer::AddWindow(m_window);
//--- 
   int x=1;
   int y=20;
//--- 
   m_window.Movable(true);
   m_window.XSize(300);
   m_window.YSize(290);
   m_window.WindowBgColor(clrWhiteSmoke);
   m_window.WindowBorderColor(clrLightSteelBlue);
   m_window.CaptionBgColor(clrLightSteelBlue);
   m_window.CaptionBgColorHover(clrLightSteelBlue);
//---  
   if(!m_window.CreateWindow(m_chart_id,m_subwin,caption_text,x,y))
      return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateMenuBar(void)
  {
//---     
#define MENUBAR_TOTAL 3
//---    
   m_menubar.WindowPointer(m_window);
//--- 
   int x=m_window.X()+MENUBAR_GAP_X;
   int y=m_window.Y()+MENUBAR_GAP_Y;
//---     
   int    width[MENUBAR_TOTAL] ={50,55,53};
   string text[MENUBAR_TOTAL]  ={"File","View","Help"};
//--- 
   m_menubar.MenuBackColor(C'225,225,225');
   m_menubar.MenuBorderColor(C'225,225,225');
   m_menubar.ItemBackColor(C'225,225,225');
   m_menubar.ItemBorderColor(C'225,225,225');
//---     
   for(int i=0; i<MENUBAR_TOTAL; i++)
      m_menubar.AddItem(width[i],text[i]);
//---   
   if(!m_menubar.CreateMenuBar(m_chart_id,m_subwin,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_menubar);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
//---
bool CProgram::CreateMBContextMenu1(void)
  {
//---     
#define CONTEXTMENU_ITEMS1 3
//---    
   m_mb_contextmenu1.WindowPointer(m_window);
//---     
   m_mb_contextmenu1.PrevNodePointer(m_menubar.ItemPointerByIndex(0));
//---       
   m_menubar.AddContextMenuPointer(0,m_mb_contextmenu1);
//---   
   string items_text[CONTEXTMENU_ITEMS1]=
     {
      "ContextMenu 1 Item 1",
      "ContextMenu 1 Item 2",
      "ContextMenu 1 Item 3..."
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_SIMPLE
     };
//---    
   m_mb_contextmenu1.FixSide(FIX_BOTTOM);
   m_mb_contextmenu1.XSize(160);
   m_mb_contextmenu1.AreaBackColor(C'240,240,240');
   m_mb_contextmenu1.AreaBorderColor(clrSilver);
   m_mb_contextmenu1.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu1.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu1.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu1.LabelColor(clrBlack);
   m_mb_contextmenu1.LabelColorHover(clrWhite);
   m_mb_contextmenu1.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu1.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS1; i++)
      m_mb_contextmenu1.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu1.AddSeparateLine(1);
//---   
   m_mb_contextmenu1.ItemPointerByIndex(1).ItemState(false);
//---   
   if(!m_mb_contextmenu1.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu1);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu2(void)
  {
//---     
#define CONTEXTMENU_ITEMS2 3
//---    
   m_mb_contextmenu2.WindowPointer(m_window);
//---     
   m_mb_contextmenu2.PrevNodePointer(m_menubar.ItemPointerByIndex(1));
//---       
   m_menubar.AddContextMenuPointer(1,m_mb_contextmenu2);
//---   
   string items_text[CONTEXTMENU_ITEMS2]=
     {
      "ContextMenu 2 Item 1",
      "ContextMenu 2 Item 2",
      "ContextMenu 2 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS2]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu2.FixSide(FIX_BOTTOM);
   m_mb_contextmenu2.XSize(160);
   m_mb_contextmenu2.AreaBackColor(C'240,240,240');
   m_mb_contextmenu2.AreaBorderColor(clrSilver);
   m_mb_contextmenu2.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu2.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu2.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu2.LabelColor(clrBlack);
   m_mb_contextmenu2.LabelColorHover(clrWhite);
   m_mb_contextmenu2.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu2.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS2; i++)
      m_mb_contextmenu2.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu2.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu2.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu2);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp"
//---
bool CProgram::CreateMBContextMenu3(void)
  {
//---     
#define CONTEXTMENU_ITEMS3 5
//---    
   m_mb_contextmenu3.WindowPointer(m_window);
//---     
   m_mb_contextmenu3.PrevNodePointer(m_menubar.ItemPointerByIndex(2));
//---       
   m_menubar.AddContextMenuPointer(2,m_mb_contextmenu3);
//---   
   string items_text[CONTEXTMENU_ITEMS3]=
     {
      "ContextMenu 3 Item 1",
      "ContextMenu 3 Item 2",
      "ContextMenu 3 Item 3...",
      "ContextMenu 3 Item 4",
      "ContextMenu 3 Item 5"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp",
      "",""
     };
//---      
   string items_bmp_off[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS3]=
     {
      MI_SIMPLE,
      MI_HAS_CONTEXT_MENU,
      MI_SIMPLE,
      MI_CHECKBOX,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu3.FixSide(FIX_BOTTOM);
   m_mb_contextmenu3.XSize(160);
   m_mb_contextmenu3.AreaBackColor(C'240,240,240');
   m_mb_contextmenu3.AreaBorderColor(clrSilver);
   m_mb_contextmenu3.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu3.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu3.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu3.LabelColor(clrBlack);
   m_mb_contextmenu3.LabelColorHover(clrWhite);
   m_mb_contextmenu3.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu3.SeparateLineLightColor(clrWhite);
   m_mb_contextmenu3.RightArrowFileOff("Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp");
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS3; i++)
      m_mb_contextmenu3.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu3.AddSeparateLine(2);
//---   
   if(!m_mb_contextmenu3.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu3);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu4(void)
  {
//---     
#define CONTEXTMENU_ITEMS4 3
//---    
   m_mb_contextmenu4.WindowPointer(m_window);
//---     
   m_mb_contextmenu4.PrevNodePointer(m_mb_contextmenu3.ItemPointerByIndex(1));
//---   
   string items_text[CONTEXTMENU_ITEMS4]=
     {
      "ContextMenu 4 Item 1",
      "ContextMenu 4 Item 2",
      "ContextMenu 4 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS4]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu4.XSize(160);
   m_mb_contextmenu4.AreaBackColor(C'240,240,240');
   m_mb_contextmenu4.AreaBorderColor(clrSilver);
   m_mb_contextmenu4.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu4.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu4.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu4.LabelColor(clrBlack);
   m_mb_contextmenu4.LabelColorHover(clrWhite);
   m_mb_contextmenu4.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu4.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS4; i++)
      m_mb_contextmenu4.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu4.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu4.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu4);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
bool CProgram::CreateButtonsGroup1(void)
  {
//---    
   m_buttons_group1.WindowPointer(m_window);
//--- 
   int x =m_window.X()+BUTTONS_GROUP1_GAP_X;
   int y =m_window.Y()+BUTTONS_GROUP1_GAP_Y;
//--- 
   int    buttons_x_gap[]         ={0,72,144,216};
   string buttons_text[]          ={"BUTTON 1","BUTTON 2","BUTTON 3","BUTTON 4"};
   int    buttons_width[]         ={70,70,70,70};
   color  buttons_color[]         ={C'255,140,140',C'255,140,140',C'140,200,240',C'140,200,240'};
   color  buttons_color_hover[]   ={C'255,180,180',C'255,180,180',C'180,220,255',C'180,220,255'};
   color  buttons_color_pressed[] ={C'225,90,90',C'225,90,90',C'110,160,190',C'110,160,190'};
//---  
   m_buttons_group1.TextColor(clrBlack);
   m_buttons_group1.TextColorPressed(clrWhite);
   m_buttons_group1.BorderColor(C'150,170,180');
   m_buttons_group1.BorderColorOff(C'178,195,207');
//---     
   for(int i=0; i<4; i++)
      m_buttons_group1.AddButton(buttons_x_gap[i],0,buttons_text[i],buttons_width[i],
                                 buttons_color[i],buttons_color_hover[i],buttons_color_pressed[i]);
//---   
   if(!m_buttons_group1.CreateButtonsGroup(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_buttons_group1.SelectionButton(1);
//---  
   m_buttons_group1.ButtonsGroupState(false);   
//---      
   CWndContainer::AddToElementsArray(0,m_buttons_group1);
   return(true);
  }
//+------------------------------------------------------------------+
//|   - 1                                    |
//+------------------------------------------------------------------+
bool CProgram::CreateRadioButtons1(void)
  {
//---    
   m_radio_buttons1.WindowPointer(m_window);
//--- 
   int x =m_window.X()+RADIO_BUTTONS1_GAP_X;
   int y =m_window.Y()+RADIO_BUTTONS1_GAP_Y;
//--- 
   int    buttons_x_offset[] ={0,98,196};
   int    buttons_y_offset[] ={0,0,0};
   string buttons_text[]     ={"Radio Button 1","Radio Button 2","Radio Button 3"};
   int    buttons_width[]    ={92,92,92};
//---    
   m_radio_buttons1.AreaColor(clrWhiteSmoke);
   m_radio_buttons1.TextColor(clrBlack);
//---     
   for(int i=0; i<3; i++)
      m_radio_buttons1.AddButton(buttons_x_offset[i],buttons_y_offset[i],buttons_text[i],buttons_width[i]);
//---   
   if(!m_radio_buttons1.CreateRadioButtons(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_radio_buttons1.SelectionRadioButton(1);
//---  -
   m_radio_buttons1.RadioButtonsState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_radio_buttons1);
   return(true);
  }
//+------------------------------------------------------------------+
//|      2                               |
//+------------------------------------------------------------------+
bool CProgram::CreateButtonsGroup2(void)
  {
//---    
   m_buttons_group2.WindowPointer(m_window);
//--- 
   int x  =m_window.X()+BUTTONS_GROUP2_GAP_X;
   int y  =m_window.Y()+BUTTONS_GROUP2_GAP_Y;
//--- 
   int    buttons_x_offset[] ={0,144};
   string buttons_text[]     ={"BUTTON 1","BUTTON 2"};
//---  
   m_buttons_group2.RadioButtonsMode(true);
   m_buttons_group2.TextColor(clrBlack);
   m_buttons_group2.TextColorPressed(clrBlack);
   m_buttons_group2.BorderColor(C'150,170,180');
   m_buttons_group2.BorderColorOff(C'178,195,207');
//---     
   for(int i=0; i<2; i++)
      m_buttons_group2.AddButton(buttons_x_offset[i],0,buttons_text[i],142,
                                 clrGainsboro,C'193,218,255',C'190,190,200');
//---   
   if(!m_buttons_group2.CreateButtonsGroup(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_buttons_group2.SelectionButton(1);
//---      
   CWndContainer::AddToElementsArray(0,m_buttons_group2);
   return(true);
  }
//+------------------------------------------------------------------+
//|   - 2                                    |
//+------------------------------------------------------------------+
bool CProgram::CreateRadioButtons2(void)
  {
//---    
   m_radio_buttons2.WindowPointer(m_window);
//--- 
   int x =m_window.X()+RADIO_BUTTONS2_GAP_X;
   int y =m_window.Y()+RADIO_BUTTONS2_GAP_Y;
//--- 
   int    buttons_x_offset[] ={0,0,0};
   int    buttons_y_offset[] ={0,20,40};
   string buttons_text[]     ={"Radio Button 1","Radio Button 2","Radio Button 3"};
   int    buttons_width[]    ={92,92,92};
//---    
   m_radio_buttons2.AreaColor(clrWhiteSmoke);
   m_radio_buttons2.TextColor(clrBlack);
//---     
   for(int i=0; i<3; i++)
      m_radio_buttons2.AddButton(buttons_x_offset[i],buttons_y_offset[i],buttons_text[i],buttons_width[i]);
//---   
   if(!m_radio_buttons2.CreateRadioButtons(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_radio_buttons2.SelectionRadioButton(2);
//---      
   CWndContainer::AddToElementsArray(0,m_radio_buttons2);
   return(true);
  }
//+------------------------------------------------------------------+
//|   - 3                                    |
//+------------------------------------------------------------------+
bool CProgram::CreateRadioButtons3(void)
  {
//---    
   m_radio_buttons3.WindowPointer(m_window);
//--- 
   int x =m_window.X()+RADIO_BUTTONS3_GAP_X;
   int y =m_window.Y()+RADIO_BUTTONS3_GAP_Y;
//--- 
   int    buttons_x_offset[] ={0,0,0};
   int    buttons_y_offset[] ={0,20,40};
   string buttons_text[]     ={"Radio Button 1","Radio Button 2","Radio Button 3"};
   int    buttons_width[]    ={92,92,92};
//---    
   m_radio_buttons3.AreaColor(clrWhiteSmoke);
   m_radio_buttons3.TextColor(clrBlack);
//---     
   for(int i=0; i<3; i++)
      m_radio_buttons3.AddButton(buttons_x_offset[i],buttons_y_offset[i],buttons_text[i],buttons_width[i]);
//---   
   if(!m_radio_buttons3.CreateRadioButtons(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_radio_buttons3.SelectionRadioButton(0);
//---      
   CWndContainer::AddToElementsArray(0,m_radio_buttons3);
   return(true);
  }
//+------------------------------------------------------------------+
//|   - 4                                    |
//+------------------------------------------------------------------+
bool CProgram::CreateRadioButtons4(void)
  {
//---    
   m_radio_buttons4.WindowPointer(m_window);
//--- 
   int x =m_window.X()+RADIO_BUTTONS4_GAP_X;
   int y =m_window.Y()+RADIO_BUTTONS4_GAP_Y;
//--- 
   int    buttons_x_offset[] ={0,0,0};
   int    buttons_y_offset[] ={0,20,40};
   string buttons_text[]     ={"Radio Button 1","Radio Button 2","Radio Button 3"};
   int    buttons_width[]    ={92,92,92};
//---    
   m_radio_buttons4.AreaColor(clrWhiteSmoke);
   m_radio_buttons4.TextColor(clrBlack);
//---     
   for(int i=0; i<3; i++)
      m_radio_buttons4.AddButton(buttons_x_offset[i],buttons_y_offset[i],buttons_text[i],buttons_width[i]);
//---   
   if(!m_radio_buttons4.CreateRadioButtons(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_radio_buttons4.SelectionRadioButton(3);
//---   
   m_radio_buttons4.RadioButtonsState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_radio_buttons4);
   return(true);
  }
//+------------------------------------------------------------------+
//|       1                          |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\safe.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\safe_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\gold.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\gold_colorless.bmp"
//---
bool CProgram::CreateIconButtonsGroup1(void)
  {
//---    
   m_icon_buttons_group1.WindowPointer(m_window);
//--- 
   int x =m_window.X()+IBUTTONS_GROUP1_GAP_X;
   int y =m_window.Y()+IBUTTONS_GROUP1_GAP_Y;
//--- 
   int    buttons_x_gap[] ={0,97,194};
   int    buttons_y_gap[] ={0,0,0};
   string buttons_text[]  ={"Icon button 1","Icon button 2","Icon button 3"};
   int    buttons_width[] ={92,92,92};
//---     
   string items_bmp_on[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\safe.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\gold.bmp"
     };
//---      
   string items_bmp_off[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\safe_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp64\\gold_colorless.bmp"
     };
//---     
   m_icon_buttons_group1.ButtonsYSize(85);
   m_icon_buttons_group1.IconXGap(14);
   m_icon_buttons_group1.IconYGap(5);
   m_icon_buttons_group1.LabelXGap(15);
   m_icon_buttons_group1.LabelYGap(69);
   m_icon_buttons_group1.BackColor(clrLightGray);
   m_icon_buttons_group1.BackColorHover(C'193,218,255');
   m_icon_buttons_group1.BackColorPressed(C'190,190,200');
   m_icon_buttons_group1.BorderColor(C'150,170,180');
   m_icon_buttons_group1.BorderColorOff(C'178,195,207');
//---     
   for(int i=0; i<3; i++)
      m_icon_buttons_group1.AddButton(buttons_x_gap[i],buttons_y_gap[i],buttons_text[i],
                                      buttons_width[i],items_bmp_on[i],items_bmp_off[i]);
//---   
   if(!m_icon_buttons_group1.CreateIconButtonsGroup(m_chart_id,m_subwin,x,y))
      return(false);
//---     
   m_icon_buttons_group1.SelectedRadioButton(1);
//---   
   m_icon_buttons_group1.IconButtonsState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_buttons_group1);
   return(true);
  }
//+------------------------------------------------------------------+
