//+------------------------------------------------------------------+
//|                                                      Program.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <EasyAndFastGUI\Controls\WndEvents.mqh>
//+------------------------------------------------------------------+
//|                                        |
//+------------------------------------------------------------------+
class CProgram : public CWndEvents
  {
private:
   //--- 
   CWindow           m_window;
   //---      
   CMenuBar          m_menubar;
   CContextMenu      m_mb_contextmenu1;
   CContextMenu      m_mb_contextmenu2;
   CContextMenu      m_mb_contextmenu3;
   CContextMenu      m_mb_contextmenu4;
   //---  
   CSimpleButton     m_simple_button1;
   CSimpleButton     m_simple_button2;
   CSimpleButton     m_simple_button3;
   //---   
   CIconButton       m_icon_button1;
   CIconButton       m_icon_button2;
   CIconButton       m_icon_button3;
   CIconButton       m_icon_button4;
   CIconButton       m_icon_button5;
   //---  
   CSplitButton      m_split_button1;
   CSplitButton      m_split_button2;
   CSplitButton      m_split_button3;
   CSplitButton      m_split_button4;
   //---
public:
                     CProgram(void);
                    ~CProgram(void);
   //--- /
   void              OnInitEvent(void);
   void              OnDeinitEvent(const int reason);
   //--- 
   void              OnTimerEvent(void);
   //---
protected:
   //---   
   virtual void      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);
   //---
public:
   //---   
   bool              CreateTradePanel(void);
   //---
private:
   //--- 
   bool              CreateWindow(const string text);
   //---      
#define MENUBAR_GAP_X    (1)
#define MENUBAR_GAP_Y    (20)
   bool              CreateMenuBar(void);
   bool              CreateMBContextMenu1(void);
   bool              CreateMBContextMenu2(void);
   bool              CreateMBContextMenu3(void);
   bool              CreateMBContextMenu4(void);
   //---  
#define BUTTON1_GAP_X            (7)
#define BUTTON1_GAP_Y            (50)
   bool              CreateSimpleButton1(const string text);
#define BUTTON2_GAP_X            (128)
#define BUTTON2_GAP_Y            (50)
   bool              CreateSimpleButton2(const string text);
#define BUTTON3_GAP_X            (7)
#define BUTTON3_GAP_Y            (75)
   bool              CreateSimpleButton3(const string text);
   //---   
#define ICONBUTTON1_GAP_X        (7)
#define ICONBUTTON1_GAP_Y        (105)
   bool              CreateIconButton1(const string text);
#define ICONBUTTON2_GAP_X        (128)
#define ICONBUTTON2_GAP_Y        (105)
   bool              CreateIconButton2(const string text);
#define ICONBUTTON3_GAP_X        (7)
#define ICONBUTTON3_GAP_Y        (130)
   bool              CreateIconButton3(const string text);
#define ICONBUTTON4_GAP_X        (87)
#define ICONBUTTON4_GAP_Y        (130)
   bool              CreateIconButton4(const string text);
#define ICONBUTTON5_GAP_X        (168)
#define ICONBUTTON5_GAP_Y        (130)
   bool              CreateIconButton5(const string text);
   //---  
#define SPLITBUTTON1_GAP_X       (7)
#define SPLITBUTTON1_GAP_Y       (225)
   bool              CreateSplitButton1(const string text);
#define SPLITBUTTON2_GAP_X       (128)
#define SPLITBUTTON2_GAP_Y       (225)
   bool              CreateSplitButton2(const string text);
#define SPLITBUTTON3_GAP_X       (7)
#define SPLITBUTTON3_GAP_Y       (250)
   bool              CreateSplitButton3(const string text);
#define SPLITBUTTON4_GAP_X       (128)
#define SPLITBUTTON4_GAP_Y       (250)
   bool              CreateSplitButton4(const string text);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CProgram::CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CProgram::~CProgram(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
void CProgram::OnInitEvent(void)
  {
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void CProgram::OnDeinitEvent(const int reason)
  {
//---  
   CWndEvents::Destroy();
  }
//+------------------------------------------------------------------+
//|                                                            |
//+------------------------------------------------------------------+
void CProgram::OnTimerEvent(void)
  {
   CWndEvents::OnTimerEvent();
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void CProgram::OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
//---     
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_CONTEXTMENU_ITEM)
     {
      ::Print(__FUNCTION__," > id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
     }
//---    
   if(id==CHARTEVENT_CUSTOM+ON_CLICK_BUTTON)
     {
      ::Print(__FUNCTION__," > id: ",id,"; lparam: ",lparam,"; dparam: ",dparam,"; sparam: ",sparam);
      //---
      if(sparam==m_simple_button3.Text())
        {
         if(m_simple_button3.IsPressed())
            m_simple_button1.ButtonState(false);
         else
            m_simple_button1.ButtonState(true);
        }
      //---
      if(sparam==m_icon_button2.Text())
        {
         if(m_icon_button2.IsPressed())
           {
            m_icon_button1.ButtonState(true);
            m_icon_button4.ButtonState(true);
           }
         else
           {
            m_icon_button1.ButtonState(false);
            m_icon_button4.ButtonState(false);
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|                                             |
//+------------------------------------------------------------------+
bool CProgram::CreateTradePanel(void)
  {
//---     
   if(!CreateWindow("EXPERT PANEL"))
      return(false);
//---   :
//     
   if(!CreateMenuBar())
      return(false);
//---  
   if(!CreateMBContextMenu1())
      return(false);
   if(!CreateMBContextMenu2())
      return(false);
   if(!CreateMBContextMenu3())
      return(false);
   if(!CreateMBContextMenu4())
      return(false);
//---  
   if(!CreateSimpleButton1("Simple Button 1"))
      return(false);
   if(!CreateSimpleButton2("Simple Button 2"))
      return(false);
   if(!CreateSimpleButton3("Simple Button 3"))
      return(false);
//---   
   if(!CreateIconButton1("Icon Button 1"))
      return(false);
   if(!CreateIconButton2("Icon Button 2"))
      return(false);
   if(!CreateIconButton3("Icon Button 3"))
      return(false);
   if(!CreateIconButton4("Icon Button 4"))
      return(false);
   if(!CreateIconButton5("Icon Button 5"))
      return(false);
//---  
   if(!CreateSplitButton1("Split Button 1"))
      return(false);
   if(!CreateSplitButton2("Split Button 2"))
      return(false);
   if(!CreateSplitButton3("Split Button 3"))
      return(false);
   if(!CreateSplitButton4("Split Button 4"))
      return(false);
//---  
   m_chart.Redraw();
   return(true);
  }
//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
bool CProgram::CreateWindow(const string caption_text)
  {
//---      
   CWndContainer::AddWindow(m_window);
//--- 
   int x=1;
   int y=20;
//--- 
   m_window.Movable(true);
   m_window.XSize(251);
   m_window.YSize(285);
   m_window.WindowBgColor(clrWhiteSmoke);
   m_window.WindowBorderColor(clrLightSteelBlue);
   m_window.CaptionBgColor(clrLightSteelBlue);
   m_window.CaptionBgColorHover(clrLightSteelBlue);
//---  
   if(!m_window.CreateWindow(m_chart_id,m_subwin,caption_text,x,y))
      return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------+
//|                                                |
//+------------------------------------------------------------------+
bool CProgram::CreateMenuBar(void)
  {
//---     
#define MENUBAR_TOTAL 3
//---    
   m_menubar.WindowPointer(m_window);
//--- 
   int x=m_window.X()+MENUBAR_GAP_X;
   int y=m_window.Y()+MENUBAR_GAP_Y;
//---     
   int    width[MENUBAR_TOTAL] ={50,55,53};
   string text[MENUBAR_TOTAL]  ={"File","View","Help"};
//--- 
   m_menubar.MenuBackColor(C'225,225,225');
   m_menubar.MenuBorderColor(C'225,225,225');
   m_menubar.ItemBackColor(C'225,225,225');
   m_menubar.ItemBorderColor(C'225,225,225');
//---     
   for(int i=0; i<MENUBAR_TOTAL; i++)
      m_menubar.AddItem(width[i],text[i]);
//---   
   if(!m_menubar.CreateMenuBar(m_chart_id,m_subwin,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_menubar);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\script.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\script_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\safe_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\pie_chart_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice_colorless.bmp"
#resource "\\Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
//---
bool CProgram::CreateMBContextMenu1(void)
  {
//---     
#define CONTEXTMENU_ITEMS1 3
//---    
   m_mb_contextmenu1.WindowPointer(m_window);
//---     
   m_mb_contextmenu1.PrevNodePointer(m_menubar.ItemPointerByIndex(0));
//---       
   m_menubar.AddContextMenuPointer(0,m_mb_contextmenu1);
//---   
   string items_text[CONTEXTMENU_ITEMS1]=
     {
      "ContextMenu 1 Item 1",
      "ContextMenu 1 Item 2",
      "ContextMenu 1 Item 3..."
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS1]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_SIMPLE
     };
//---    
   m_mb_contextmenu1.FixSide(FIX_BOTTOM);
   m_mb_contextmenu1.XSize(160);
   m_mb_contextmenu1.AreaBackColor(C'240,240,240');
   m_mb_contextmenu1.AreaBorderColor(clrSilver);
   m_mb_contextmenu1.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu1.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu1.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu1.LabelColor(clrBlack);
   m_mb_contextmenu1.LabelColorHover(clrWhite);
   m_mb_contextmenu1.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu1.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS1; i++)
      m_mb_contextmenu1.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu1.AddSeparateLine(1);
//---   
   m_mb_contextmenu1.ItemPointerByIndex(1).ItemState(false);
//---   
   if(!m_mb_contextmenu1.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu1);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu2(void)
  {
//---     
#define CONTEXTMENU_ITEMS2 3
//---    
   m_mb_contextmenu2.WindowPointer(m_window);
//---     
   m_mb_contextmenu2.PrevNodePointer(m_menubar.ItemPointerByIndex(1));
//---       
   m_menubar.AddContextMenuPointer(1,m_mb_contextmenu2);
//---   
   string items_text[CONTEXTMENU_ITEMS2]=
     {
      "ContextMenu 2 Item 1",
      "ContextMenu 2 Item 2",
      "ContextMenu 2 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS2]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS2]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu2.FixSide(FIX_BOTTOM);
   m_mb_contextmenu2.XSize(160);
   m_mb_contextmenu2.AreaBackColor(C'240,240,240');
   m_mb_contextmenu2.AreaBorderColor(clrSilver);
   m_mb_contextmenu2.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu2.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu2.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu2.LabelColor(clrBlack);
   m_mb_contextmenu2.LabelColorHover(clrWhite);
   m_mb_contextmenu2.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu2.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS2; i++)
      m_mb_contextmenu2.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu2.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu2.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu2);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp"
//---
bool CProgram::CreateMBContextMenu3(void)
  {
//---     
#define CONTEXTMENU_ITEMS3 5
//---    
   m_mb_contextmenu3.WindowPointer(m_window);
//---     
   m_mb_contextmenu3.PrevNodePointer(m_menubar.ItemPointerByIndex(2));
//---       
   m_menubar.AddContextMenuPointer(2,m_mb_contextmenu3);
//---   
   string items_text[CONTEXTMENU_ITEMS3]=
     {
      "ContextMenu 3 Item 1",
      "ContextMenu 3 Item 2",
      "ContextMenu 3 Item 3...",
      "ContextMenu 3 Item 4",
      "ContextMenu 3 Item 5"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp",
      "",""
     };
//---      
   string items_bmp_off[CONTEXTMENU_ITEMS3]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS3]=
     {
      MI_SIMPLE,
      MI_HAS_CONTEXT_MENU,
      MI_SIMPLE,
      MI_CHECKBOX,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu3.FixSide(FIX_BOTTOM);
   m_mb_contextmenu3.XSize(160);
   m_mb_contextmenu3.AreaBackColor(C'240,240,240');
   m_mb_contextmenu3.AreaBorderColor(clrSilver);
   m_mb_contextmenu3.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu3.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu3.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu3.LabelColor(clrBlack);
   m_mb_contextmenu3.LabelColorHover(clrWhite);
   m_mb_contextmenu3.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu3.SeparateLineLightColor(clrWhite);
   m_mb_contextmenu3.RightArrowFileOff("Images\\EasyAndFastGUI\\Controls\\RightTransp_black.bmp");
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS3; i++)
      m_mb_contextmenu3.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu3.AddSeparateLine(2);
//---   
   if(!m_mb_contextmenu3.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu3);
   return(true);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
bool CProgram::CreateMBContextMenu4(void)
  {
//---     
#define CONTEXTMENU_ITEMS4 3
//---    
   m_mb_contextmenu4.WindowPointer(m_window);
//---     
   m_mb_contextmenu4.PrevNodePointer(m_mb_contextmenu3.ItemPointerByIndex(1));
//---   
   string items_text[CONTEXTMENU_ITEMS4]=
     {
      "ContextMenu 4 Item 1",
      "ContextMenu 4 Item 2",
      "ContextMenu 4 Item 3"
     };
//---     
   string items_bmp_on[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      ""
     };
//---     
   string items_bmp_off[CONTEXTMENU_ITEMS4]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Controls\\CheckBoxOn_min_black.bmp"
     };
//---   
   ENUM_TYPE_MENU_ITEM items_type[CONTEXTMENU_ITEMS4]=
     {
      MI_SIMPLE,
      MI_SIMPLE,
      MI_CHECKBOX
     };
//---    
   m_mb_contextmenu4.XSize(160);
   m_mb_contextmenu4.AreaBackColor(C'240,240,240');
   m_mb_contextmenu4.AreaBorderColor(clrSilver);
   m_mb_contextmenu4.ItemBackColorHover(C'240,240,240');
   m_mb_contextmenu4.ItemBackColorHoverOff(clrLightGray);
   m_mb_contextmenu4.ItemBorderColor(C'240,240,240');
   m_mb_contextmenu4.LabelColor(clrBlack);
   m_mb_contextmenu4.LabelColorHover(clrWhite);
   m_mb_contextmenu4.SeparateLineDarkColor(C'160,160,160');
   m_mb_contextmenu4.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS4; i++)
      m_mb_contextmenu4.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i],items_type[i]);
//---     
   m_mb_contextmenu4.AddSeparateLine(1);
//---   
   if(!m_mb_contextmenu4.CreateContextMenu(m_chart_id,m_subwin))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_mb_contextmenu4);
   return(true);
  }
//+------------------------------------------------------------------+
//|    1                                         |
//+------------------------------------------------------------------+
bool CProgram::CreateSimpleButton1(string button_text)
  {
//---   
   m_simple_button1.WindowPointer(m_window);
//--- 
   int x=m_window.X()+BUTTON1_GAP_X;
   int y=m_window.Y()+BUTTON1_GAP_Y;
//---    
   m_simple_button1.ButtonXSize(116);
   m_simple_button1.TextColor(clrBlack);
   m_simple_button1.TextColorPressed(clrBlack);
   m_simple_button1.BackColor(C'255,140,140');
   m_simple_button1.BackColorHover(C'255,180,180');
   m_simple_button1.BackColorPressed(C'255,120,120');
   m_simple_button1.BorderColor(C'150,170,180');
   m_simple_button1.BorderColorOff(C'178,195,207');
//---  
   if(!m_simple_button1.CreateSimpleButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_simple_button1);
   return(true);
  }
//+------------------------------------------------------------------+
//|    2                                         |
//+------------------------------------------------------------------+
bool CProgram::CreateSimpleButton2(string button_text)
  {
//---   
   m_simple_button2.WindowPointer(m_window);
//--- 
   int x=m_window.X()+BUTTON2_GAP_X;
   int y=m_window.Y()+BUTTON2_GAP_Y;
//---    
   m_simple_button2.ButtonXSize(116);
   m_simple_button2.TextColor(clrBlack);
   m_simple_button2.TextColorPressed(clrBlack);
   m_simple_button2.BackColor(C'140,200,240');
   m_simple_button2.BackColorHover(C'180,220,255');
   m_simple_button2.BackColorPressed(C'130,180,210');
   m_simple_button2.BorderColor(C'150,170,180');
   m_simple_button2.BorderColorOff(C'178,195,207');
//---  
   if(!m_simple_button2.CreateSimpleButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_simple_button2);
   return(true);
  }
//+------------------------------------------------------------------+
//|    3                                         |
//+------------------------------------------------------------------+
bool CProgram::CreateSimpleButton3(string button_text)
  {
//---   
   m_simple_button3.WindowPointer(m_window);
//--- 
   int x=m_window.X()+BUTTON3_GAP_X;
   int y=m_window.Y()+BUTTON3_GAP_Y;
//---    
   m_simple_button3.TwoState(true);
   m_simple_button3.ButtonXSize(237);
   m_simple_button3.TextColor(clrBlack);
   m_simple_button3.TextColorPressed(clrBlack);
   m_simple_button3.BackColor(clrGainsboro);
   m_simple_button3.BackColorHover(C'193,218,255');
   m_simple_button3.BackColorPressed(C'210,210,220');
   m_simple_button3.BorderColor(C'150,170,180');
   m_simple_button3.BorderColorOff(C'178,195,207');
//---  
   if(!m_simple_button3.CreateSimpleButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_simple_button3);
   return(true);
  }
//+------------------------------------------------------------------+
//|     1                                     |
//+------------------------------------------------------------------+
bool CProgram::CreateIconButton1(const string button_text)
  {
//---   
   m_icon_button1.WindowPointer(m_window);
//--- 
   int x=m_window.X()+ICONBUTTON1_GAP_X;
   int y=m_window.Y()+ICONBUTTON1_GAP_Y;
//---    
   m_icon_button1.TwoState(false);
   m_icon_button1.ButtonXSize(116);
   m_icon_button1.ButtonYSize(22);
   m_icon_button1.LabelColor(clrBlack);
   m_icon_button1.LabelColorPressed(clrBlack);
   m_icon_button1.BackColor(clrGainsboro);
   m_icon_button1.BackColorHover(C'193,218,255');
   m_icon_button1.BackColorPressed(C'210,210,220');
   m_icon_button1.BorderColor(C'150,170,180');
   m_icon_button1.BorderColorOff(C'178,195,207');
   m_icon_button1.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp");
   m_icon_button1.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp");
//---   
   if(!m_icon_button1.CreateIconButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---  
   m_icon_button1.ButtonState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_button1);
   return(true);
  }
//+------------------------------------------------------------------+
//|     2                                     |
//+------------------------------------------------------------------+
bool CProgram::CreateIconButton2(const string button_text)
  {
//---   
   m_icon_button2.WindowPointer(m_window);
//--- 
   int x=m_window.X()+ICONBUTTON2_GAP_X;
   int y=m_window.Y()+ICONBUTTON2_GAP_Y;
//---    
   m_icon_button2.TwoState(true);
   m_icon_button2.ButtonXSize(116);
   m_icon_button2.ButtonYSize(22);
   m_icon_button2.LabelColor(clrBlack);
   m_icon_button2.LabelColorPressed(clrBlack);
   m_icon_button2.BackColor(clrGainsboro);
   m_icon_button2.BackColorHover(C'193,218,255');
   m_icon_button2.BackColorPressed(C'210,210,220');
   m_icon_button2.BorderColor(C'150,170,180');
   m_icon_button2.BorderColorOff(C'178,195,207');
   m_icon_button2.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp");
   m_icon_button2.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp");
//---   
   if(!m_icon_button2.CreateIconButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_button2);
   return(true);
  }
//+------------------------------------------------------------------+
//|     3                                     |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart_colorless.bmp"
//---
bool CProgram::CreateIconButton3(const string button_text)
  {
//---   
   m_icon_button3.WindowPointer(m_window);
//--- 
   int x=m_window.X()+ICONBUTTON3_GAP_X;
   int y=m_window.Y()+ICONBUTTON3_GAP_Y;
//---    
   m_icon_button3.TwoState(true);
   m_icon_button3.ButtonXSize(75);
   m_icon_button3.ButtonYSize(87);
   m_icon_button3.LabelXGap(6);
   m_icon_button3.LabelYGap(69);
   m_icon_button3.LabelColor(clrBlack);
   m_icon_button3.LabelColorPressed(clrBlack);
   m_icon_button3.BackColor(clrGainsboro);
   m_icon_button3.BackColorHover(C'193,218,255');
   m_icon_button3.BackColorPressed(C'210,210,220');
   m_icon_button3.BorderColor(C'150,170,180');
   m_icon_button3.BorderColorOff(C'178,195,207');
   m_icon_button3.IconXGap(6);
   m_icon_button3.IconYGap(3);
   m_icon_button3.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart.bmp");
   m_icon_button3.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp64\\pie_chart_colorless.bmp");
//---   
   if(!m_icon_button3.CreateIconButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_button3);
   return(true);
  }
//+------------------------------------------------------------------+
//|     4                                     |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\safe.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\safe_colorless.bmp"
//---
bool CProgram::CreateIconButton4(const string button_text)
  {
//---   
   m_icon_button4.WindowPointer(m_window);
//--- 
   int x=m_window.X()+ICONBUTTON4_GAP_X;
   int y=m_window.Y()+ICONBUTTON4_GAP_Y;
//---    
   m_icon_button4.ButtonXSize(76);
   m_icon_button4.ButtonYSize(87);
   m_icon_button4.LabelXGap(6);
   m_icon_button4.LabelYGap(69);
   m_icon_button4.LabelColor(clrBlack);
   m_icon_button4.LabelColorPressed(clrBlack);
   m_icon_button4.BackColor(clrGainsboro);
   m_icon_button4.BackColorHover(C'193,218,255');
   m_icon_button4.BackColorPressed(C'210,210,220');
   m_icon_button4.BorderColor(C'150,170,180');
   m_icon_button4.BorderColorOff(C'178,195,207');
   m_icon_button4.IconXGap(6);
   m_icon_button4.IconYGap(3);
   m_icon_button4.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp64\\safe.bmp");
   m_icon_button4.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp64\\safe_colorless.bmp");
//---   
   if(!m_icon_button4.CreateIconButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---  
   m_icon_button4.ButtonState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_button4);
   return(true);
  }
//+------------------------------------------------------------------+
//|     5                                     |
//+------------------------------------------------------------------+
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\gold.bmp"
#resource "\\Images\\EasyAndFastGUI\\Icons\\bmp64\\gold_colorless.bmp"
//---
bool CProgram::CreateIconButton5(const string button_text)
  {
//---   
   m_icon_button5.WindowPointer(m_window);
//--- 
   int x=m_window.X()+ICONBUTTON5_GAP_X;
   int y=m_window.Y()+ICONBUTTON5_GAP_Y;
//---    
   m_icon_button5.ButtonXSize(76);
   m_icon_button5.ButtonYSize(87);
   m_icon_button5.LabelXGap(6);
   m_icon_button5.LabelYGap(69);
   m_icon_button5.LabelColor(clrBlack);
   m_icon_button5.LabelColorPressed(clrBlack);
   m_icon_button5.BackColor(clrGainsboro);
   m_icon_button5.BackColorHover(C'193,218,255');
   m_icon_button5.BackColorPressed(C'210,210,220');
   m_icon_button5.BorderColor(C'150,170,180');
   m_icon_button5.BorderColorOff(C'178,195,207');
   m_icon_button5.IconXGap(6);
   m_icon_button5.IconYGap(3);
   m_icon_button5.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp64\\gold.bmp");
   m_icon_button5.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp64\\gold_colorless.bmp");
//---   
   if(!m_icon_button5.CreateIconButton(m_chart_id,m_subwin,button_text,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_icon_button5);
   return(true);
  }
//+------------------------------------------------------------------+
//|    1                                       |
//+------------------------------------------------------------------+
bool CProgram::CreateSplitButton1(const string button_text)
  {
//---     
#define CONTEXTMENU_ITEMS5 3
//---   
   m_split_button1.WindowPointer(m_window);
//--- 
   int x=m_window.X()+SPLITBUTTON1_GAP_X;
   int y=m_window.Y()+SPLITBUTTON1_GAP_Y;
//---   
   string items_text[]=
     {
      "Item 1",
      "Item 2",
      "Item 3"
     };
//---     
   string items_bmp_on[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
//---      
   string items_bmp_off[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---    
   m_split_button1.ButtonXSize(116);
   m_split_button1.ButtonYSize(22);
   m_split_button1.DropButtonXSize(16);
   m_split_button1.LabelColor(clrBlack);
   m_split_button1.LabelColorPressed(clrBlack);
   m_split_button1.BackColor(clrGainsboro);
   m_split_button1.BackColorHover(C'193,218,255');
   m_split_button1.BackColorPressed(C'190,190,200');
   m_split_button1.BorderColor(C'150,170,180');
   m_split_button1.BorderColorOff(C'178,195,207');
   m_split_button1.BorderColorHover(C'150,170,180');
   m_split_button1.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\script.bmp");
   m_split_button1.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\script_colorless.bmp");
//---      
   CContextMenu *cm=m_split_button1.GetContextMenuPointer();
//---    
   cm.AreaBackColor(C'240,240,240');
   cm.AreaBorderColor(clrSilver);
   cm.ItemBackColor(C'240,240,240');
   cm.ItemBorderColor(C'240,240,240');
   cm.LabelColor(clrBlack);
   cm.LabelColorHover(clrWhite);
   cm.SeparateLineDarkColor(C'160,160,160');
   cm.SeparateLineLightColor(clrWhite);
//---     
   for(int i=0; i<CONTEXTMENU_ITEMS5; i++)
      m_split_button1.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i]);
//---      
   m_split_button1.AddSeparateLine(1);
//---   
   if(!m_split_button1.CreateSplitButton(m_chart_id,button_text,m_subwin,x,y))
      return(false);
//---      
   CWndContainer::AddToElementsArray(0,m_split_button1);
   return(true);
  }
//+------------------------------------------------------------------+
//|    2                                       |
//+------------------------------------------------------------------+
bool CProgram::CreateSplitButton2(const string button_text)
  {
#define CONTEXTMENU_ITEMS6 3
//---   
   m_split_button2.WindowPointer(m_window);
//--- 
   int x=m_window.X()+SPLITBUTTON2_GAP_X;
   int y=m_window.Y()+SPLITBUTTON2_GAP_Y;
//---
   string items_text[]=
     {
      "Item 1",
      "Item 2",
      "Item 3"
     };
   string items_bmp_on[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
   string items_bmp_off[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---    
   m_split_button2.ButtonXSize(116);
   m_split_button2.ButtonYSize(22);
   m_split_button2.DropButtonXSize(16);
   m_split_button2.LabelColor(clrBlack);
   m_split_button2.LabelColorPressed(clrBlack);
   m_split_button2.BackColor(clrGainsboro);
   m_split_button2.BackColorHover(C'193,218,255');
   m_split_button2.BackColorPressed(C'190,190,200');
   m_split_button2.BorderColor(C'150,170,180');
   m_split_button2.BorderColorOff(C'178,195,207');
   m_split_button2.BorderColorHover(C'150,170,180');
   m_split_button2.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp");
   m_split_button2.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp");
//---      
   CContextMenu *cm=m_split_button2.GetContextMenuPointer();
//---    
   cm.AreaBackColor(C'240,240,240');
   cm.AreaBorderColor(clrSilver);
   cm.ItemBackColor(C'240,240,240');
   cm.ItemBorderColor(C'240,240,240');
   cm.LabelColor(clrBlack);
   cm.LabelColorHover(clrWhite);
   cm.SeparateLineDarkColor(C'160,160,160');
   cm.SeparateLineLightColor(clrWhite);
//---
   for(int i=0; i<CONTEXTMENU_ITEMS6; i++)
      m_split_button2.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i]);
//---
   m_split_button2.AddSeparateLine(1);
//---   
   if(!m_split_button2.CreateSplitButton(m_chart_id,button_text,m_subwin,x,y))
      return(false);
//---  
   m_split_button2.ButtonState(false);
//---      
   CWndContainer::AddToElementsArray(0,m_split_button2);
   return(true);
  }
//+------------------------------------------------------------------+
//|    3                                       |
//+------------------------------------------------------------------+
bool CProgram::CreateSplitButton3(const string button_text)
  {
#define CONTEXTMENU_ITEMS7 3
//---   
   m_split_button3.WindowPointer(m_window);
//--- 
   int x=m_window.X()+SPLITBUTTON3_GAP_X;
   int y=m_window.Y()+SPLITBUTTON3_GAP_Y;
//---
   string items_text[]=
     {
      "Item 1",
      "Item 2",
      "Item 3"
     };
   string items_bmp_on[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
   string items_bmp_off[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---    
   m_split_button3.ButtonXSize(116);
   m_split_button3.ButtonYSize(22);
   m_split_button3.DropButtonXSize(16);
   m_split_button3.LabelColor(clrBlack);
   m_split_button3.LabelColorPressed(clrBlack);
   m_split_button3.BackColor(clrGainsboro);
   m_split_button3.BackColorHover(C'193,218,255');
   m_split_button3.BackColorPressed(C'190,190,200');
   m_split_button3.BorderColor(C'150,170,180');
   m_split_button3.BorderColorOff(C'178,195,207');
   m_split_button3.BorderColorHover(C'150,170,180');
   m_split_button3.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice.bmp");
   m_split_button3.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\invoice_colorless.bmp");
//---      
   CContextMenu *cm=m_split_button3.GetContextMenuPointer();
//---    
   cm.AreaBackColor(C'240,240,240');
   cm.AreaBorderColor(clrSilver);
   cm.ItemBackColor(C'240,240,240');
   cm.ItemBorderColor(C'240,240,240');
   cm.LabelColor(clrBlack);
   cm.LabelColorHover(clrWhite);
   cm.SeparateLineDarkColor(C'160,160,160');
   cm.SeparateLineLightColor(clrWhite);
//---
   for(int i=0; i<CONTEXTMENU_ITEMS7; i++)
      m_split_button3.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i]);
//---
   m_split_button3.AddSeparateLine(1);
//---   
   if(!m_split_button3.CreateSplitButton(m_chart_id,button_text,m_subwin,x,y))
      return(false);
//---  
   m_split_button3.ButtonState(true);
//---      
   CWndContainer::AddToElementsArray(0,m_split_button3);
   return(true);
  }
//+------------------------------------------------------------------+
//|    4                                       |
//+------------------------------------------------------------------+
bool CProgram::CreateSplitButton4(const string button_text)
  {
#define CONTEXTMENU_ITEMS8 3
//---   
   m_split_button4.WindowPointer(m_window);
//--- 
   int x=m_window.X()+SPLITBUTTON4_GAP_X;
   int y=m_window.Y()+SPLITBUTTON4_GAP_Y;
//---
   string items_text[]=
     {
      "Item 1",
      "Item 2",
      "Item 3"
     };
   string items_bmp_on[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart.bmp"
     };
   string items_bmp_off[]=
     {
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\coins_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\line_chart_colorless.bmp",
      "Images\\EasyAndFastGUI\\Icons\\bmp16\\bar_chart_colorless.bmp"
     };
//---    
   m_split_button4.ButtonXSize(116);
   m_split_button4.ButtonYSize(22);
   m_split_button4.DropButtonXSize(16);
   m_split_button4.LabelColor(clrBlack);
   m_split_button4.LabelColorPressed(clrBlack);
   m_split_button4.BackColor(clrGainsboro);
   m_split_button4.BackColorHover(C'193,218,255');
   m_split_button4.BackColorPressed(C'190,190,200');
   m_split_button4.BorderColor(C'150,170,180');
   m_split_button4.BorderColorOff(C'178,195,207');
   m_split_button4.BorderColorHover(C'150,170,180');
   m_split_button4.IconFileOn("Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator.bmp");
   m_split_button4.IconFileOff("Images\\EasyAndFastGUI\\Icons\\bmp16\\calculator_colorless.bmp");
//---      
   CContextMenu *cm=m_split_button4.GetContextMenuPointer();
//---    
   cm.AreaBackColor(C'240,240,240');
   cm.AreaBorderColor(clrSilver);
   cm.ItemBackColor(C'240,240,240');
   cm.ItemBorderColor(C'240,240,240');
   cm.LabelColor(clrBlack);
   cm.LabelColorHover(clrWhite);
   cm.SeparateLineDarkColor(C'160,160,160');
   cm.SeparateLineLightColor(clrWhite);
//---
   for(int i=0; i<CONTEXTMENU_ITEMS8; i++)
      m_split_button4.AddItem(items_text[i],items_bmp_on[i],items_bmp_off[i]);
//---
   m_split_button4.AddSeparateLine(1);
//---   
   if(!m_split_button4.CreateSplitButton(m_chart_id,button_text,m_subwin,x,y))
      return(false);
//---  
   m_split_button4.ButtonState(true);
//---      
   CWndContainer::AddToElementsArray(0,m_split_button4);
   return(true);
  }
//+------------------------------------------------------------------+
