﻿//+------------------------------------------------------------------+
//|                                       SyncTest-MultyCurrency.mq5 |
//|                                          Copyright 2026, Dima S. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2026, Dima S."
#property link      "https://www.mql5.com"
#property version   "1.00"

// =====================================================================
//  Общие настройки:
// =====================================================================
#property indicator_separate_window
// ---------------------------------------------------------------------
#property indicator_buffers 5
#property indicator_plots   1
// ---------------------------------------------------------------------
#property indicator_label1  "USD"
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1  clrNONE, clrGreen, clrRed, clrGoldenrod
#property indicator_width1  1
#property indicator_style1  STYLE_SOLID
// ---------------------------------------------------------------------
#property strict
// ---------------------------------------------------------------------
#include  "MultyCurrencyManager.mqh"
// ---------------------------------------------------------------------

// ---------------------------------------------------------------------
MultiCurrencyManager* time_sync_manager_Ptr;
// ---------------------------------------------------------------------
string    symbol_name_Array[];
double    symbol_volume_Array[];
// ---------------------------------------------------------------------
int       instrumentsCount = 0;
datetime  StartDateTime;

// =====================================================================
//  Буферы индикатора
// =====================================================================
double  USDIndexOpenBuffer[];                                         // индекс USD отображаем в виде свеч
double  USDIndexHighBuffer[];
double  USDIndexLowBuffer[];
double  USDIndexCloseBuffer[];
double  USDIndexColorBuffer[];
// ---------------------------------------------------------------------

// =====================================================================
//  Входные параметры:
// =====================================================================
input string  BaseActiveStructure = "AUDUSD,2;XAGUSD,-1;XAUUSD,-1";    // Porfolio Structure - "Instrument Name, Min Lot Multiplier;", Calc Lots = Multiplier * MinLot
input int     MaxBars = 5000;                                         // Max Bars for Calculations
// ---------------------------------------------------------------------

// =====================================================================
//  Custom indicator initialization function:
// =====================================================================
int OnInit()
{
	SetIndexBuffer(0, USDIndexOpenBuffer, INDICATOR_DATA);
	SetIndexBuffer(1, USDIndexHighBuffer, INDICATOR_DATA);
	SetIndexBuffer(2, USDIndexLowBuffer, INDICATOR_DATA);
	SetIndexBuffer(3, USDIndexCloseBuffer, INDICATOR_DATA);
	SetIndexBuffer(4, USDIndexColorBuffer, INDICATOR_COLOR_INDEX);

	PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, 0);

	PlotIndexSetString(0, PLOT_LABEL, "Basket");

  IndicatorSetString(INDICATOR_SHORTNAME, "Basket: " + BaseActiveStructure);
  IndicatorSetInteger(INDICATOR_DIGITS, 6);

  //  Парсинг инструментов:
  if(ParseInstruments(BaseActiveStructure) != true)
  {
    Print("Failed to parse instruments: ", BaseActiveStructure);
    return(INIT_PARAMETERS_INCORRECT);
  }

  time_sync_manager_Ptr = new MultiCurrencyManager(28, MaxBars);
  time_sync_manager_Ptr.SetSymbolVolumes(symbol_volume_Array);

  EventSetMillisecondTimer(100);
  
  Print("Indicator initialized with ", instrumentsCount, " instruments");

  //  Запустим полное обновление графика - при этом 'prev_calculated' становится равным 0:
  //ChartSetSymbolPeriod(0, Symbol(), Period());

  return(INIT_SUCCEEDED);
}
// =====================================================================
//  Обработчик события расчета индикатора:
// =====================================================================
int       first_bar;
int       curr_bar;
int       barIndex;
// ---------------------------------------------------------------------
long  zero_time_count  = 0;
long  zero_open_count  = 0;
long  zero_high_count  = 0;
long  zero_low_count  = 0;
long  zero_close_count  = 0;
long  zero_volume_count  = 0;
long  zero_bars_count  = 0;
long  restarts_count = 0;
datetime  restart_time = TimeCurrent();
long  timer_count = 0;
bool  data_loaded_FLAG = false;
// ---------------------------------------------------------------------
datetime  time;
double    open;
double    high;
double    low;
double    close;
long      volume;
int       bars;
// ---------------------------------------------------------------------
MqlDateTime BarCalcTime;
MqlRates    curr_rates[];
int         headge_copied_Array[];
int         added;
int         headge_added;
int         required;
// ---------------------------------------------------------------------
int OnCalculate(const int rates_total, const int prev_calculated, const datetime& Time[], const double& Open[], const double& High[], const double& Low[], const double& Close[], const long& TickVolume[], const long& Volume[], const int& Spread[])
{
  if(rates_total <= 0)
  {
    ArrayFill(headge_copied_Array, 0, (int)headge_copied_Array.Size(), 0);
    return(0);
  }

  //  Ждем загрузки данных по таймеру:

  // Первый расчет
  if(prev_calculated == 0)
  {
		restarts_count++;
		restart_time = TimeCurrent();

Print("### ", __FUNCTION__, ": First calculation started...");
    ArrayInitialize(USDIndexOpenBuffer, 0);
    ArrayInitialize(USDIndexHighBuffer, 0);
    ArrayInitialize(USDIndexLowBuffer, 0);
    ArrayInitialize(USDIndexCloseBuffer, 0);

    //  Получим бары для символа синхронизации (символ графика): 
    headge_copied_Array[0] = CopyRates(symbol_name_Array[0], Period(), 0, MaxBars, curr_rates);
    if(headge_copied_Array[0] > 0)
    {
      //  Загружаем начальные данные в символ синхронизации:
      required = MathMin(headge_copied_Array[0], MaxBars);
      added = time_sync_manager_Ptr.SyncSymbolAddFullData(symbol_name_Array[0], Period(), curr_rates, 0, required, false);
Print("# ", headge_copied_Array[0], " - copied: ", headge_copied_Array[0], "  required: ", required, "  added: ", added); 

      //  Если задан хеджевый символ:
      if(symbol_name_Array.Size() > 1)
      {
        //  Загрузка данных:
        for(int i = 1; i < (int)symbol_name_Array.Size(); i++)
        {
          headge_copied_Array[i] = CopyRates(symbol_name_Array[i], Period(), 0, MaxBars, curr_rates);;
          if(headge_copied_Array[i] > 0)
          {
            //  Загружаем начальные данные в символ синхронизации:
            required = MathMin(headge_copied_Array[i], MaxBars);
            headge_added = time_sync_manager_Ptr.SymbolAddFullData(symbol_name_Array[i], Period(), curr_rates, 0, required, false);
Print("# ", symbol_name_Array[i], " - copied: ", headge_copied_Array[i], "  required: ", required, "  added: ", headge_added); 
          }
        }

        //  Проверка загруженности данных:
        if(CheckLoading(headge_copied_Array) == true)
        {
          //  Синхронизируем массивы баров:
Print("### ", __FUNCTION__, ": First synchronisation started...");
          time_sync_manager_Ptr.SyncAllData(ENUM_SYNC_BARS_INTERPOLATED);
Print("### ", __FUNCTION__, ": First synchronisation ended");

          //  Рассчитаем портфель:
Print("### ", __FUNCTION__, ": First calculation basket started...");
          time_sync_manager_Ptr.CalculateBasketFull();
Print("### ", __FUNCTION__, ": First calculation basket ended");

          //  Получим заданное число баров (синхронизированных) - время в массиве 'Time[]' идет слева направо:
          time_sync_manager_Ptr.GetFullBasketOpen(USDIndexOpenBuffer, ArraySize(USDIndexOpenBuffer) - headge_added);
          time_sync_manager_Ptr.GetFullBasketHigh(USDIndexHighBuffer, ArraySize(USDIndexHighBuffer) - headge_added);
          time_sync_manager_Ptr.GetFullBasketLow(USDIndexLowBuffer, ArraySize(USDIndexLowBuffer) - headge_added);
          int   headge_copied = time_sync_manager_Ptr.GetFullBasketClose(USDIndexCloseBuffer, ArraySize(USDIndexCloseBuffer) - headge_added);

          //  Цвета баров:
          for(int i = 0; i < headge_copied; i++)
          {
            //  Время идет слева направо:
            barIndex = rates_total - headge_added + i;

          	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 1;
          	}
          	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 2;
          	}
          	else
          	{
          		USDIndexColorBuffer[barIndex] = 3;
          	}
          }
        }
      }
    }
  }
  //  Пришел новый тик по символу графика - обработаем поледние бар(-ы):
  else
  {
    //  Получим последние бары для символа синхронизации (символ графика): 
    if(GetLastBar(symbol_name_Array[0], Period(), 0, rates_total - prev_calculated + 1, last_rates) == true)
    {
      Comment(symbol_name_Array[0], ": ", EnumToString(Period()), ", Restarted: ", TimeToString(restart_time, TIME_DATE | TIME_SECONDS), " (", IntegerToString(restarts_count), ")\n", 
             "Time: "  ,TimeToString(last_rates[rates_total - prev_calculated].time,TIME_DATE|TIME_SECONDS), " (", IntegerToString(zero_time_count), ")\n",
             "Open: "  ,DoubleToString(last_rates[rates_total - prev_calculated].open,Digits()), " (", IntegerToString(zero_open_count), ")\n",
             "High: "  ,DoubleToString(last_rates[rates_total - prev_calculated].high,Digits()), " (", IntegerToString(zero_high_count), ")\n",
             "Low: "   ,DoubleToString(last_rates[rates_total - prev_calculated].low,Digits()), " (", IntegerToString(zero_low_count), ")\n",
             "Close: " ,DoubleToString(last_rates[rates_total - prev_calculated].close,Digits()), " (", IntegerToString(zero_close_count), ")\n",
             "TickVolume: ",IntegerToString(last_rates[rates_total - prev_calculated].tick_volume), " (", IntegerToString(zero_volume_count), ")\n",
             "Volume: ",IntegerToString(last_rates[rates_total - prev_calculated].real_volume), " (", IntegerToString(zero_volume_count), ")\n",
             "Chart Bars: "  ,IntegerToString(bars), " (", IntegerToString(zero_bars_count), ")\n"
             ); 

      //  Обработка текущих баров:
      headge_copied_Array[0] = time_sync_manager_Ptr.SyncSymbolUpdateLastData(last_rates, 0, rates_total - prev_calculated + 1);
      if(headge_copied_Array[0] > 0)
      {
        //  Если задан хеджевый символ:
        if(symbol_name_Array.Size() > 1)
        {
          //  Загрузка данных:
          for(int i = 1; i < (int)symbol_name_Array.Size(); i++)
          {
            //  Получим последние бары для хеджевого символа:
            if(GetLastBar(symbol_name_Array[i], Period(), 0, rates_total - prev_calculated + 1, last_rates) == true)
            {
              time_sync_manager_Ptr.SymbolUpdateLastData(symbol_name_Array[i], last_rates, 0, (int)last_rates.Size());
            }
          }

          // Синхронизируем последние бары:
          time_sync_manager_Ptr.SyncLastBars((int)last_rates.Size(), ENUM_SYNC_BARS_INTERPOLATED);

          //  Рассчитаем портфель:
          time_sync_manager_Ptr.CalculateBasketLast((int)last_rates.Size());

          time_sync_manager_Ptr.GetLastBasketOpen((int)last_rates.Size(), USDIndexOpenBuffer, ArraySize(USDIndexOpenBuffer) - (int)last_rates.Size());
          time_sync_manager_Ptr.GetLastBasketHigh((int)last_rates.Size(), USDIndexHighBuffer, ArraySize(USDIndexHighBuffer) - (int)last_rates.Size());
          time_sync_manager_Ptr.GetLastBasketLow((int)last_rates.Size(), USDIndexLowBuffer, ArraySize(USDIndexLowBuffer) - (int)last_rates.Size());
          time_sync_manager_Ptr.GetLastBasketClose((int)last_rates.Size(), USDIndexCloseBuffer, ArraySize(USDIndexCloseBuffer) - (int)last_rates.Size());

          for(int i = 0; i < (int)last_rates.Size(); i++)
          {
            //  Время идет слева направо:
            barIndex = rates_total - (int)last_rates.Size() + i;

          	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 1;
          	}
          	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 2;
          	}
          	else
          	{
          		USDIndexColorBuffer[barIndex] = 3;
          	}
          }
        }
      }
    }
  }

  return(rates_total);
}
// =====================================================================
//  Получение последних баров:
// =====================================================================
MqlRates  last_rates[];
// ---------------------------------------------------------------------
bool  GetLastBar(const string _symbol_name, const ENUM_TIMEFRAMES _tf, const int _symbol_shift, const int _count, MqlRates& _rates[])
{
  ArrayResize(_rates, _count);
  for(int i = 0; i < _count; i++)
  {
    _rates[i].time   = iTime(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].open   = iOpen(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].high   = iHigh(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].low    = iLow(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].close  = iClose(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].tick_volume = iTickVolume(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].real_volume = iVolume(_symbol_name, _tf, _symbol_shift + i); 
    bars   = iBars(_symbol_name, _tf); 

    _rates[i].time == 0 ? zero_time_count++ : zero_time_count;
    _rates[i].open == 0 ? zero_open_count++ : zero_open_count;
    _rates[i].high == 0 ? zero_high_count++ : zero_high_count;
    _rates[i].low == 0 ? zero_low_count++ : zero_low_count;
    _rates[i].close == 0 ? zero_close_count++ : zero_close_count;
    _rates[i].tick_volume == 0 ? zero_volume_count++ : zero_volume_count;
    bars == 0 ? zero_bars_count++ : zero_bars_count;
    if(_rates[i].time == 0 || _rates[i].open == 0 || _rates[i].high == 0 || _rates[i].low == 0 || _rates[i].close == 0 || _rates[i].tick_volume == 0 || bars == 0)
    {
      return(false);
    }
  }

  return(true);
}
// =====================================================================
//  Получение заданного числа последних баров:
// =====================================================================
bool  GetLastBars(const string _symbol_name, const ENUM_TIMEFRAMES _tf, const int _symbol_shift, const int _count)
{
  if(CopyRates(_symbol_name, _tf, _symbol_shift, _count, curr_rates) > 0)
  {
  }
  return(true);
}
// =====================================================================
//  Timer function:
// =====================================================================
void OnTimer()
{
   
}
// =====================================================================
//  Deinitialization function:
// =====================================================================
void OnDeinit(const int reason)
{
  EventKillTimer();
  DESTROY_OBJECT(time_sync_manager_Ptr);
  
  Print("Indicator removed. Reason: ", reason);
  Comment("");
}
// =====================================================================
//  Парсинг строки с инструментами:
// =====================================================================
bool  ParseInstruments(string inputStr)
{
  // Создаем копию строки для обработки
  string str = inputStr;
  StringReplace(str, " ", "");

  string  pairs[];
  int count = StringSplit(str, ';', pairs);

  if(count <= 0)
  {
    Print("No instruments found in: ", inputStr);
    return(false);
  }

  ArrayResize(symbol_name_Array, count);
  ArrayResize(symbol_volume_Array, count);
  ArrayResize(headge_copied_Array, count);
  instrumentsCount = 0;

  for(int i = 0; i < count; i++)
  {
    if(StringLen(pairs[i]) == 0) continue;
  
    string data[];
    if(StringSplit(pairs[i], ',', data) >= 2)
    {
      symbol_name_Array[i] = data[0];
      symbol_volume_Array[i] = (double)StringToInteger(data[1]) * SymbolInfoDouble(symbol_name_Array[i], SYMBOL_VOLUME_MIN);
      instrumentsCount++;
    }
  }

  if(instrumentsCount == 0)
  {
    Print("No valid instruments found");
    return(false);
  }

  // Выводим информацию о парсинге
  Print("Parsed instruments:");
  for(int i = 0; i < instrumentsCount; i++)
  {
    Print(" # ", i + 1, ". ", symbol_name_Array[i], " * ", symbol_volume_Array[i]);
  }

  return(true);
}
// =====================================================================
//  Проверка загруженности данных:
// =====================================================================
bool  CheckLoading(const int& _headge_copied_Array[])
{
  if(_headge_copied_Array.Size() <= 0)
  {
    return(false);
  }

  for(int i = 0; i < (int)_headge_copied_Array.Size(); i++)
  {
    if(_headge_copied_Array[i] <= 0)
    {
      return(false);
    }
  }
  return(true);
}
// ---------------------------------------------------------------------
