﻿//+------------------------------------------------------------------+
//|                                                     SyncTest.mq5 |
//|                                          Copyright 2026, Dima S. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2026, Dima S."
#property link      "https://www.mql5.com"
#property version   "1.00"

// =====================================================================
//  Общие настройки:
// =====================================================================
#property indicator_separate_window
// ---------------------------------------------------------------------
#property indicator_buffers 5
#property indicator_plots   1
// ---------------------------------------------------------------------
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1  clrNONE, clrGreen, clrRed, clrGoldenrod
#property indicator_width1  1
#property indicator_style1  STYLE_SOLID
// ---------------------------------------------------------------------

#include  <Generic\HashMap.mqh>
#include  "TimeSyncManager.mqh"

CTimeSyncManager* time_sync_manager_Ptr;

// =====================================================================
//  Буферы индикатора
// =====================================================================
double  USDIndexOpenBuffer[];                                         // индекс USD отображаем в виде свеч
double  USDIndexHighBuffer[];
double  USDIndexLowBuffer[];
double  USDIndexCloseBuffer[];
double  USDIndexColorBuffer[];
// ---------------------------------------------------------------------

// =====================================================================
//  Входные параметры:
// =====================================================================
input string  HeadgeSymbol = "XAGUSD";                                // Headge Symbol Name
input int     MaxBars = 2000;                                         // Max Bars for Calculations
// ---------------------------------------------------------------------
input ENUM_SYNC_BARS_TYPE SyncBarsType = ENUM_SYNC_BARS_INTERPOLATED; // Sync Bars Type
// ---------------------------------------------------------------------

// =====================================================================
//  Custom indicator initialization function:
// =====================================================================
int OnInit()
{
	SetIndexBuffer(0, USDIndexOpenBuffer, INDICATOR_DATA);
	SetIndexBuffer(1, USDIndexHighBuffer, INDICATOR_DATA);
	SetIndexBuffer(2, USDIndexLowBuffer, INDICATOR_DATA);
	SetIndexBuffer(3, USDIndexCloseBuffer, INDICATOR_DATA);
	SetIndexBuffer(4, USDIndexColorBuffer, INDICATOR_COLOR_INDEX);

	PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, 0);
	PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, 0);

	PlotIndexSetString(0, PLOT_LABEL, (HeadgeSymbol == "" ? Symbol() : HeadgeSymbol));

  IndicatorSetString(INDICATOR_SHORTNAME, (HeadgeSymbol == "" ? Symbol() : HeadgeSymbol));
  IndicatorSetInteger(INDICATOR_DIGITS, (HeadgeSymbol == "" ? Digits() : (int)SymbolInfoInteger(HeadgeSymbol, SYMBOL_DIGITS)));

  time_sync_manager_Ptr = new CTimeSyncManager(28, 2 * MaxBars);

  EventSetMillisecondTimer(100);

  //  Запустим обновление графика - при этом 'prev_calculated' становится равным 0:
  //ChartSetSymbolPeriod(0, Symbol(), Period());

  return(INIT_SUCCEEDED);
}
// =====================================================================
//  Обработчик события расчета индикатора:
// =====================================================================
int       first_bar;
int       curr_bar;
int       barIndex;
// ---------------------------------------------------------------------
long  zero_time_count  = 0;
long  zero_open_count  = 0;
long  zero_high_count  = 0;
long  zero_low_count  = 0;
long  zero_close_count  = 0;
long  zero_volume_count  = 0;
long  zero_bars_count  = 0;
long  restarts_count = 0;
datetime  restart_time = TimeCurrent();
long  timer_count = 0;
bool  data_loaded_FLAG = false;
// ---------------------------------------------------------------------
datetime  time;
double    open;
double    high;
double    low;
double    close;
long      volume;
int       bars;
// ---------------------------------------------------------------------
MqlDateTime BarCalcTime;
MqlRates    curr_rates[];
int         copied = 0;
int         headge_copied = 0;
int         added;
int         headge_added;
int         required;
// ---------------------------------------------------------------------
int
OnCalculate(const int rates_total, const int prev_calculated, const datetime& Time[], const double& Open[], const double& High[], const double& Low[], const double& Close[], const long& TickVolume[], const long& Volume[], const int& Spread[])
{
  if(rates_total <= 0)
  {
    copied = 0;
    headge_copied = 0;
    return(0);
  }

  //  Ждем загрузки данных по таймеру:

  // Первый расчет
  if(prev_calculated == 0)
  {
		restarts_count++;
		restart_time = TimeCurrent();

Print("### ", __FUNCTION__, ": First calculation started...");
    ArrayInitialize(USDIndexOpenBuffer, 0);
    ArrayInitialize(USDIndexHighBuffer, 0);
    ArrayInitialize(USDIndexLowBuffer, 0);
    ArrayInitialize(USDIndexCloseBuffer, 0);

    //  Получим бары для символа синхронизации (символ графика): 
    copied = CopyRates(Symbol(), Period(), 0, MaxBars/*iBars(Symbol(), PERIOD_CURRENT)*/, curr_rates);
    if(copied > 0)
    {
      //  Загружаем начальные данные в символ синхронизации:
      required = MathMin(copied, MaxBars);
      added = time_sync_manager_Ptr.SyncSymbolAddFullData(Symbol(), Period(), curr_rates, 0/*MathMax(0, rates_total - required)*/, required, false);
Print("# ", Symbol(), " - copied: ", copied, "  required: ", required, "  added: ", added); 

      //  Если задан хеджевый символ:
      if(HeadgeSymbol != "")
      {
        headge_copied = CopyRates(HeadgeSymbol, Period(), 0, MaxBars/*iBars(HeadgeSymbol, PERIOD_CURRENT)*/, curr_rates);;
//Print("# ", HeadgeSymbol, " - copied: ", headge_copied, "  required: ", required, "  added: ", headge_added); 
        if(headge_copied > 0)
        {
          //  Загружаем начальные данные в символ синхронизации:
          required = MathMin(headge_copied, MaxBars);
          headge_added = time_sync_manager_Ptr.SymbolAddFullData(HeadgeSymbol, Period(), curr_rates, 0/*MathMax(0, headge_copied - required)*/, required, false);
Print("# ", HeadgeSymbol, " - copied: ", headge_copied, "  required: ", required, "  added: ", headge_added); 

          // Синхронизируем массивы баров:
Print("### ", __FUNCTION__, ": First synchronisation started...");
          time_sync_manager_Ptr.SyncAllData(SyncBarsType);
Print("### ", __FUNCTION__, ": First synchronisation started...");

          //  Получим заданное число баров (синхронизированных) - время в массиве 'Time[]' идет слева направо:
          time_sync_manager_Ptr.GetFullOpen(HeadgeSymbol, USDIndexOpenBuffer, ArraySize(USDIndexOpenBuffer) - headge_added);
          time_sync_manager_Ptr.GetFullHigh(HeadgeSymbol, USDIndexHighBuffer, ArraySize(USDIndexHighBuffer) - headge_added);
          time_sync_manager_Ptr.GetFullLow(HeadgeSymbol, USDIndexLowBuffer, ArraySize(USDIndexLowBuffer) - headge_added);
          time_sync_manager_Ptr.GetFullClose(HeadgeSymbol, USDIndexCloseBuffer, ArraySize(USDIndexCloseBuffer) - headge_added);
Print("### ", __FUNCTION__, ": First calculation ended");

          //  Цвета баров:
          for(int i = 0; i < headge_copied; i++)
          {
            //  Время идет слева направо:
            barIndex = rates_total - headge_added + i;

          	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 1;
          	}
          	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 2;
          	}
          	else
          	{
          		USDIndexColorBuffer[barIndex] = 3;
          	}
          }
        }
      }
      else
      {
        //  Получим заданное число баров - время в массиве 'Time[]' идет слева направо:
        time_sync_manager_Ptr.GetFullOpen(Symbol(), USDIndexOpenBuffer, rates_total - added);
        time_sync_manager_Ptr.GetFullHigh(Symbol(), USDIndexHighBuffer, rates_total - added);
        time_sync_manager_Ptr.GetFullLow(Symbol(), USDIndexLowBuffer, rates_total - added);
        time_sync_manager_Ptr.GetFullClose(Symbol(), USDIndexCloseBuffer, rates_total - added);

        //  Цвета баров:
        for(int i = 0; i < copied; i++)
        {
          //  Время идет слева направо:
          barIndex = rates_total - copied + i;

        	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
        	{
        		USDIndexColorBuffer[barIndex] = 1;
        	}
        	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
        	{
        		USDIndexColorBuffer[barIndex] = 2;
        	}
        	else
        	{
        		USDIndexColorBuffer[barIndex] = 3;
        	}
        }
      }
    }
  }
  //  Пришел новый тик по символу графика - обработаем поледние бар(-ы):
  else
  {
    //  Получим последние бары для символа синхронизации (символ графика): 
    if(GetLastBar(Symbol(), Period(), 0, rates_total - prev_calculated + 1, last_rates) == true)
    {
      Comment(Symbol(), ": ", EnumToString(Period()), ", Restarted: ", TimeToString(restart_time, TIME_DATE | TIME_SECONDS), " (", IntegerToString(restarts_count), ")\n", 
             "Time: "  ,TimeToString(last_rates[rates_total - prev_calculated].time,TIME_DATE|TIME_SECONDS), " (", IntegerToString(zero_time_count), ")\n",
             "Open: "  ,DoubleToString(last_rates[rates_total - prev_calculated].open,Digits()), " (", IntegerToString(zero_open_count), ")\n",
             "High: "  ,DoubleToString(last_rates[rates_total - prev_calculated].high,Digits()), " (", IntegerToString(zero_high_count), ")\n",
             "Low: "   ,DoubleToString(last_rates[rates_total - prev_calculated].low,Digits()), " (", IntegerToString(zero_low_count), ")\n",
             "Close: " ,DoubleToString(last_rates[rates_total - prev_calculated].close,Digits()), " (", IntegerToString(zero_close_count), ")\n",
             "TickVolume: ",IntegerToString(last_rates[rates_total - prev_calculated].tick_volume), " (", IntegerToString(zero_volume_count), ")\n",
             "Volume: ",IntegerToString(last_rates[rates_total - prev_calculated].real_volume), " (", IntegerToString(zero_volume_count), ")\n",
             "Chart Bars: "  ,IntegerToString(bars), " (", IntegerToString(zero_bars_count), ")\n"
             ); 

      //  Обработка текущих баров:
      copied = time_sync_manager_Ptr.SyncSymbolUpdateLastData(last_rates, 0, rates_total - prev_calculated + 1);
      if(copied > 0)
      {
        //  Если задан хеджевый символ:
        if(HeadgeSymbol != "")
        {
          //  Получим последние бары для хеджевого символа:
          if(GetLastBar(HeadgeSymbol, Period(), 0, rates_total - prev_calculated + 1, last_rates) == true)
          {
            time_sync_manager_Ptr.SymbolUpdateLastData(HeadgeSymbol, last_rates, 0, (int)last_rates.Size());

            // Синхронизируем последние бары:
            time_sync_manager_Ptr.SyncLastBars(rates_total - prev_calculated + 1, SyncBarsType);

            time_sync_manager_Ptr.GetLastOpen(HeadgeSymbol, (int)last_rates.Size(), USDIndexOpenBuffer, ArraySize(USDIndexOpenBuffer) - (int)last_rates.Size());
            time_sync_manager_Ptr.GetLastHigh(HeadgeSymbol, (int)last_rates.Size(), USDIndexHighBuffer, ArraySize(USDIndexHighBuffer) - (int)last_rates.Size());
            time_sync_manager_Ptr.GetLastLow(HeadgeSymbol, (int)last_rates.Size(), USDIndexLowBuffer, ArraySize(USDIndexLowBuffer) - (int)last_rates.Size());
            time_sync_manager_Ptr.GetLastClose(HeadgeSymbol, (int)last_rates.Size(), USDIndexCloseBuffer, ArraySize(USDIndexCloseBuffer) - (int)last_rates.Size());

            for(int i = 0; i < copied; i++)
            {
              //  Время идет слева направо:
              barIndex = rates_total - (int)last_rates.Size() + i;

            	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
            	{
            		USDIndexColorBuffer[barIndex] = 1;
            	}
            	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
            	{
            		USDIndexColorBuffer[barIndex] = 2;
            	}
            	else
            	{
            		USDIndexColorBuffer[barIndex] = 3;
            	}
            }
          }
        }
        else
        {
          //  Получим заданное число баров - время в массиве 'Time[]' идет слева направо:
          time_sync_manager_Ptr.GetLastOpen(Symbol(), rates_total - prev_calculated + 1, USDIndexOpenBuffer, rates_total - copied);
          time_sync_manager_Ptr.GetLastHigh(Symbol(), rates_total - prev_calculated + 1, USDIndexHighBuffer, rates_total - copied);
          time_sync_manager_Ptr.GetLastLow(Symbol(), rates_total - prev_calculated + 1, USDIndexLowBuffer, rates_total - copied);
          time_sync_manager_Ptr.GetLastClose(Symbol(), rates_total - prev_calculated + 1, USDIndexCloseBuffer, rates_total - copied);
  
          for(int i = 0; i < copied; i++)
          {
            //  Время идет слева направо:
            barIndex = rates_total - copied + i;
  
          	if(USDIndexCloseBuffer[barIndex] > USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 1;
          	}
          	else if(USDIndexCloseBuffer[barIndex] < USDIndexOpenBuffer[barIndex])
          	{
          		USDIndexColorBuffer[barIndex] = 2;
          	}
          	else
          	{
          		USDIndexColorBuffer[barIndex] = 3;
          	}
          }
        }
      }
    }
  }

  return(rates_total);
}
// =====================================================================
//  Получение последних баров:
// =====================================================================
MqlRates  last_rates[];
// ---------------------------------------------------------------------
bool  GetLastBar(const string _symbol_name, const ENUM_TIMEFRAMES _tf, const int _symbol_shift, const int _count, MqlRates& _rates[])
{
  ArrayResize(_rates, _count);
  for(int i = 0; i < _count; i++)
  {
    _rates[i].time   = iTime(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].open   = iOpen(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].high   = iHigh(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].low    = iLow(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].close  = iClose(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].tick_volume = iTickVolume(_symbol_name, _tf, _symbol_shift + i);
    _rates[i].real_volume = iVolume(_symbol_name, _tf, _symbol_shift + i); 
    bars   = iBars(_symbol_name, _tf); 

    _rates[i].time == 0 ? zero_time_count++ : zero_time_count;
    _rates[i].open == 0 ? zero_open_count++ : zero_open_count;
    _rates[i].high == 0 ? zero_high_count++ : zero_high_count;
    _rates[i].low == 0 ? zero_low_count++ : zero_low_count;
    _rates[i].close == 0 ? zero_close_count++ : zero_close_count;
    _rates[i].tick_volume == 0 ? zero_volume_count++ : zero_volume_count;
    bars == 0 ? zero_bars_count++ : zero_bars_count;
    if(_rates[i].time == 0 || _rates[i].open == 0 || _rates[i].high == 0 || _rates[i].low == 0 || _rates[i].close == 0 || _rates[i].tick_volume == 0 || bars == 0)
    {
      return(false);
    }
  }

  return(true);
}
// =====================================================================
//  Получение заданного числа последних баров:
// =====================================================================
bool  GetLastBars(const string _symbol_name, const ENUM_TIMEFRAMES _tf, const int _symbol_shift, const int _count)
{
  if(CopyRates(_symbol_name, _tf, _symbol_shift, _count, curr_rates) > 0)
  {
  }
  return(true);
}
// =====================================================================
//  Timer function:
// =====================================================================
void OnTimer()
{
   
}
// =====================================================================
//  Deinitialization function:
// =====================================================================
void OnDeinit(const int reason)
{
  EventKillTimer();
  DESTROY_OBJECT(time_sync_manager_Ptr);
  
  Print("Indicator removed. Reason: ", reason);
  Comment("");
}
