﻿//+------------------------------------------------------------------+
//|                                         MultyCurrencyManager.mqh |
//|                                          Copyright 2026, Dima S. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2026, Dima S."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------+

#include  "TimeSyncManager.mqh"

// =====================================================================
//  Расчет стоимости мультивалютного портфеля:
// =====================================================================
class MultiCurrencyManager : public CTimeSyncManager
{
private:
  double  SymbolVolumefArray[];

private:
  double  BasketOpenBuffer[];
  double  BasketHighBuffer[];
  double  BasketLowBuffer[];
  double  BasketCloseBuffer[];

public:
  MultiCurrencyManager(const int _symbols_capacity, const int _data_capacity)
  :
  CTimeSyncManager(_symbols_capacity, _data_capacity)
  {
  }
public:  
  // ===================================================================== 
  //  Добавить параметры символов портфеля:
  // =====================================================================
  void  SetSymbolVolumes(const double& _vol_arr[])
  {
    ArrayResize(SymbolVolumefArray, (int)_vol_arr.Size());
    ArrayCopy(SymbolVolumefArray, _vol_arr);
  }
  // =====================================================================
  //  Расчет корзины для последних данных массива:
  // =====================================================================
  void  CalculateBasketLast(const int _count)
  {
    double    basketOpen = 0;
    double    basketHigh = 0;
    double    basketLow = 0;
    double    basketClose = 0;

    double    PointCost;
    double    curr_value;
    datetime  sync_symbol_time;

    datetime  sync_symbol_key[];
    int       sync_symbol_key_size = this.sync_symbol_data.time.Count();
    ArrayResize(sync_symbol_key, sync_symbol_key_size);
    this.sync_symbol_data.GetFullTime(sync_symbol_key, 0);

    ArrayResize(BasketOpenBuffer, sync_symbol_key_size);
    ArrayResize(BasketHighBuffer, sync_symbol_key_size);
    ArrayResize(BasketLowBuffer, sync_symbol_key_size);
    ArrayResize(BasketCloseBuffer, sync_symbol_key_size);

    //  Двигаемся по времени в символе синхронизации:
    for(int sync_symbol_key_index = sync_symbol_key_size - _count; sync_symbol_key_index < sync_symbol_key_size; sync_symbol_key_index++)
    {
      sync_symbol_time = sync_symbol_key[sync_symbol_key_index];
      PointCost = this.GetPointCost(this.sync_symbol_data.GetSymbolName(), SymbolVolumefArray[0]);

      //  Сначала учитываем символ синхронизации:

      this.sync_symbol_data.open.TryGetValue(sync_symbol_time, basketOpen);
      basketOpen *= PointCost;

      this.sync_symbol_data.high.TryGetValue(sync_symbol_time, basketHigh);
      basketHigh *= PointCost;

      this.sync_symbol_data.low.TryGetValue(sync_symbol_time, basketLow);
      basketLow *= PointCost;

      this.sync_symbol_data.close.TryGetValue(sync_symbol_time, basketClose);
      basketClose *= PointCost;

      //  Суммируем все остальные инструменты:
      for(int k = 0; k < (int)this.symbols_data_Array.Size(); k++)
      {
        PointCost = GetPointCost(this.symbols_data_Array[k].GetSymbolName(), SymbolVolumefArray[k + 1]);
    
        this.symbols_data_Array[k].open.TryGetValue(sync_symbol_time, curr_value);
        basketOpen += curr_value * PointCost;
    
        this.symbols_data_Array[k].high.TryGetValue(sync_symbol_time, curr_value);
        basketHigh += curr_value * PointCost;
    
        this.symbols_data_Array[k].low.TryGetValue(sync_symbol_time, curr_value);
        basketLow += curr_value * PointCost;
    
        this.symbols_data_Array[k].close.TryGetValue(sync_symbol_time, curr_value);
        basketClose += curr_value * PointCost;
      }

      BasketOpenBuffer[sync_symbol_key_index] = basketOpen;
      BasketCloseBuffer[sync_symbol_key_index] = basketClose;

      //  Для свечей рассчитываем High и Low:
      BasketHighBuffer[sync_symbol_key_index] = MathMax(MathMax(basketOpen, basketClose), basketHigh);
      BasketLowBuffer[sync_symbol_key_index] = MathMin(MathMin(basketOpen, basketClose), basketLow);
    }
  }
  // =====================================================================
  //  Расчет корзины для всего макссива данных:
  // =====================================================================
  void  CalculateBasketFull()
  {
    double    basketOpen = 0;
    double    basketHigh = 0;
    double    basketLow = 0;
    double    basketClose = 0;

    double    PointCost;
    double    curr_value;
    datetime  sync_symbol_time;

    datetime  sync_symbol_key[];
    int       sync_symbol_key_size = this.sync_symbol_data.time.Count();
    ArrayResize(sync_symbol_key, sync_symbol_key_size);
    this.sync_symbol_data.GetFullTime(sync_symbol_key, 0);

    ArrayResize(BasketOpenBuffer, sync_symbol_key_size);
    ArrayResize(BasketHighBuffer, sync_symbol_key_size);
    ArrayResize(BasketLowBuffer, sync_symbol_key_size);
    ArrayResize(BasketCloseBuffer, sync_symbol_key_size);

    //  Двигаемся по времени в символе синхронизации:
    for(int sync_symbol_key_index = 0; sync_symbol_key_index < sync_symbol_key_size; sync_symbol_key_index++)
    {
      sync_symbol_time = sync_symbol_key[sync_symbol_key_index];
      PointCost = this.GetPointCost(this.sync_symbol_data.GetSymbolName(), SymbolVolumefArray[0]);

      //  Сначала учитываем символ синхронизации:

      this.sync_symbol_data.open.TryGetValue(sync_symbol_time, basketOpen);
      basketOpen *= PointCost;

      this.sync_symbol_data.high.TryGetValue(sync_symbol_time, basketHigh);
      basketHigh *= PointCost;

      this.sync_symbol_data.low.TryGetValue(sync_symbol_time, basketLow);
      basketLow *= PointCost;

      this.sync_symbol_data.close.TryGetValue(sync_symbol_time, basketClose);
      basketClose *= PointCost;

      //  Суммируем все остальные инструменты:
      for(int k = 0; k < (int)this.symbols_data_Array.Size(); k++)
      {
        PointCost = GetPointCost(this.symbols_data_Array[k].GetSymbolName(), SymbolVolumefArray[k + 1]);
    
        this.symbols_data_Array[k].open.TryGetValue(sync_symbol_time, curr_value);
        basketOpen += curr_value * PointCost;
    
        this.symbols_data_Array[k].high.TryGetValue(sync_symbol_time, curr_value);
        basketHigh += curr_value * PointCost;
    
        this.symbols_data_Array[k].low.TryGetValue(sync_symbol_time, curr_value);
        basketLow += curr_value * PointCost;
    
        this.symbols_data_Array[k].close.TryGetValue(sync_symbol_time, curr_value);
        basketClose += curr_value * PointCost;
      }

      BasketOpenBuffer[sync_symbol_key_index] = basketOpen;
      BasketCloseBuffer[sync_symbol_key_index] = basketClose;

      //  Для свечей рассчитываем High и Low:
      BasketHighBuffer[sync_symbol_key_index] = MathMax(MathMax(basketOpen, basketClose), basketHigh);
      BasketLowBuffer[sync_symbol_key_index] = MathMin(MathMin(basketOpen, basketClose), basketLow);
    }
  }
  // ===================================================================== 
  //  Получить данные 'Open' корзины:
  // =====================================================================
  int GetFullBasketOpen(double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketOpenBuffer, _dst_start));
  }
  // ===================================================================== 
  //  Получить данные 'High' корзины:
  // =====================================================================
  int GetFullBasketHigh(double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketHighBuffer, _dst_start));
  }
  // ===================================================================== 
  //  Получить данные 'Low' корзины:
  // =====================================================================
  int GetFullBasketLow(double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketLowBuffer, _dst_start));
  }
  // ===================================================================== 
  //  Получить данные 'Close' корзины:
  // =====================================================================
  int GetFullBasketClose(double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketCloseBuffer, _dst_start));
  }
  // ===================================================================== 
  //  Получить последние данные 'Open' корзины:
  // =====================================================================
  int GetLastBasketOpen(const int _count, double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketOpenBuffer, _dst_start, (int)this.BasketOpenBuffer.Size() - _count, _count));
  }
  // ===================================================================== 
  //  Получить последние данные 'High' корзины:
  // =====================================================================
  int GetLastBasketHigh(const int _count, double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketHighBuffer, _dst_start, (int)this.BasketHighBuffer.Size() - _count, _count));
  }
  // ===================================================================== 
  //  Получить последние данные 'Low' корзины:
  // =====================================================================
  int GetLastBasketLow(const int _count, double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketLowBuffer, _dst_start, (int)this.BasketLowBuffer.Size() - _count, _count));
  }
  // ===================================================================== 
  //  Получить последние данные 'Close' корзины:
  // =====================================================================
  int GetLastBasketClose(const int _count, double& dst[], const int _dst_start)
  {
    return(ArrayCopy(dst, this.BasketCloseBuffer, _dst_start, (int)this.BasketCloseBuffer.Size() - _count, _count));
  }

protected:
  // =====================================================================
  //	Получить стоимость пункта:
  // =====================================================================
  double  GetPointCost(const string _symbol, const double _volume)
  {
  	ENUM_SYMBOL_CALC_MODE	calc_mode = (ENUM_SYMBOL_CALC_MODE)SymbolInfoInteger(_symbol, SYMBOL_TRADE_CALC_MODE);
  	
  	if(calc_mode == SYMBOL_CALC_MODE_FOREX)
  	{
  		string	account_currency_str = AccountInfoString(ACCOUNT_CURRENCY);
  		string	symbol_currency_base_str = SymbolInfoString(_symbol, SYMBOL_CURRENCY_BASE);
  		string	symbol_currency_profit_str = SymbolInfoString(_symbol, SYMBOL_CURRENCY_PROFIT);
  		string	symbol_currency_margin_str = SymbolInfoString(_symbol, SYMBOL_CURRENCY_MARGIN);
  
  		//	Если валюта счета совпадает базовой валютой инструмента:
  		if(account_currency_str == symbol_currency_base_str)
  		{
  			return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_CONTRACT_SIZE));
  		}
  
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_CONTRACT_SIZE) / ((SymbolInfoDouble(_symbol, SYMBOL_BID) + SymbolInfoDouble(_symbol, SYMBOL_ASK)) / 2.0));
  	}
  	else if(calc_mode == SYMBOL_CALC_MODE_FUTURES)
  	{
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_TICK_VALUE) / SymbolInfoDouble(_symbol, SYMBOL_TRADE_TICK_SIZE));
  	}
  	else if(calc_mode == SYMBOL_CALC_MODE_CFD)
  	{
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_CONTRACT_SIZE));
  	}
  	else if(calc_mode == SYMBOL_CALC_MODE_CFDINDEX)
  	{
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_CONTRACT_SIZE));
  	}
  	else if(calc_mode == SYMBOL_CALC_MODE_CFDLEVERAGE)
  	{
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_CONTRACT_SIZE));
  	}
  	else
  	{
  		return(_volume * SymbolInfoDouble(_symbol, SYMBOL_POINT) * SymbolInfoDouble(_symbol, SYMBOL_TRADE_TICK_VALUE) / SymbolInfoDouble(_symbol, SYMBOL_TRADE_TICK_SIZE));
  	}
  }
};
// ---------------------------------------------------------------------
