//+------------------------------------------------------------------+
//|                                                SMA Trend PDF.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs

#include <Graphics\Graphic.mqh>
enum type {SMA,Trend};

input type Type=SMA;
input uchar iPeriod=24;

int period,open[],mcoeff[],rez[][2],msize=0;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   period=MathMax(2,iPeriod);
   if(Type==Trend)
      period=2*period;

   ArrayResize(open,period);
   ArrayResize(mcoeff,period);
   ArrayInitialize(mcoeff,1);

   if(Type==Trend)
      for(int i=period/2;i<period;i++)
         mcoeff[i]=-1;

   int bars=MathMin(iBars(_Symbol,PERIOD_CURRENT),TerminalInfoInteger(TERMINAL_MAXBARS))-1,
       limit=bars-period;
   for(int i=bars;i>limit;i--)
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,i));

   ArrayResize(rez,msize,1000);

   for(int i=limit;i>=0;i--)
     {
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,i));
      CalcStatistic();
     }

   int n=rez[msize-1][0]-rez[0][0]+1;
   double x[],y[];
   ArrayResize(x,n);
   ArrayResize(y,n);

   for(int i=0;i<n;i++)
     {
      x[i]=rez[0][0]+i;
      y[i]=0;
     }

   for(int i=0;i<msize;i++)
      y[rez[i][0]-rez[0][0]]=rez[i][1];

   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic graphic;
   graphic.Create(0,"graph",0,0,0,w,h);
   CCurve *curve;

   curve=graphic.CurveAdd(x,y,CURVE_HISTOGRAM,"PDF");
   curve.LinesWidth(1);
   graphic.CurvePlotAll();
   graphic.Update();
   ChartScreenShot(0,EnumToString(Type)+".png",w,h);
   Sleep(3000);

   graphic.Destroy();
   ChartSetInteger(0,CHART_SHOW,true);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcStatistic()
  {
//---
   int sum=0;
   for(int i=0;i<period;i++)
      sum=sum+mcoeff[i]*open[i];

   if(msize==0)
     {
      ArrayResize(rez,1);
      rez[0][0]=sum;
      rez[0][1]=1;
      msize++;
      return;
     }

   int indx=ArrayBsearch(rez,sum);
   if(rez[indx][0]==sum)
      rez[indx][1]++;
   else
     {
      ArrayResize(rez,msize+1);
      rez[msize][0]=sum;
      rez[msize][1]=1;
      msize++;
      ArraySort(rez);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ShiftPrice(double price)
  {
//---
   for(int i=period-1;i>0;i--)
      open[i]=open[i-1];
   open[0]=(int)MathRound(price/_Point);
//---
  }
//+------------------------------------------------------------------+
