//+------------------------------------------------------------------+
//|                                     Extended Walsh Functions.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Walsh"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input uchar P=3,
            N=3,
            Noise=0;

struct func {int c[];};
func array[];
int period,denom,size;
double buffer[],weight[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   size=(int)MathPow(2,MathMin(P,10));
   period=MathMax(1,N)*size;
   denom=period+Noise;

   ArrayResize(array,size);
   ArrayResize(weight,size);

   for(int i=0;i<size;i++)
     {
      ArrayResize(array[i].c,period);
      for(int j=0;j<period;j++)
        {
         if(MathMod(i,2)==0)
            array[i].c[j]=sign(MathCos(i*(j+0.5)*M_PI/period));
         else
            array[i].c[j]=sign(MathSin((i+1)*(j+0.5)*M_PI/period));
        }
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0?rates_total-prev_calculated-1:rates_total-period-1;

      for(int b=bars;b>=0;b--)
        {
         for(int i=0;i<size;i++)
           {
            weight[i]=0;
            for(int j=0;j<period;j++)
               weight[i]=weight[i]+array[i].c[j]*open[b+j];
            weight[i]=i>0?weight[i]/denom:weight[i]/period;
           }

         double res=0;
         for(int j=0;j<size;j++)
            res=res+weight[j]*array[j].c[0];
         buffer[b]=res;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char sign(double x)
  {
//---
   if(x>0)
      return(1);
   if(x<0)
      return(-1);
   return(0);
//---
  }
//+------------------------------------------------------------------+
