//+------------------------------------------------------------------+
//|                                               Expected Trend.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Cur. Trend"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_LINE
#property indicator_label2 "Fut. Trend"
#property indicator_color2 clrRed
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

input ushort HalfPeriod=12,
             BarsHistory=1000;

int price1[],price2[],price3[],price4[],period,end,arr_trend[][2],arr_diff[][2],size1=1,size2=1;
double buffer1[],buffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer1,INDICATOR_DATA);
   ArraySetAsSeries(buffer1,true);

   SetIndexBuffer(1,buffer2,INDICATOR_DATA);
   PlotIndexSetInteger(1,PLOT_SHIFT,2*MathMax(2,HalfPeriod));
   ArraySetAsSeries(buffer2,true);

   period=MathMax(2,HalfPeriod);

   ArrayResize(price1,period);
   ArrayResize(price2,period);
   ArrayResize(price3,period);
   ArrayResize(price4,period);

   ArrayResize(arr_trend,size1,1000);
   ArrayResize(arr_diff,size2,1000);

   end=period-1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=rates_total-prev_calculated-1;

      if(prev_calculated==0)
        {
         bars=rates_total-4*period-2;
         for(int i=rates_total-1;i>bars;i--)
            ShiftPrice(open[i]);

         int curtrend=Trend(price1,price2);
         arr_trend[0][0]=curtrend;
         arr_trend[0][1]=2;
         arr_diff[0][0]=curtrend-Trend(price3,price4);
         arr_diff[0][1]=2;
        }

      for(int i=bars;i>=0;i--)
        {
         ShiftPrice(open[i]);
         int curtrend=Trend(price1,price2);

         CalcProbability(arr_trend,size1,curtrend);
         CalcProbability(arr_diff,size2,curtrend-Trend(price3,price4));

         if(i<BarsHistory)
           {
            buffer1[i]=curtrend;
            buffer2[i]=Forecast(curtrend);
           }
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Forecast(int trend)
  {
//---
   int max=arr_diff[size2-1][0]+trend,min=arr_diff[0][0]+trend;
   if(max>arr_trend[size1-1][0])
      NewMaximum(arr_trend,size1,max);
   if(min<arr_trend[0][0])
      NewMinimum(arr_trend,size1,min);

   int sum=0,denom=0;
   for(int i=0,j=ArrayBsearch(arr_trend,min);i<size2;i++,j++)
     {
      int prob=arr_trend[j][1]*arr_diff[i][1];
      sum=sum+prob*arr_trend[j][0];
      denom=denom+prob;
     }

   return((double)sum/denom);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcProbability(int &array[][2],int &size,int value)
  {
//---
   if(value<array[0][0])
      NewMinimum(array,size,value);

   if(value>array[size-1][0])
      NewMaximum(array,size,value);

   int indx=ArrayBsearch(array,value);
   array[indx][1]++;
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void NewMaximum(int &array[][2],int &size,int value)
  {
//---
   int s=value-array[0][0]+1;
   ArrayResize(array,s);
   for(int i=size;i<s;i++)
     {
      array[i][0]=array[0][0]+i;
      array[i][1]=1;
     }

   size=s;
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void NewMinimum(int &array[][2],int &size,int value)
  {
//---
   int s=array[size-1][0]-value+1;
   ArrayResize(array,s);
   for(int i=size,j=value;i<s;i++,j++)
     {
      array[i][0]=j;
      array[i][1]=1;
     }
   ArraySort(array);

   size=s;
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Trend(int &array1[],int &array2[])
  {
//---
   int sum=0;
   for(int i=0;i<period;i++)
      sum=sum+array1[i]-array2[i];
   return(sum);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ShiftPrice(double open)
  {
//---
   for(int i=end;i>0;i--)
      price4[i]=price4[i-1];
   price4[0]=price3[end];

   for(int i=end;i>0;i--)
      price3[i]=price3[i-1];
   price3[0]=price2[end];

   for(int i=end;i>0;i--)
      price2[i]=price2[i-1];
   price2[0]=price1[end];

   for(int i=end;i>0;i--)
      price1[i]=price1[i-1];
   price1[0]=(int)MathRound(open/_Point);
//---
  }
//+------------------------------------------------------------------+
