//+------------------------------------------------------------------+
//|                                  Project 23 Candle Indicator.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"

// PROPERTY SETTINGS
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   1

// PLOT SETTINGS FOR THE CANDLES
#property indicator_label1  "BTCUSDT CANDLE BARS"
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1  clrGreen, clrRed


// INDICATOR BUFFERS
double bar_open[];
double bar_high[];
double bar_low[];
double bar_close[];
double ColorBuffer[];

string   GlobalOpenTime[55];
string   GlobalOpenPrice[55];
string   GlobalHighPrice[55];
string   GlobalLowPrice[55];
string   GlobalClosePrice[55];

double ClosePrice[10];
double OpenPrice[10];
double LowPrice[10];
double HighPrice[10];

int index_time = 5;
datetime bar1_time;
datetime bar2_time;
datetime bar3_time;
datetime bar4_time;
datetime bar5_time;
datetime bar6_time;
datetime bar7_time;
datetime bar8_time;
datetime bar9_time;
datetime bar10_time;

int index_open;
double bar1_open;
double bar2_open;
double bar3_open;
double bar4_open;
double bar5_open;
double bar6_open;
double bar7_open;
double bar8_open;
double bar9_open;
double bar10_open;

int index_high;
double bar1_high;
double bar2_high;
double bar3_high;
double bar4_high;
double bar5_high;
double bar6_high;
double bar7_high;
double bar8_high;
double bar9_high;
double bar10_high;

int index_low;
double bar1_low;
double bar2_low;
double bar3_low;
double bar4_low;
double bar5_low;
double bar6_low;
double bar7_low;
double bar8_low;
double bar9_low;
double bar10_low;

int index_close;
double bar1_close;
double bar2_close;
double bar3_close;
double bar4_close;
double bar5_close;
double bar6_close;
double bar7_close;
double bar8_close;
double bar9_close;
double bar10_close;

int start_chart_index;
int current_index;

bool   DataLoaded = false; // Flag to ensure data is loaded only once


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
//---
   SetIndexBuffer(0, bar_open, INDICATOR_DATA);
   SetIndexBuffer(1, bar_high, INDICATOR_DATA);
   SetIndexBuffer(2, bar_low, INDICATOR_DATA);
   SetIndexBuffer(3, bar_close, INDICATOR_DATA);
   SetIndexBuffer(4, ColorBuffer, INDICATOR_COLOR_INDEX);

// PlotIndexSetInteger()







//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {

   string   SharedFilename = "BTCUSDTM30_MQL5.csv";

// TIME
   int time_handle = FileOpen(SharedFilename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(time_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

//LOOPING THROGH THE FILE ELEMENTS
   for(int i = 0; i < 55; i++)
     {

      GlobalOpenTime[i]  = FileReadString(time_handle);

     }

   index_time = 5;
   bar1_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar2_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar3_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar4_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar5_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar6_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar7_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar8_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar9_time = StringToTime(GlobalOpenTime[index_time]);
   index_time += 5;
   bar10_time = StringToTime(GlobalOpenTime[index_time]);

   datetime OpenTime[10] = {bar1_time, bar2_time, bar3_time, bar4_time, bar5_time, bar6_time, bar7_time, bar8_time, bar9_time, bar10_time};

   FileClose(time_handle);


// OPEN
   int open_handle = FileOpen(SharedFilename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(open_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   for(int i = 0; i < 55; i++)
     {

      GlobalOpenPrice[i]  = FileReadString(open_handle);

     }



   index_open = 6;

   bar1_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar2_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar3_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar4_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar5_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar6_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar7_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar8_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar9_open = StringToDouble(GlobalOpenPrice[index_open]);
   index_open += 5;
   bar10_open = StringToDouble(GlobalOpenPrice[index_open]);



   OpenPrice[0]  = bar1_open;
   OpenPrice[1]  = bar2_open;
   OpenPrice[2]  = bar3_open;
   OpenPrice[3]  = bar4_open;
   OpenPrice[4]  = bar5_open;
   OpenPrice[5]  = bar6_open;
   OpenPrice[6]  = bar7_open;
   OpenPrice[7]  = bar8_open;
   OpenPrice[8]  = bar9_open;
   OpenPrice[9]  = bar10_open;

   FileClose(open_handle);


// HIGH

   int high_handle = FileOpen(SharedFilename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(high_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   for(int i = 0; i < 55; i++)
     {

      GlobalHighPrice[i]  = FileReadString(high_handle);

     }

   index_high = 7;

   bar1_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar2_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar3_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar4_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar5_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar6_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar7_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar8_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar9_high = StringToDouble(GlobalHighPrice[index_high]);
   index_high += 5;
   bar10_high = StringToDouble(GlobalHighPrice[index_high]);

   HighPrice[0]  = bar1_high;
   HighPrice[1]  = bar2_high;
   HighPrice[2]  = bar3_high;
   HighPrice[3]  = bar4_high;
   HighPrice[4]  = bar5_high;
   HighPrice[5]  = bar6_high;
   HighPrice[6]  = bar7_high;
   HighPrice[7]  = bar8_high;
   HighPrice[8]  = bar9_high;
   HighPrice[9]  = bar10_high;

   FileClose(high_handle);

//LOW


   int low_handle = FileOpen(SharedFilename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(low_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   for(int i = 0; i < 55; i++)
     {

      GlobalLowPrice[i]  = FileReadString(low_handle);

     }

   index_low = 8;

   bar1_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar2_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar3_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar4_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar5_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar6_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar7_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar8_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar9_low = StringToDouble(GlobalLowPrice[index_low]);
   index_low += 5;
   bar10_low = StringToDouble(GlobalLowPrice[index_low]);


   LowPrice[0]   = bar1_low;
   LowPrice[1]   = bar2_low;
   LowPrice[2]   = bar3_low;
   LowPrice[3]   = bar4_low;
   LowPrice[4]   = bar5_low;
   LowPrice[5]   = bar6_low;
   LowPrice[6]   = bar7_low;
   LowPrice[7]   = bar8_low;
   LowPrice[8]   = bar9_low;
   LowPrice[9]   = bar10_low;

   FileClose(low_handle);

//CLOSE
   int close_handle = FileOpen(SharedFilename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(close_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   for(int i = 0; i < 55; i++)
     {

      GlobalClosePrice[i]  = FileReadString(close_handle);

     }

   index_close = 9;

   bar1_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar2_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar3_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar4_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar5_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar6_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar7_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar8_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar9_close = StringToDouble(GlobalClosePrice[index_close]);
   index_close += 5;
   bar10_close = StringToDouble(GlobalClosePrice[index_close]);

   ClosePrice[0] = bar1_close;
   ClosePrice[1] = bar2_close;
   ClosePrice[2] = bar3_close;
   ClosePrice[3] = bar4_close;
   ClosePrice[4] = bar5_close;
   ClosePrice[5] = bar6_close;
   ClosePrice[6] = bar7_close;
   ClosePrice[7] = bar8_close;
   ClosePrice[8] = bar9_close;
   ClosePrice[9] = bar10_close;

   FileClose(close_handle);

   int highest_index = ArrayMaximum(HighPrice,0,WHOLE_ARRAY);
   int lowest_index = ArrayMinimum(LowPrice,0,WHOLE_ARRAY);

   double max_level = HighPrice[highest_index] + (HighPrice[highest_index] - LowPrice[lowest_index]);
   double min_level = LowPrice[lowest_index] - (HighPrice[highest_index] - LowPrice[lowest_index]);



   IndicatorSetDouble(INDICATOR_MAXIMUM, max_level);  // maximum value
   IndicatorSetDouble(INDICATOR_MINIMUM,min_level);  // minimum value



   DataLoaded = true;

   if(!DataLoaded || rates_total < 5)
     {
      return(0); // Not enough bars yet or data loading failed
     }

   ArrayFill(bar_open, 0, rates_total, EMPTY_VALUE);
   ArrayFill(bar_high, 0, rates_total, EMPTY_VALUE);
   ArrayFill(bar_low, 0, rates_total, EMPTY_VALUE);
   ArrayFill(bar_close, 0, rates_total, EMPTY_VALUE);


    start_chart_index = rates_total - 10; // The index for "4 bars ago"


   for(int i = 0; i < 10; i++)  // START FROM SECOND BAR
     {

      current_index = start_chart_index + i;  
      bar_close[current_index] = ClosePrice[i];
      bar_open[current_index] = OpenPrice[i];
      bar_high[current_index] = HighPrice[i];
      bar_low[current_index] = LowPrice[i];

      // SET COLOR: GREEN FOR BULLISH, RED FOR BEARISH
      if(ClosePrice[i] >= OpenPrice[i])
        {
         ColorBuffer[current_index] = 0; // Index 0 of indicator_color1 (clrGreen)
        }
      else
        {
         ColorBuffer[current_index] = 1; // Index 1 of indicator_color1 (clrRed)
        }
     }


//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
