#     MetaTrader 5
$filePath = "C:\MetaQuotes\Scripts\ExpWPRBBconfig.ini"

#   /
$expertName = "ExpWPRBB"
#     (   MetaTrader 5,   INI-)
$reportPathBase = "Reports\"

#   ,  
[string]$IntervalType = $args[0]
if ([string]::IsNullOrEmpty($IntervalType)) 
  {
   $IntervalType = 'Month'
  }

$today = Get-Date

switch($IntervalType) 
  {
   'Day' 
     { 
      $fromDate = $today.AddDays(-1) 
      Write-Host ":  (-1 )"
     }
   'Week' 
     { 
      $fromDate = $today.AddDays(-7) 
      Write-Host ":  (-7 )"
     }
   'Month' 
     { 
      $fromDate = $today.AddMonths(-1) 
      Write-Host ":  (-1 )"
     }
   'Quarter' 
     { 
      $fromDate = $today.AddMonths(-3) 
      Write-Host ":  (-3 )"
     }
   'Year'
     { 
      $fromDate = $today.AddYears(-1) 
      Write-Host ":  (-1 )"
     }
   default 
     { 
      $fromDate = $today.AddMonths(-1) 
      Write-Host "  :  (-1 )"
     }
  }

#  : 1.   2.  
$fromDateString = $fromDate.ToString("yyyy.MM.dd")
$toDateString = $today.ToString("yyyy.MM.dd")

#    ,    
$reportName = "${expertName}_${IntervalType}_${fromDateString}_to_${toDateString}"
$fullReportPath = $reportPathBase + $reportName

#     (FromDate, ToDate  Report)
(Get-Content -Path $filePath) `
    -replace '^FromDate=.*$', "FromDate=$fromDateString" `
    -replace '^ToDate=.*$', "ToDate=$toDateString" `
    -replace '^Report=.*$', "Report=$fullReportPath" | Set-Content -Path $filePath

#      
Write-Host "      $filePath  ."
Write-Host "FromDate   $fromDateString"
Write-Host "ToDate   $toDateString"
Write-Host "Report   $fullReportPath"

#     
#Read-Host -Prompt " Enter  ..."