//+------------------------------------------------------------------+
//|                                       Prohect 14 5-0 Pattern.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"
#include <Trade/Trade.mqh>
CTrade trade;

input double lot_size = 0.6;



input ENUM_TIMEFRAMES timeframe = PERIOD_CURRENT;
input double b_xa_max = 161.8; // MAX B EXTENSION LEVEL FOR XA
input double b_xa_min = 113.0; // MIN B EXTENSION LEVEL FOR XA
input double c_ab_max = 224.0; // MAX C EXTENSION LEVEL FOR AB
input double c_ab_min = 161.8; // MIN C EXTENSION LEVEL FOR AB
input double d_bc_max = 55.0; // MAX D RETRACEMENT LEVEL FOR BC
input double d_bc_min = 50.0; // MIN D RETRACEMENT LEVEL FOR BC

datetime time_bar;
int bars_check = 400;
int total_symbol_bars;

double open[];
double close[];
double low[];
double high[];
datetime time[];

int z = 4;

double O;
datetime O_time;
string O_line;
string O_letter;

double X;
datetime X_time;
string X_letter;

double A;
datetime A_time;
string A_letter;

double B;
datetime B_time;
string B_line;
string B_letter;

double C;
datetime C_time;
string C_line;
string C_letter;

double D;
datetime D_time;
string D_line;
string D_letter;



double fib_ext_b_161;
double fib_ext_b_113;
string fib_xa_ext_obj;
string fib_xa_ext_lvl;

string ox_line;
string xa_line;
string ab_line;
ulong chart_id = ChartID();



double fib_ext_c_161;
double fib_ext_c_224;
string fib_ab_ext_obj;
string fib_ab_ext_lvl;
string bc_line;

double fib_ret_d_50;
double fib_ret_d_55;
string fib_bc_ret_lvl;
string cd_line;

int c_d_bars;
int c_highest_index;
double c_d_hh;
datetime c_d_hh_t;

int b_c_bars;
int b_lowest_index;
double b_c_ll;
datetime b_c_ll_t;

int a_b_bars;
int a_highest_index;
double a_b_hh;
datetime a_b_hh_t;

int x_a_bars;
int x_lowest_index;
double x_a_ll;
datetime x_a_ll_t;

int o_x_bars;
int o_highest_index;
double o_x_hh;
datetime o_x_hh_t;

datetime time_price[];
double ask_price;
double take_p;
datetime last_trade_time = 0;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---

   ArraySetAsSeries(time_price,true);




//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---


  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

   total_symbol_bars = Bars(_Symbol, timeframe);
   time_bar = iTime(_Symbol, timeframe, 0);
   CopyOpen(_Symbol, timeframe, time_bar, bars_check, open);
   CopyClose(_Symbol, timeframe, time_bar, bars_check, close);
   CopyLow(_Symbol, timeframe, time_bar, bars_check, low);
   CopyHigh(_Symbol, timeframe, time_bar, bars_check, high);
   CopyTime(_Symbol, timeframe, time_bar, bars_check, time);

   CopyTime(_Symbol, timeframe, 0, 2, time_price);
   ask_price = SymbolInfoDouble(_Symbol,SYMBOL_ASK);
   datetime current_bar_time = iTime(_Symbol,timeframe,0);

   if(total_symbol_bars >= bars_check)
     {

      for(int i = z ; i < bars_check - z; i++)
        {
         if(IsSwingHigh(high, i, z))
           {

            for(int j = i; j < bars_check - z; j++)
              {

               if(IsSwingLow(low, j, z) && low[j] < high[i])
                 {

                  X = low[j];
                  X_time = time[j];
                  X_letter = StringFormat("X  %d",j);

                  for(int a = j; a >= i; a--)
                    {
                     if(IsSwingHigh(high, a, z) && high[a] > X)
                       {

                        O = high[a];
                        O_time = time[a];
                        O_letter = StringFormat("0  %d",a);

                        for(int k = j; k < bars_check - z; k++)
                          {

                           if(IsSwingHigh(high, k, z) && high[k] > X)
                             {

                              A = high[k];
                              A_time = time[k];
                              A_letter = StringFormat("A  %d",k);

                              for(int l = k; l < bars_check - z; l++)
                                {

                                 if(IsSwingLow(low, l, z) && low[l] < X)
                                   {

                                    B = low[l];
                                    B_time = time[l];
                                    B_letter = StringFormat("B  %d",l);

                                    for(int m = l; m < bars_check - z; m++)
                                      {

                                       if(IsSwingHigh(high, m, z) && high[m] > A)
                                         {

                                          C = high[m];
                                          C_time = time[m];
                                          C_letter = StringFormat("C  %d",m);

                                          for(int n = m; n < bars_check - z; n++)
                                            {
                                             if(IsSwingLow(low, n, z) && low[n] < C)
                                               {

                                                D = low[n];
                                                D_time = time[n];
                                                D_letter = StringFormat("D  %d",l);
                                                cd_line = StringFormat("CD %d",i);

                                                c_d_bars = Bars(_Symbol,PERIOD_CURRENT,C_time,D_time);
                                                c_highest_index = ArrayMaximum(high,m,c_d_bars);
                                                c_d_hh = high[c_highest_index];
                                                c_d_hh_t = time[c_highest_index];



                                                b_c_bars = Bars(_Symbol,PERIOD_CURRENT,B_time,c_d_hh_t);
                                                b_lowest_index = ArrayMinimum(low,l,b_c_bars);
                                                b_c_ll = low[b_lowest_index];
                                                b_c_ll_t = time[b_lowest_index];




                                                a_b_bars = Bars(_Symbol,PERIOD_CURRENT,A_time,b_c_ll_t);
                                                a_highest_index = ArrayMaximum(high,k,a_b_bars);
                                                a_b_hh = high[a_highest_index];
                                                a_b_hh_t = time[a_highest_index];



                                                x_a_bars = Bars(_Symbol,PERIOD_CURRENT,X_time,a_b_hh_t);
                                                x_lowest_index = ArrayMinimum(low,j,x_a_bars);
                                                x_a_ll = low[x_lowest_index];
                                                x_a_ll_t = time[x_lowest_index];



                                                o_x_bars = Bars(_Symbol,PERIOD_CURRENT,O_time,x_a_ll_t);
                                                o_highest_index = ArrayMaximum(high,a,o_x_bars);
                                                o_x_hh = high[o_highest_index];
                                                o_x_hh_t = time[o_highest_index];





                                                fib_ext_b_113 =  MathAbs((((a_b_hh - x_a_ll) / 100) * (b_xa_min - 100)) - x_a_ll);
                                                fib_ext_b_161 =   MathAbs((((a_b_hh - x_a_ll) / 100) * (b_xa_max - 100)) - x_a_ll);

                                                fib_ext_c_161 = MathAbs((((a_b_hh - b_c_ll) / 100) * (c_ab_min - 100)) + a_b_hh);
                                                fib_ext_c_224 =    MathAbs((((a_b_hh - b_c_ll) / 100) * (c_ab_max - 100)) + a_b_hh);


                                                fib_ret_d_50 = c_d_hh - ((d_bc_min / 100) * (c_d_hh - b_c_ll));
                                                fib_ret_d_55 = c_d_hh - ((d_bc_max / 100) * (c_d_hh - b_c_ll));



                                                if(x_a_ll < o_x_hh && a_b_hh > x_a_ll && a_b_hh < o_x_hh && b_c_ll <= fib_ext_b_113 && b_c_ll >= fib_ext_b_161 && c_d_hh >= fib_ext_c_161 && c_d_hh <= fib_ext_c_224 && D <= fib_ret_d_50 && D >= fib_ret_d_55)
                                                  {

                                                   ObjectCreate(chart_id,O_letter,OBJ_TEXT,0,o_x_hh_t,o_x_hh);
                                                   ObjectSetString(chart_id,O_letter,OBJPROP_TEXT,"0");
                                                   ObjectSetInteger(chart_id,O_letter,OBJPROP_COLOR,clrBlue);

                                                   ObjectCreate(chart_id,X_letter,OBJ_TEXT,0,x_a_ll_t,x_a_ll);
                                                   ObjectSetString(chart_id,X_letter,OBJPROP_TEXT,"X");
                                                   ObjectSetInteger(chart_id,X_letter,OBJPROP_COLOR,clrBlue);

                                                   ObjectCreate(chart_id,A_letter,OBJ_TEXT,0,a_b_hh_t,a_b_hh);
                                                   ObjectSetString(chart_id,A_letter,OBJPROP_TEXT,"A");
                                                   ObjectSetInteger(chart_id,A_letter,OBJPROP_COLOR,clrBlue);

                                                   ObjectCreate(chart_id,B_letter,OBJ_TEXT,0,b_c_ll_t,b_c_ll);
                                                   ObjectSetString(chart_id,B_letter,OBJPROP_TEXT,"B");
                                                   ObjectSetInteger(chart_id,B_letter,OBJPROP_COLOR,clrBlue);

                                                   ox_line = StringFormat("0X Line  %d",i);
                                                   xa_line = StringFormat("XA Line  %d",i);
                                                   ab_line = StringFormat("AB Line  %d",i);

                                                   ObjectCreate(chart_id,ox_line,OBJ_TREND,0, o_x_hh_t, o_x_hh,x_a_ll_t,x_a_ll);
                                                   ObjectSetInteger(chart_id,ox_line,OBJPROP_COLOR,clrBlue);

                                                   ObjectCreate(chart_id,xa_line,OBJ_TREND,0, x_a_ll_t, x_a_ll,a_b_hh_t,a_b_hh);
                                                   ObjectSetInteger(chart_id,xa_line,OBJPROP_COLOR,clrBlue);

                                                   ObjectCreate(chart_id,ab_line,OBJ_TREND,0, a_b_hh_t, a_b_hh,b_c_ll_t,b_c_ll);
                                                   ObjectSetInteger(chart_id,ab_line,OBJPROP_COLOR,clrBlue);


                                                   fib_xa_ext_obj = StringFormat("XA Expansion  %d",i);
                                                   ObjectCreate(chart_id,fib_xa_ext_obj,OBJ_EXPANSION,0,a_b_hh_t,a_b_hh,x_a_ll_t,x_a_ll,a_b_hh_t,a_b_hh);
                                                   ObjectSetInteger(chart_id,fib_xa_ext_obj,OBJPROP_COLOR,clrBlue);
                                                   for(int i = 0; i <= 2; i++)
                                                     {

                                                      ObjectSetInteger(chart_id,fib_xa_ext_obj,OBJPROP_LEVELCOLOR,i,clrBlue);

                                                     }

                                                   fib_xa_ext_lvl = StringFormat("XA Expansion Levels %d",i);

                                                   ObjectCreate(chart_id,fib_xa_ext_lvl,OBJ_RECTANGLE,0,x_a_ll_t,fib_ext_b_113,b_c_ll_t,fib_ext_b_161);
                                                   ObjectSetInteger(chart_id,fib_xa_ext_lvl,OBJPROP_COLOR,clrBlue);


                                                   ObjectCreate(chart_id,C_letter,OBJ_TEXT,0,c_d_hh_t,c_d_hh);
                                                   ObjectSetString(chart_id,C_letter,OBJPROP_TEXT,"C");
                                                   ObjectSetInteger(chart_id,C_letter,OBJPROP_COLOR,clrBlue);

                                                   bc_line = StringFormat("BC Line  %d",i);
                                                   ObjectCreate(chart_id,bc_line,OBJ_TREND,0, b_c_ll_t, b_c_ll,c_d_hh_t,c_d_hh);
                                                   ObjectSetInteger(chart_id,bc_line,OBJPROP_COLOR,clrBlue);




                                                   fib_ab_ext_obj = StringFormat("AB Expansion  %d",i);
                                                   ObjectCreate(chart_id,fib_ab_ext_obj,OBJ_EXPANSION,0,b_c_ll_t,b_c_ll,a_b_hh_t,a_b_hh,b_c_ll_t,b_c_ll);
                                                   ObjectSetInteger(chart_id,fib_ab_ext_obj,OBJPROP_COLOR,clrBlue);
                                                   for(int i = 0; i <= 2; i++)
                                                     {

                                                      ObjectSetInteger(chart_id,fib_ab_ext_obj,OBJPROP_LEVELCOLOR,i,clrBlue);

                                                     }

                                                   fib_ab_ext_lvl = StringFormat("AB Expansion Levels %d",i);

                                                   ObjectCreate(chart_id,fib_ab_ext_lvl,OBJ_RECTANGLE,0,a_b_hh_t,fib_ext_c_161,c_d_hh_t,fib_ext_c_224);
                                                   ObjectSetInteger(chart_id,fib_ab_ext_lvl,OBJPROP_COLOR,clrBlue);



                                                   ObjectCreate(chart_id,D_letter,OBJ_TEXT,0,D_time,D);
                                                   ObjectSetString(chart_id,D_letter,OBJPROP_TEXT,"D");
                                                   ObjectSetInteger(chart_id,D_letter,OBJPROP_COLOR,clrBlue);

                                                   cd_line = StringFormat("CD Line  %d",i);
                                                   ObjectCreate(chart_id,cd_line,OBJ_TREND,0, c_d_hh_t, c_d_hh,D_time,D);
                                                   ObjectSetInteger(chart_id,cd_line,OBJPROP_COLOR,clrBlue);



                                                   fib_bc_ret_lvl = StringFormat("BC RETRACEMENT Levels %d",i);

                                                   ObjectCreate(chart_id,fib_bc_ret_lvl,OBJ_RECTANGLE,0,b_c_ll_t,fib_ret_d_50,D_time,fib_ret_d_55);
                                                   ObjectSetInteger(chart_id,fib_bc_ret_lvl,OBJPROP_COLOR,clrBlue);

                                                   if(time[n+z] == time_price[1] && close[n+z] > D && current_bar_time != last_trade_time)
                                                     {

                                                      take_p = ask_price + (MathAbs(ask_price - D) * 3);

                                                      trade.Buy(lot_size,_Symbol,ask_price,D,take_p);

                                                      last_trade_time = current_bar_time;


                                                     }







                                                  }

                                                break;
                                               }
                                            }

                                          break;
                                         }
                                      }


                                    break;
                                   }
                                }


                              break;
                             }
                          }

                        break;
                       }
                    }


                  break;
                 }
              }

           }

        }
     }



  }

//+------------------------------------------------------------------+
//| FUNCTION FOR SWING LOW                                           |
//+------------------------------------------------------------------+
bool IsSwingLow(const double &low_price[], int index, int lookback)
  {
   for(int i = 1; i <= lookback; i++)
     {
      if(low_price[index] > low_price[index - i] || low_price[index] > low_price[index + i])
         return false;
     }
   return true;
  }


//+------------------------------------------------------------------+
//| FUNCTION FOR SWING HIGH                                          |
//+------------------------------------------------------------------+
bool IsSwingHigh(const double &high_price[], int index, int lookback)
  {
   for(int i = 1; i <= lookback; i++)
     {
      if(high_price[index] < high_price[index - i] || high_price[index] < high_price[index + i])
         return false; // If the current high is not the highest, return false.
     }
   return true;
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
