/**
 * @file script.js
 * @version 0.1.0
 */

/**
 * Запуск терминала
 * @param {string} name - Имя экземпляра
 */
async function startInstance(name) {
  // Посылаем запрос по нужному маршруту
  const res = await fetch(`/start/${name}`, { method: "POST" });

  // Получаем ответ
  const data = await res.json();

  // Здесь можно добавить дополнительные действия 
  console.log(data);

  // Перезагружаем страницу
  location.reload();
}

/**
 * Остановка терминала
 * @param {string} name - Имя экземпляра
 */
async function stopInstance(name) {
  // Посылаем запрос по нужному маршруту
  const res = await fetch(`/stop/${name}`, { method: "POST" });

  // Получаем ответ
  const data = await res.json();

  // Здесь можно добавить дополнительные действия
  console.log(data);

  // Перезагружаем страницу
  location.reload();
}

/*
async function createInstance() {
  const name = document.getElementById("instanceName").value;
  if (!name) return;

  const res = await fetch(`/create/${name}`, { method: "POST" });
  const data = await res.json();
  console.log(data);

  location.reload();
}
*/