'''
File: main.py
Description: Веб-приложение для веб-сервера терминалов, основной файл FastAPI
'''

__version__ = '0.1.0'


# Импортируем нужные классы из библиотек
from fastapi import FastAPI, Request, Path
from fastapi.staticfiles import StaticFiles
from fastapi.templating import Jinja2Templates
from fastapi.responses import HTMLResponse, JSONResponse

from mt5_control import start_mt5, stop_mt5, load_instances


# Создаём объект приложения
app = FastAPI()

# Подключаем статические файлы
app.mount('/static', StaticFiles(directory='static'), name='static')

# Создаём объект для работы с шаблонами HTML-кода
templates = Jinja2Templates(directory='templates')


@app.get('/', response_class=HTMLResponse)
async def index(request: Request):
    '''Обработчик GET / (корневой каталог) - панель управления терминалами'''
    instances = load_instances()
    return templates.TemplateResponse('index.html', {'request': request, 'instances': instances})


@app.post('/start/{name}')
async def start_instance(name: str = Path(..., description="Название экземпляра", example="MetaTrader5.1")):
    '''Запуск экземпляра терминала'''
    result = start_mt5(name)
    return JSONResponse(result)


@app.post('/stop/{name}')
async def stop_instance(name: str = Path(..., description="Название экземпляра", example="MetaTrader5.1")):
    '''Остановка экземпляра терминала'''
    result = stop_mt5(name)
    return JSONResponse(result)
