//+------------------------------------------------------------------+
//|                                              BEOVB_BUOVB_bar.mq4 |
//|                                  Copyright 2015, Iglakov Dmitry. |
//|                                               cjdmitri@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, Iglakov Dmitry."
#property link      "cjdmitri@gmail.com"
#property version   "1.00"
#property strict

extern int     interval          = 25;                               //Interval
extern double  lot               = 0.1;                              //Lot Size
extern int     TP                = 400;                              //Take Profit
extern int     magic             = 962231;                           //Magic number
extern int     slippage          = 2;                                //Slippage
extern int     ExpDate           = 48;                               //Expiration Hour Order
extern int     bar1size          = 900;                              //Bar 1 Size

double   buyPrice,//    BuyStop
buyTP,      //Take Profit BuyStop
buySL,      //Stop Loss BuyStop
sellPrice,  //    SellStop
sellTP,     //Take Profit SellStop
sellSL;     //Stop Loss SellStop

double   open1,//   
open2,    //   
close1,   //   
close2,   //   
low1,     //   
low2,     //   
high1,    //   
high2;    //   

datetime _ExpDate=0;       //       
double   _bar1size;        //       
datetime timeBUOVB_BEOVB;  // ,      ,    
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   double   _bid     = NormalizeDouble(MarketInfo(Symbol(), MODE_BID), Digits); //   
   double   _ask     = NormalizeDouble(MarketInfo(Symbol(), MODE_ASK), Digits); //  
   double   _point   = MarketInfo(Symbol(), MODE_POINT);
//---    
   open1        = NormalizeDouble(iOpen(Symbol(), Period(), 1), Digits);
   open2        = NormalizeDouble(iOpen(Symbol(), Period(), 2), Digits);
   close1       = NormalizeDouble(iClose(Symbol(), Period(), 1), Digits);
   close2       = NormalizeDouble(iClose(Symbol(), Period(), 2), Digits);
   low1         = NormalizeDouble(iLow(Symbol(), Period(), 1), Digits);
   low2         = NormalizeDouble(iLow(Symbol(), Period(), 2), Digits);
   high1        = NormalizeDouble(iHigh(Symbol(), Period(), 1), Digits);
   high2        = NormalizeDouble(iHigh(Symbol(), Period(), 2), Digits);

//---        -
   buyPrice=NormalizeDouble(high1+interval*_point,Digits); //      
   buySL=NormalizeDouble(low1-interval*_point,Digits);     // -   
   buyTP=NormalizeDouble(buyPrice+TP*_point,Digits);       // -
   _ExpDate=TimeCurrent()+ExpDate*60*60;                   //    
//---       
   sellPrice=NormalizeDouble(low1-interval*_point,Digits);
   sellSL=NormalizeDouble(high1+interval*_point,Digits);
   sellTP=NormalizeDouble(sellPrice-TP*_point,Digits);
//---
   _bar1size=NormalizeDouble(((high1-low1)/_point),0);
//---    BEOVB
   if(timeBUOVB_BEOVB!=iTime(Symbol(),Period(),1) && //      
      _bar1size>bar1size && //   ,      
      low1 < low2 &&        //      
      high1 > high2 &&      //     
      close1 < open2 &&     //       
      open1 > close1 &&     //  
      open2 < close2)       //  
     {
      //---    , ,         
      OrderOpenF(Symbol(),OP_SELLSTOP,lot,sellPrice,slippage,sellSL,sellTP,NULL,magic,_ExpDate,Blue);
      timeBUOVB_BEOVB=iTime(Symbol(),Period(),1); //,       
     }
//---    BUOVB
   if(timeBUOVB_BEOVB!=iTime(Symbol(),Period(),1) && //      
      _bar1size>bar1size && //   ,      
      low1 < low2 &&      //      
      high1 > high2 &&    //     
      close1 > open2 &&   //       
      open1 < close1 &&   //  
      open2 > close2)     //  
     {
      //---    , ,         
      OrderOpenF(Symbol(),OP_BUYSTOP,lot,buyPrice,slippage,buySL,buyTP,NULL,magic,_ExpDate,Blue);
      timeBUOVB_BEOVB=iTime(Symbol(),Period(),1); //,       
     }
  }
//+---------------------------------------------------------------------------------------------------------------------+
//|                                                                                |
//| symbol      -   ,     .                         |
//| cmd         -  .       .                                    |
//| volume      -  .                                                                                     |
//| price       -  .                                                                                        |
//| slippage    -        (    ).         |
//| stoploss    -        (0     ).   |
//| takeprofit  -        (0     ). |
//| comment     -   .        .          |
//| magic       -   .      .           |
//| expiration  -    .                                                                    |
//| arrow_color -     .        CLR_NONE,       |
//|                     .                                                    |
//+---------------------------------------------------------------------------------------------------------------------+
int OrderOpenF(string     OO_symbol,
               int        OO_cmd,
               double     OO_volume,
               double     OO_price,
               int        OO_slippage,
               double     OO_stoploss,
               double     OO_takeprofit,
               string     OO_comment,
               int        OO_magic,
               datetime   OO_expiration,
               color      OO_arrow_color)
  {
   int      result      = -1;    //  
   int      Error       = 0;     //   .
   int      attempt     = 0;     //  
   int      attemptMax  = 3;     //  
   bool     exit_loop   = false; //  
   string   lang=TerminalInfoString(TERMINAL_LANGUAGE);  //  ,    
   double   stopllvl=NormalizeDouble(MarketInfo(OO_symbol,MODE_STOPLEVEL)*MarketInfo(OO_symbol,MODE_POINT),Digits);  //   -/-  
                                                                                                                     //    . 
//---  -   
   if(OO_cmd==OP_BUY || OO_cmd==OP_BUYLIMIT || OO_cmd==OP_BUYSTOP)
     {
      double tp = (OO_takeprofit - OO_price)/MarketInfo(OO_symbol, MODE_POINT);
      double sl = (OO_price - OO_stoploss)/MarketInfo(OO_symbol, MODE_POINT);
      if(tp>0 && tp<=stopllvl)
        {
         OO_takeprofit=OO_price+stopllvl+2*MarketInfo(OO_symbol,MODE_POINT);
        }
      if(sl>0 && sl<=stopllvl)
        {
         OO_stoploss=OO_price -(stopllvl+2*MarketInfo(OO_symbol,MODE_POINT));
        }
     }
//---  -   
   if(OO_cmd==OP_SELL || OO_cmd==OP_SELLLIMIT || OO_cmd==OP_SELLSTOP)
     {
      double tp = (OO_price - OO_takeprofit)/MarketInfo(OO_symbol, MODE_POINT);
      double sl = (OO_stoploss - OO_price)/MarketInfo(OO_symbol, MODE_POINT);
      if(tp>0 && tp<=stopllvl)
        {
         OO_takeprofit=OO_price -(stopllvl+2*MarketInfo(OO_symbol,MODE_POINT));
        }
      if(sl>0 && sl<=stopllvl)
        {
         OO_stoploss=OO_price+stopllvl+2*MarketInfo(OO_symbol,MODE_POINT);
        }
     }
//---  while
   while(!exit_loop)
     {
      result=OrderSend(OO_symbol,OO_cmd,OO_volume,OO_price,OO_slippage,OO_stoploss,OO_takeprofit,OO_comment,OO_magic,OO_expiration,OO_arrow_color); //     
      //--- ,      
      if(result<0)
        {
         Error = GetLastError();                                     //  
         switch(Error)                                               // 
           {                                                         //       
            case  2:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  Sleep(3000);                                       //  3 
                  RefreshRates();
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt=0;                                         //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case  3:
               RefreshRates();
               exit_loop = true;                                     //  while
               break;                                                //  switch   
            case  4:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  Sleep(3000);                                       //  3 
                  RefreshRates();
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case  5:
               exit_loop = true;                                     //  while
               break;                                                //  switch   
            case  6:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  Sleep(5000);                                       //  3 
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case  8:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  Sleep(7000);                                       //  3 
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case 64:
               exit_loop = true;                                     //  while
               break;                                                //  switch
            case 65:
               exit_loop = true;                                     //  while
               break;                                                //  switch
            case 128:
               Sleep(3000);
               RefreshRates();
               continue;                                             //  switch
            case 129:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  Sleep(3000);                                       //  3 
                  RefreshRates();
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case 130:
               exit_loop=true;                                       //  while
               break;
            case 131:
               exit_loop = true;                                     //  while
               break;                                                //  switch
            case 132:
               Sleep(10000);                                         //  10 .
               RefreshRates();                                       // 
                                                                     //exit_loop = true;                                   //  while
               break;                                                //  switch
            case 133:
               exit_loop=true;                                       //  while
               break;                                                //  switch
            case 134:
               exit_loop=true;                                       //  while
               break;                                                //  switch
            case 135:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  RefreshRates();
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case 136:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;                                 //   
                  RefreshRates();
                  break;                                             //  switch
                 }
               if(attempt==attemptMax)
                 {
                  attempt = 0;                                       //   
                  exit_loop = true;                                  //  while
                  break;                                             //  switch
                 }
            case 137:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;
                  Sleep(2000);
                  RefreshRates();
                  break;
                 }
               if(attempt==attemptMax)
                 {
                  attempt=0;
                  exit_loop=true;
                  break;
                 }
            case 138:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;
                  Sleep(1000);
                  RefreshRates();
                  break;
                 }
               if(attempt==attemptMax)
                 {
                  attempt=0;
                  exit_loop=true;
                  break;
                 }
            case 139:
               exit_loop=true;
               break;
            case 141:
               Sleep(5000);
               exit_loop=true;
               break;
            case 145:
               exit_loop=true;
               break;
            case 146:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;
                  Sleep(2000);
                  RefreshRates();
                  break;
                 }
               if(attempt==attemptMax)
                 {
                  attempt=0;
                  exit_loop=true;
                  break;
                 }
            case 147:
               if(attempt<attemptMax)
                 {
                  attempt=attempt+1;
                  OO_expiration=0;
                  break;
                 }
               if(attempt==attemptMax)
                 {
                  attempt=0;
                  exit_loop=true;
                  break;
                 }
            case 148:
               exit_loop=true;
               break;
            default:
               Print("Error: ",Error);
               exit_loop=true; //  while 
               break;          //  
           }
        }
      //--- ,   
      else
        {
         if(lang == "Russian") {Print("  . ", result);}
         if(lang == "English") {Print("The order is successfully opened.", result);}
         Error = 0;                                //  
         break;                                    //  while
         //errorCount =0;                          //  
        }
     }
   return(result);
  }
//+------------------------------------------------------------------+
