//+------------------------------------------------------------------+
//|                                                       exchng.mq4 |
//|                                           Copyright  2009, alsu |
//|                                                 alsufx@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, alsu"
#property link      "alsufx@gmail.com"
#property library

#import "exchng.dll"
   int GetPtr(double &a[]);
   double GetValue(int pointer,int i);
   void SetValue(int pointer,int i,double value);
#import

void RegisterBuffer(double &Buffer[], string name, int mode) 
{
   UnregisterBuffer(Buffer);                    //     
   
   int direction=0;
   if(ArrayGetAsSeries(Buffer)) direction=1;    //   

   name=name+"#"+mode+"#"+Symbol()+"#"+Period()+"#"+ArraySize(Buffer)+"#"+direction;
   int ptr=GetPtr(Buffer);                // 
   if(ptr==0) return;
   
   MathSrand(ptr);                            //     (  )   

   while(true)
   {
      int rnd=MathRand();
      if(!GlobalVariableCheck(name+"#"+rnd))    //  - ,        
      {                                         // ,  RAND_MAX :)
         name=name+"#"+rnd;                     
         GlobalVariableSet(name,ptr);         //    
         break;
      }
   }   
}

void UnregisterBuffer(double &Buffer[]) 
{
   int ptr=GetPtr(Buffer);                  //     
   if(ptr==0) return;
   
   int gt=GlobalVariablesTotal();               
   int i;
   for(i=gt-1;i>=0;i--)                           //     
   {                                            //    ,   ""
      string name=GlobalVariableName(i);        
      if(GlobalVariableGet(name)==ptr)
         GlobalVariableDel(name);
   }      
}

int FindBuffers(string name, int mode, string symbol, int period, string &buffers[]) 
{
   int count=0;
   int i;
   bool found;
   string name_i;
   string descriptor[];
   int gt=GlobalVariablesTotal();

   StringTrimLeft(name);                                    //    
   StringTrimRight(name);
   
   ArrayResize(buffers,count);                              // 

   for(i=gt-1;i>=0;i--)
   {
      found=true;
      name_i=GlobalVariableName(i);
      
      StringExplode(name_i,"#",descriptor);                 //   
      
      if(StringFind(descriptor[0],name)<0&&name!="") found=false;      //      
      if(StrToInteger(descriptor[1])!=mode&&mode>=0) found=false;
      if(descriptor[2]!=symbol&&symbol!="") found=false;
      if(StrToInteger(descriptor[3])!=period&&period>0) found=false;
      
      if(found)
      {
         count++;                                           //  ,   
         ArrayResize(buffers,count);
         buffers[count-1]=name_i;
      }
   }
   
   return(count);
}

double GetIndicatorValue(string descriptor, int shift) 
{
   int ptr;
   string fields[];
   int size,direction;
   if(GlobalVariableCheck(descriptor)>0)                    //   
   {                
      ptr = GlobalVariableGet(descriptor);                  //  
      if(ptr!=0)
      {
         StringExplode(descriptor,"#",fields);              //    
         size = StrToInteger(fields[4]);                                  //    
         direction=StrToInteger(fields[5]);                                 
         if(direction==1) shift=size-1-shift;               //   
         if(shift>=0&&shift<size)                           //   -    
            return(GetValue(MathAbs(ptr),shift));           //,  
      }   
   } 
   return(EMPTY_VALUE);                                     //   ...
}

bool SetIndicatorValue(string descriptor, int shift, double value) 
{
   int ptr;
   string fields[];
   int size,direction;
   if(GlobalVariableCheck(descriptor)>0)                    //   
   {                
      ptr = GlobalVariableGet(descriptor);                  //  
      if(ptr!=0)
      {
         StringExplode(descriptor,"#",fields);              //    
         size = StrToInteger(fields[4]);                                  //    
         direction=StrToInteger(fields[5]);                                 
         if(direction==1) shift=size-1-shift;               //   
         if(shift>=0&&shift<size)                           //   -    
         {
            SetValue(MathAbs(ptr),shift,value);
            return(true);
         }   
      }   
   }
   return(false);
}

void StringExplode(string s, string separator, string &result[])
{
   int i,pos;
   ArrayResize(result,1);
   
   pos=StringFind(s,separator); 
   if(pos<0) {result[0]=s;return;}
   
   for(i=0;;i++)
   {
      pos=StringFind(s,separator); 
      if(pos>=0)
      {
         result[i]=StringSubstr(s,0,pos);
         s=StringSubstr(s,pos+StringLen(separator));
      }
      else break;
      ArrayResize(result,ArraySize(result)+1);
   }
}

