//=====================================================================
//	   :
//=====================================================================


//---------------------------------------------------------------------
#property copyright 	"Dima S., 2011-2013"
#property link      	"dimascub@mail.com"
//---------------------------------------------------------------------


//=====================================================================
//	 :
//=====================================================================
//---------------------------------------------------------------------


//=====================================================================
//	   :
//=====================================================================
class TCheckNewBar
{
private:
	string					data_symbol;
	ENUM_TIMEFRAMES	data_period;

private:
	datetime	last_bar_datetime;
	datetime	curr_datetime;
	double		open_array[ ];

public:
	TCheckNewBar( const string _symbol, const ENUM_TIMEFRAMES _period, bool _first_start = false )
	:
	data_symbol( _symbol ),
	data_period( _period )
	{
		this.curr_datetime = ( datetime )SeriesInfoInteger( this.data_symbol, this.data_period, SERIES_LASTBAR_DATE );
		if( _first_start )
		{
			this.last_bar_datetime = 0;
		}
		else
		{
			this.last_bar_datetime = this.curr_datetime;
		}
	}
	~TCheckNewBar( )
	{
	}

public:
//---------------------------------------------------------------------
//	    :
//---------------------------------------------------------------------
//	( 1 -    )
//---------------------------------------------------------------------
	int				CheckNewBar( )
	{
		this.curr_datetime = ( datetime )SeriesInfoInteger( this.data_symbol, this.data_period, SERIES_LASTBAR_DATE );
		if( this.curr_datetime > this.last_bar_datetime )
		{
			this.last_bar_datetime = this.curr_datetime;

			return( 1 );
		}

		return( 0 );
	}
//---------------------------------------------------------------------
//	    (  ) :
//---------------------------------------------------------------------
	datetime	GetLastBarDateTime( )
	{
		return( this.last_bar_datetime );
	}
//---------------------------------------------------------------------
//	    (  ) :
//---------------------------------------------------------------------
	double		GetLastBarOpen( )
	{
		if( CopyOpen( this.data_symbol, this.data_period, this.last_bar_datetime, 1, open_array ) == 1 )
		{
			return( NormalizeDouble( open_array[ 0 ], ( int )SymbolInfoInteger( this.data_symbol, SYMBOL_DIGITS )));
		}

//	    :
		return( -1.0 );
	}
};
//---------------------------------------------------------------------
