//+------------------------------------------------------------------+
//|                                             SignalML_DEM_ENV.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/66_6.onnx" as uchar __66_6[]
#resource "Python/66_9.onnx" as uchar __66_9[]
#define __PATTERNS 2
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with FrAMA and Force Index Oscillator.       |
//| Type=SignalAdvanced                                              |
//| Name=FrAMA and Force Index Oscillator                            |
//| ShortName=FRM_FRC                                                |
//| Class=CSigna_ML_lFRM_FRC                                             |
//| Page=signal_frm_frc                                              |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_9,int,50,Pattern 9                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignal_ML_DEM_ENV.                                        |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of ML with FrAMA and Force Index Oscillator.    |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSigna_ML_lFRM_FRC : public CExpertSignal
{
protected:
   CiFrAMA           m_frm,m_frm_d1;
   CiForce           m_frc,m_frc_d1;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_6;      // model 6
   int               m_pattern_9;      // model 9

   int               m_periods;
   //
   //int               m_patterns_usage;   //

public:
   CSigna_ML_lFRM_FRC(void);
   ~CSigna_ML_lFRM_FRC(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   void              PeriodUsed(int value)
   {  m_periods = value;
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitFRM_FRC(CIndicators *indicators);
   //--- methods of getting data
   double            FRM(int ind)
   {  //
      m_frm.Refresh(-1);
      return(m_frm.Main(ind));
   }
   double            FRM_D1(int ind)
   {  //
      m_frm_d1.Refresh(-1);
      return(m_frm_d1.Main(ind));
   }
   double            FRC(int ind)
   {  //
      m_frc.Refresh(-1);
      return(m_frc.Main(ind));
   }
   double            FRC_D1(int ind)
   {  //
      m_frc_d1.Refresh(-1);
      return(m_frc_d1.Main(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   double              Supervise(int Index, ENUM_POSITION_TYPE T);
   //--- methods to check for patterns
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_9(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSigna_ML_lFRM_FRC::CSigna_ML_lFRM_FRC(void) : m_pattern_6(50),
   m_pattern_9(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__66_6, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__66_9, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSigna_ML_lFRM_FRC::~CSigna_ML_lFRM_FRC(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSigna_ML_lFRM_FRC::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const long _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const long _in_shape[] = {1, 1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSigna_ML_lFRM_FRC::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_frm)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_frm.Create(m_symbol.Name(), m_period, 14, 0, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_frm_d1.Create(m_symbol.Name(), PERIOD_D1, 14, 0, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_frc.Create(m_symbol.Name(), m_period, 14, MODE_SMA, VOLUME_TICK))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_frc_d1.Create(m_symbol.Name(), PERIOD_D1, 14, MODE_SMA, VOLUME_TICK))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSigna_ML_lFRM_FRC::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_9;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSigna_ML_lFRM_FRC::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_9;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSigna_ML_lFRM_FRC::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Close(X()) > FRM(X()) && Close(X() + 1) >  FRM(X() + 1) && Close(X() + 2) >  FRM(X() + 2) && FRC(X()) > 0.0 && FRC(X() + 1) <= 0.0 && FRC(X() + 2) >= 0.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Close(X()) < FRM(X()) && Close(X() + 1) <  FRM(X() + 1) && Close(X() + 2) <  FRM(X() + 2) && FRC(X()) < 0.0 && FRC(X() + 1) >= 0.0 && FRC(X() + 2) <= 0.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 9.                                             |
//+------------------------------------------------------------------+
bool CSigna_ML_lFRM_FRC::IsPattern_9(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Close(X()) > Close(X() + 1) && FRC(X()) > FRC(X() + 1) && FRM(X()) > FRM(X() + 1) && FRC(X()) > FRC(X() + 1) && FRM(X()) > FRM(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Close(X()) < Close(X() + 1) && FRC(X()) < FRC(X() + 1) && FRM(X()) < FRM(X() + 1) && FRC(X()) < FRC(X() + 1) && FRM(X()) < FRM(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network.                                            |
//+------------------------------------------------------------------+
double CSigna_ML_lFRM_FRC::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
