//+------------------------------------------------------------------+
//|                                             SignalML_DEM_ENV.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/64_0.onnx" as uchar __64_0[]
#resource "Python/64_1.onnx" as uchar __64_1[]
#resource "Python/64_5.onnx" as uchar __64_5[]
#resource "Python/64_6.onnx" as uchar __64_6[]
#resource "Python/64_7.onnx" as uchar __64_7[]
#resource "Python/64_8.onnx" as uchar __64_8[]
#define __PATTERNS 6
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with DeMarker and Envelopes Indicators.      |
//| Type=SignalAdvanced                                              |
//| Name=DeMarker and Envelopes Indicators                           |
//| ShortName=ML_DEM_ENV                                             |
//| Class=CSignal_ML_DEM_ENV                                         |
//| Page=signal_ma_sto                                               |
//| Parameter=Pattern_0,int,50,Pattern 0 [0...100]                   |
//| Parameter=Pattern_1,int,50,Pattern 1 [0...100]                   |
//| Parameter=Pattern_5,int,50,Pattern 5 [0...100]                   |
//| Parameter=Pattern_6,int,50,Pattern 6 [0...100]                   |
//| Parameter=Pattern_7,int,50,Pattern 7 [0...100]                   |
//| Parameter=Pattern_8,int,50,Pattern 8 [0...100]                   |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap [0...1023]   |
//| Parameter=PeriodUsed,int,14,Used Period [3...55]                 |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignal_ML_DEM_ENV.                                        |
//| Purpose: Class of generator of trade signals based on            |
//|          ML with ADX & CCI.                                      |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSignal_ML_DEM_ENV : public CExpertSignal
{
protected:
   CiDeMarker           m_dem;
   CiEnvelopes          m_env;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_1;      // model 1
   int               m_pattern_5;      // model 5
   int               m_pattern_6;      // model 6
   int               m_pattern_7;      // model 7
   int               m_pattern_8;      // model 8

   int               m_periods;
   //
   //int               m_patterns_usage;   //

public:
   CSignal_ML_DEM_ENV(void);
   ~CSignal_ML_DEM_ENV(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   void              PeriodUsed(int value)
   {  m_periods = value;
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitDEM_ENV(CIndicators *indicators);
   //--- methods of getting data
   double            DEM(int ind)
   {  //
      m_dem.Refresh(-1);
      return(m_dem.Main(ind));
   }
   double            ENV_UP(int ind)
   {  //
      m_env.Refresh(-1);
      return(m_env.Upper(ind));
   }
   double            ENV_MID(int ind)
   {  //
      m_env.Refresh(-1);
      return(0.5 * (m_env.Lower(ind) + m_env.Upper(ind)));
   }
   double            ENV_LW(int ind)
   {  //
      m_env.Refresh(-1);
      return(m_env.Lower(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   double              Supervise(int Index, ENUM_POSITION_TYPE T);
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
   bool              IsPattern_8(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignal_ML_DEM_ENV::CSignal_ML_DEM_ENV(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50),
   m_pattern_8(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__64_0, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__64_1, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__64_5, ONNX_DEFAULT);
   m_handles[3] = OnnxCreateFromBuffer(__64_6, ONNX_DEFAULT);
   m_handles[4] = OnnxCreateFromBuffer(__64_7, ONNX_DEFAULT);
   m_handles[5] = OnnxCreateFromBuffer(__64_8, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignal_ML_DEM_ENV::~CSignal_ML_DEM_ENV(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const long _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const long _in_shape[] = {1, 1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      const long _cast_1_shape[] = {};
      if(!OnnxSetInputShape(m_handles[i], 1, _cast_1_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitDEM_ENV(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::InitDEM_ENV(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_dem)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_dem.Create(m_symbol.Name(), m_period, m_periods))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_env)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!m_env.Create(m_symbol.Name(), m_period, m_periods, 0, MODE_SMA, PRICE_CLOSE, 0.1))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignal_ML_DEM_ENV::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_0;
         results++;
      }
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_1;
         results++;
      }
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_5;
         results++;
      }
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_7;
         results++;
      }
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_8;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignal_ML_DEM_ENV::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_0;
         results++;
      }
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_1;
         results++;
      }
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_5;
         results++;
      }
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_7;
         results++;
      }
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_SELL))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_8;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_0(ENUM_POSITION_TYPE T)
{  if(Close(X()) > ENV_LW(X()) && Close(X() + 1) <= ENV_LW(X() + 1) && Close(X() + 2) >= ENV_LW(X() + 2))
   {  if(T == POSITION_TYPE_BUY && DEM(X()) <= 0.3)
      {  return(true);
      }
   }
   else if(Close(X()) < ENV_UP(X()) && Close(X() + 1) >=  ENV_UP(X() + 1) && Close(X() + 2) <= ENV_UP(X() + 2))
   {  if(T == POSITION_TYPE_SELL && DEM(X()) >= 0.7)
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_1(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) >= 0.7 && Close(X()) > ENV_UP(X()) && Close(X() + 1) > ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) <= 0.3 && Close(X()) < ENV_LW(X()) && Close(X() + 1) < ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.7 && ENV_UP(X()) > ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.3 && ENV_LW(X()) < ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > DEM(X() + 1) && Low(X()) > ENV_LW(X()) && Low(X() + 1) <= ENV_LW(X() + 1) && Low(X() + 2) >= ENV_LW(X() + 2) && Low(X() + 3) <= ENV_LW(X() + 3) && Low(X() + 4) >= ENV_LW(X() + 4))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < DEM(X() + 1) && High(X()) < ENV_UP(X()) && High(X() + 1) >= ENV_UP(X() + 1) && High(X() + 2) <= ENV_UP(X() + 2) && High(X() + 3) >= ENV_UP(X() + 3) && High(X() + 4) <= ENV_UP(X() + 4))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_7(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) >= 0.5 && DEM(X() + 2) <= 0.3 && Close(X()) > ENV_UP(X()) && Close(X() + 1) <= ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) <= 0.5 && DEM(X() + 2) >= 0.8 && Close(X()) < ENV_LW(X()) && Close(X() + 1) >= ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 8.                                             |
//+------------------------------------------------------------------+
bool CSignal_ML_DEM_ENV::IsPattern_8(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.7 && Low(X()) > ENV_UP(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.3 && High(X()) < ENV_LW(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network.                                            |
//+------------------------------------------------------------------+
double CSignal_ML_DEM_ENV::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   vector _cast_1(1);
   _cast_1.Fill(1.0);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _cast_1, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
