//+------------------------------------------------------------------+
//|                                                SignalDEM_ENV.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of DeMarker and Envelopes Indicators.              |
//| Type=SignalAdvanced                                              |
//| Name=DeMarker and Envelopes Indicators                           |
//| ShortName=DEM_ENV                                                |
//| Class=CSignalDEM_ENV                                             |
//| Page=signal_dem_env                                              |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_7,int,50,Pattern 7                             |
//| Parameter=Pattern_8,int,50,Pattern 8                             |
//| Parameter=Pattern_9,int,50,Pattern 9                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalDEM_ENV.                                            |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of DeMarker and Envelopes Indicators.           |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSignalDEM_ENV : public CExpertSignal
{
protected:
   CiDeMarker        m_dem;
   CiEnvelopes       m_env;
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_1;      // model 1
   int               m_pattern_2;      // model 2
   int               m_pattern_3;      // model 3
   int               m_pattern_4;      // model 4
   int               m_pattern_5;      // model 5
   int               m_pattern_6;      // model 6
   int               m_pattern_7;      // model 7
   int               m_pattern_8;      // model 8
   int               m_pattern_9;      // model 9
   //
   //int               m_patterns_usage;   //

public:
   CSignalDEM_ENV(void);
   ~CSignalDEM_ENV(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitDEM_ENV(CIndicators *indicators);
   //--- methods of getting data
   double            DEM(int ind)
   {  //
      m_dem.Refresh(-1);
      return(m_dem.Main(ind));
   }
   double            ENV_UP(int ind)
   {  //
      m_env.Refresh(-1);
      return(m_env.Upper(ind));
   }
   double            ENV_MID(int ind)
   {  //
      m_env.Refresh(-1);
      return(0.5 * (m_env.Lower(ind) + m_env.Upper(ind)));
   }
   double            ENV_LW(int ind)
   {  //
      m_env.Refresh(-1);
      return(m_env.Lower(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   long              Volume(int ind)
   {  //
      m_tick_volume.Refresh(-1);
      return(m_tick_volume.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
   bool              IsPattern_8(ENUM_POSITION_TYPE T);
   bool              IsPattern_9(ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalDEM_ENV::CSignalDEM_ENV(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50),
   m_pattern_8(50),
   m_pattern_9(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalDEM_ENV::~CSignalDEM_ENV(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitDEM_ENV(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::InitDEM_ENV(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_dem)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_dem.Create(m_symbol.Name(), m_period, 14))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_env.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_CLOSE, 0.1))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalDEM_ENV::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_BUY))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_BUY))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalDEM_ENV::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_SELL))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_SELL))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_0(ENUM_POSITION_TYPE T)
{  if(Close(X()) > ENV_LW(X()) && Close(X() + 1) <= ENV_LW(X() + 1) && Close(X() + 2) >= ENV_LW(X() + 2))
   {  if(T == POSITION_TYPE_BUY && DEM(X()) <= 0.3)
      {  return(true);
      }
   }
   else if(Close(X()) < ENV_UP(X()) && Close(X() + 1) >=  ENV_UP(X() + 1) && Close(X() + 2) <= ENV_UP(X() + 2))
   {  if(T == POSITION_TYPE_SELL && DEM(X()) >= 0.7)
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_1(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) >= 0.7 && Close(X()) > ENV_UP(X()) && Close(X() + 1) > ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) <= 0.3 && Close(X()) < ENV_LW(X()) && Close(X() + 1) < ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > DEM(X() + 1) && Low(X()) <= ENV_LW(X()) && Low(X() + 1) > ENV_LW(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < DEM(X() + 1) && High(X()) >= ENV_UP(X()) && High(X() + 1) < ENV_UP(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_3(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.5 && DEM(X() + 1) < 0.5 && Close(X()) < ENV_MID(X()) && Close(X() + 1) > ENV_MID(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.5 && DEM(X() + 1) > 0.5 && Close(X()) > ENV_MID(X()) && Close(X() + 1) < ENV_MID(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_4(ENUM_POSITION_TYPE T)
{  if(ENV_UP(X() + 1) - ENV_LW(X() + 1) > ENV_UP(X()) - ENV_LW(X()))
   {  if(T == POSITION_TYPE_BUY && DEM(X() + 1) >= 0.4 && DEM(X()) <= 0.6 && DEM(X() + 1) < DEM(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && DEM(X() + 1) <= 0.6 && DEM(X()) >= 0.4 && DEM(X() + 1) > DEM(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.7 && ENV_UP(X()) > ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.3 && ENV_LW(X()) < ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > DEM(X() + 1) && Low(X()) > ENV_LW(X()) && Low(X() + 1) <= ENV_LW(X() + 1) && Low(X() + 2) >= ENV_LW(X() + 2) && Low(X() + 3) <= ENV_LW(X() + 3) && Low(X() + 4) >= ENV_LW(X() + 4))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < DEM(X() + 1) && High(X()) < ENV_UP(X()) && High(X() + 1) >= ENV_UP(X() + 1) && High(X() + 2) <= ENV_UP(X() + 2) && High(X() + 3) >= ENV_UP(X() + 3) && High(X() + 4) <= ENV_UP(X() + 4))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_7(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) >= 0.5 && DEM(X() + 2) <= 0.3 && Close(X()) > ENV_UP(X()) && Close(X() + 1) <= ENV_UP(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) <= 0.5 && DEM(X() + 2) >= 0.8 && Close(X()) < ENV_LW(X()) && Close(X() + 1) >= ENV_LW(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 8.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_8(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.7 && Low(X()) > ENV_UP(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.3 && High(X()) < ENV_LW(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 9.                                             |
//+------------------------------------------------------------------+
bool CSignalDEM_ENV::IsPattern_9(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && DEM(X()) > 0.5 && DEM(X() + 1) < 0.5 && ENV_UP(X()) > ENV_UP(X() + 1) && ENV_UP(X() + 1) > ENV_UP(X() + 2))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && DEM(X()) < 0.5 && DEM(X() + 1) > 0.5 && ENV_LW(X()) < ENV_LW(X() + 1) && ENV_LW(X() + 1) < ENV_LW(X() + 2))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
