//+------------------------------------------------------------------+
//|                                       Correlation Pathfinder.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict

//--- Adjustable Inputs
input string   pythonUrl       = "http://127.0.0.1:5000/analyze"; // Python server endpoint
input int      timeout         = 50000;                          // Timeout in milliseconds
input int      signalInterval  = 60;                             // Interval (in seconds) between updates

//--- Data Settings
input string   Symbol1         = "EURUSD";
input string   Symbol2         = "GBPUSD";
input ENUM_TIMEFRAMES TimeFrame  = PERIOD_M15;
input int      BarsToExport    = 500;   // Number of bars to export

// Global variable to track last update time
datetime lastUpdateTime = 0;

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   if(TimeCurrent() - lastUpdateTime < signalInterval)
      return;
   lastUpdateTime = TimeCurrent();

   string jsonPayload = BuildJSONPayload();
   if(jsonPayload == "")
     {
      Print("Failed to build JSON payload.");
      return;
     }

   uchar requestData[];
   int converted = StringToCharArray(jsonPayload, requestData);
   if(converted <= 0)
     {
      Print("Failed to convert JSON payload to uchar array.");
      return;
     }

   string requestHeaders = "Content-Type: application/json\r\n";
   uchar result[];
   string responseHeaders;
   int webRequestResult = WebRequest("POST", pythonUrl, requestHeaders, timeout, requestData, result, responseHeaders);
   if(webRequestResult == -1)
     {
      Print("Error in WebRequest. Error code = ", GetLastError());
      return;
     }

   string response = CharArrayToString(result);
   Print("Server response: ", response);
  }

//+------------------------------------------------------------------+
//| BuildJSONPayload: Constructs a JSON string with historical data  |
//+------------------------------------------------------------------+
string BuildJSONPayload()
  {
   string json = "{";
   json += "\"symbol1\":\"" + Symbol1 + "\",";
   json += "\"symbol2\":\"" + Symbol2 + "\",";

   MqlRates rates1[];
   if(CopyRates(Symbol1, TimeFrame, 0, BarsToExport, rates1) <= 0)
     {
      Print("Failed to copy rates for ", Symbol1);
      return "";
     }
   ArraySetAsSeries(rates1, true);
   json += "\"data1\":[";
   for(int i = 0; i < ArraySize(rates1); i++)
     {
      string timeStr = TimeToString(rates1[i].time, TIME_DATE | TIME_SECONDS);
      json += "{\"time\":\"" + timeStr + "\",\"close\":" + DoubleToString(rates1[i].close, 5) + "}";
      if(i < ArraySize(rates1) - 1)
         json += ",";
     }
   json += "],";

   MqlRates rates2[];
   if(CopyRates(Symbol2, TimeFrame, 0, BarsToExport, rates2) <= 0)
     {
      Print("Failed to copy rates for ", Symbol2);
      return "";
     }
   ArraySetAsSeries(rates2, true);
   json += "\"data2\":[";
   for(int j = 0; j < ArraySize(rates2); j++)
     {
      string timeStr = TimeToString(rates2[j].time, TIME_DATE | TIME_SECONDS);
      json += "{\"time\":\"" + timeStr + "\",\"close\":" + DoubleToString(rates2[j].close, 5) + "}";
      if(j < ArraySize(rates2) - 1)
         json += ",";
     }
   json += "]";
   json += "}";
   return json;
  }
//+------------------------------------------------------------------+
