//+------------------------------------------------------------------+
//|                                                 SignalMA_STO.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <SRI\57_X.mqh>
#resource "Python/57_0.onnx" as uchar __57_0[]
#resource "Python/57_1.onnx" as uchar __57_1[]
#resource "Python/57_2.onnx" as uchar __57_2[]
#resource "Python/57_3.onnx" as uchar __57_3[]
#resource "Python/57_4.onnx" as uchar __57_4[]
#resource "Python/57_5.onnx" as uchar __57_5[]
#resource "Python/57_6.onnx" as uchar __57_6[]
#resource "Python/57_7.onnx" as uchar __57_7[]
#resource "Python/57_8.onnx" as uchar __57_8[]
#resource "Python/57_9.onnx" as uchar __57_9[]
int __IN_SHAPES[10] = {  4, 4, 4, 6, 4, 4, 4, 4, 4, 4 };
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of Supervised Learning with MA & Stochastic.       |
//| Type=SignalAdvanced                                              |
//| Name=MA_STO                                                      |
//| ShortName=MA_STO                                                 |
//| Class=CSignal_MA_STO                                             |
//| Page=signal_ma_sto                                               |
//| Parameter=Pattern_0,int,50,Pattern 0 [0...100]                   |
//| Parameter=Pattern_1,int,50,Pattern 1 [0...100]                   |
//| Parameter=Pattern_2,int,50,Pattern 2 [0...100]                   |
//| Parameter=Pattern_3,int,50,Pattern 3 [0...100]                   |
//| Parameter=Pattern_4,int,50,Pattern 4 [0...100]                   |
//| Parameter=Pattern_5,int,50,Pattern 5 [0...100]                   |
//| Parameter=Pattern_6,int,50,Pattern 6 [0...100]                   |
//| Parameter=Pattern_7,int,50,Pattern 7 [0...100]                   |
//| Parameter=Pattern_8,int,50,Pattern 8 [0...100]                   |
//| Parameter=Pattern_9,int,50,Pattern 9 [0...100]                   |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap [0...1023]   |
//| Parameter=PeriodUsed,int,5,Used Period [3...55]                  |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignal_MA_STO.                                            |
//| Purpose: Class of generator of trade signals based on            |
//|          Supervised Learning with MA & Stochastic.               |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSignal_MA_STO : public CExpertSignal
{
protected:
   CiMA              m_ma, m_ma_lag;
   CiStochastic      m_sto;

   long              m_handles[10];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_1;      // model 1
   int               m_pattern_2;      // model 2
   int               m_pattern_3;      // model 3
   int               m_pattern_4;      // model 4
   int               m_pattern_5;      // model 5
   int               m_pattern_6;      // model 6
   int               m_pattern_7;      // model 7
   int               m_pattern_8;      // model 8
   int               m_pattern_9;      // model 9

   int               m_periods;
   //
   //int               m_patterns_usage;   //

public:
   CSignal_MA_STO(void);
   ~CSignal_MA_STO(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   void              PeriodUsed(int value)
   {  m_periods = value;
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitIndicator(CIndicators *indicators);
   //--- methods of getting data
   double            MA(int ind)
   {  //
      m_ma.Refresh(-1);
      return(m_ma.Main(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   double              IsPattern(int Index, ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignal_MA_STO::CSignal_MA_STO(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50),
   m_pattern_8(50),
   m_pattern_9(50)
   //m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_CLOSE + USE_SERIES_TIME;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__57_0, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__57_1, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__57_2, ONNX_DEFAULT);
   m_handles[3] = OnnxCreateFromBuffer(__57_3, ONNX_DEFAULT);
   m_handles[4] = OnnxCreateFromBuffer(__57_4, ONNX_DEFAULT);
   m_handles[5] = OnnxCreateFromBuffer(__57_5, ONNX_DEFAULT);
   m_handles[6] = OnnxCreateFromBuffer(__57_6, ONNX_DEFAULT);
   m_handles[7] = OnnxCreateFromBuffer(__57_7, ONNX_DEFAULT);
   m_handles[8] = OnnxCreateFromBuffer(__57_8, ONNX_DEFAULT);
   m_handles[9] = OnnxCreateFromBuffer(__57_9, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignal_MA_STO::~CSignal_MA_STO(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignal_MA_STO::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const long _out_shape[] = {1, 1, 1};
   for(int i = 0; i < 10; i++)
   {  // Set input shapes
      const long _in_shape[] = {1, 1, __IN_SHAPES[i]};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError());
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError());
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignal_MA_STO::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitIndicator(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignal_MA_STO::InitIndicator(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_ma)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ma.Create(m_symbol.Name(), m_period, m_periods, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_ma_lag)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ma_lag.Create(m_symbol.Name(), m_period, 2*m_periods, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   
   if(!indicators.Add(GetPointer(m_sto)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!m_sto.Create(m_symbol.Name(), m_period, m_periods, 3, 3, MODE_EMA, STO_CLOSECLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignal_MA_STO::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used"
   double _0_buy = IsPattern(0, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x01) != 0)
   {  result += int(round(m_pattern_0 * _0_buy));
      results++;
   }
//--- if the model 1 is used"
   double _1_buy = IsPattern(1, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x02) != 0)
   {  result += int(round(m_pattern_1 * _1_buy));
      results++;
   }
//--- if the model 2 is used"
   double _2_buy = IsPattern(2, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x04) != 0)
   {  result += int(round(m_pattern_2 * _2_buy));
      results++;
   }
//--- if the model 3 is used"
   double _3_buy = IsPattern(3, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x08) != 0)
   {  result += int(round(m_pattern_3 * _3_buy));
      results++;
   }
//--- if the model 4 is used"
   double _4_buy = IsPattern(4, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x10) != 0)
   {  result += int(round(m_pattern_4 * _4_buy));
      results++;
   }
//--- if the model 5 is used"
   double _5_buy = IsPattern(5, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x20) != 0)
   {  result += int(round(m_pattern_5 * _5_buy));
      results++;
   }
//--- if the model 6 is used"
   double _6_buy = IsPattern(6, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x40) != 0)
   {  result += int(round(m_pattern_6 * _6_buy));
      results++;
   }
//--- if the model 7 is used"
   double _7_buy = IsPattern(7, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x80) != 0)
   {  result += int(round(m_pattern_7 * _7_buy));
      results++;
   }
//--- if the model 8 is used"
   double _8_buy = IsPattern(8, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x100) != 0)
   {  result += int(round(m_pattern_8 * _8_buy));
      results++;
   }
//--- if the model 9 is used"
   double _9_buy = IsPattern(9, POSITION_TYPE_BUY);
   if((m_patterns_usage & 0x200) != 0)
   {  result += int(round(m_pattern_9 * _9_buy));
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignal_MA_STO::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used"
   double _0_sell = IsPattern(0, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x01) != 0)
   {  result += int(round(m_pattern_0 * _0_sell));
      results++;
   }
//--- if the model 1 is used"
   double _1_sell = IsPattern(1, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x02) != 0)
   {  result += int(round(m_pattern_1 * _1_sell));
      results++;
   }
//--- if the model 2 is used"
   double _2_sell = IsPattern(2, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x04) != 0)
   {  result += int(round(m_pattern_2 * _2_sell));
      results++;
   }
//--- if the model 3 is used"
   double _3_sell = IsPattern(3, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x08) != 0)
   {  result += int(round(m_pattern_3 * _3_sell));
      results++;
   }
//--- if the model 4 is used"
   double _4_sell = IsPattern(4, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x10) != 0)
   {  result += int(round(m_pattern_4 * _4_sell));
      results++;
   }
//--- if the model 5 is used"
   double _5_sell = IsPattern(5, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x20) != 0)
   {  result += int(round(m_pattern_5 * _5_sell));
      results++;
   }
//--- if the model 6 is used"
   double _6_sell = IsPattern(6, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x40) != 0)
   {  result += int(round(m_pattern_6 * _6_sell));
      results++;
   }
//--- if the model 7 is used"
   double _7_sell = IsPattern(7, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x80) != 0)
   {  result += int(round(m_pattern_7 * _7_sell));
      results++;
   }
//--- if the model 8 is used"
   double _8_sell = IsPattern(8, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x100) != 0)
   {  result += int(round(m_pattern_8 * _8_sell));
      results++;
   }
//--- if the model 9 is used"
   double _9_sell = IsPattern(9, POSITION_TYPE_SELL);
   if((m_patterns_usage & 0x200) != 0)
   {  result += int(round(m_pattern_9 * _9_sell));
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern.                                               |
//+------------------------------------------------------------------+
double CSignal_MA_STO::IsPattern(int Index, ENUM_POSITION_TYPE T)
{  vectorf _x = Get(Index, m_time.GetData(X()), m_close, m_ma, m_ma_lag, m_sto);
   vectorf _y(1);
   _y.Fill(0.0);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, _x, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   //printf(__FUNCSIG__+" y: "+DoubleToString(_y[0],2));
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
