//+------------------------------------------------------------------+
//|                                                    SignalMFI.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of Bill-Williams Market Facilitation Index.        |
//| Type=SignalAdvanced                                              |
//| Name=MFI                                                         |
//| ShortName=MFI                                                    |
//| Class=CSignalMFI                                                 |
//| Page=signal_mfi                                                  |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_7,int,50,Pattern 7                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalMFI.                                                |
//| Purpose: Class of generator of trade signals based on            |
//|          Bill-Williams MFI oscillator Patterns.                  |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSignalMFI : public CExpertSignal
{
protected:
   CiMFI             m_mfi;
   CiMA              m_ma;
   CiRSI             m_rsi;
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0 "Green Signal"
   int               m_pattern_1;      // model 1 "Fade Signal"
   int               m_pattern_2;      // model 2 "Fake Signal"
   int               m_pattern_3;      // model 3 "Squat Signal"
   int               m_pattern_4;      // model 4 "Divergence Pattern"
   int               m_pattern_5;      // model 5 "Breakout Signal"
   int               m_pattern_6;      // model 6 "Trend Continuation"
   int               m_pattern_7;      // model 8 "Range Trading Setup"
   //
   //int               m_patterns_usage;   //

public:
   CSignalMFI(void);
   ~CSignalMFI(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitMFI(CIndicators *indicators);
   //--- methods of getting data
   double            MFI(int ind)
   {  //
      m_mfi.Refresh(-1);
      return(m_mfi.Main(ind));
   }
   //
   color             Color(int ind)
   {  //
      return(
               (Volume(ind) > Volume(ind + 1) && MFI(ind) > MFI(ind + 1)) ? clrGreen :
               ((Volume(ind) < Volume(ind + 1) && MFI(ind) < MFI(ind + 1)) ? clrBrown :
                ((Volume(ind) < Volume(ind + 1) && MFI(ind) > MFI(ind + 1)) ? clrBlue :
                 ((Volume(ind) > Volume(ind + 1) && MFI(ind) < MFI(ind + 1)) ? clrPink : clrNONE
                 ))));
   }
   //
   double            MA(int ind)
   {  //
      m_ma.Refresh(-1);
      return(m_ma.Main(ind));
   }
   double            RSI(int ind)
   {  //
      m_rsi.Refresh(-1);
      return(m_rsi.Main(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   long            Volume(int ind)
   {  //
      m_tick_volume.Refresh(-1);
      return(m_tick_volume.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalMFI::CSignalMFI(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50)
   //m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalMFI::~CSignalMFI(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalMFI::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalMFI::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitMFI(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalMFI::InitMFI(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_mfi)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_mfi.Create(m_symbol.Name(), m_period, 8, VOLUME_TICK))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_ma.Create(m_symbol.Name(), m_period, 8, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_rsi.Create(m_symbol.Name(), m_period, 8, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalMFI::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used and "Green Signal"
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used and "Fade Signal"
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used and "Fake Signal"
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used and "Squat Signal"
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used and "Divergence Pattern"
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used and "Breakout Signal"
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used and "Trend Continuation"
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used and "Range Trading Setup"
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  result += m_pattern_7;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalMFI::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used and "Green Signal"
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used and "Fade Signal"
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used and "Fake Signal"
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used and "Squat Signal"
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used and "Divergence Pattern"
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used and "Breakout Signal"
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used and "Trend Continuation"
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used and "Range Trading Setup"
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  result += m_pattern_7;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_0(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrGreen)
   {  if(T == POSITION_TYPE_BUY && Close(X()) > MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()) < MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_1(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrPink)
   {  if(T == POSITION_TYPE_BUY && Close(X()) < MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()) > MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrBlue)
   {  if(T == POSITION_TYPE_BUY && Close(X()) < MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()) > MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_3(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrBrown)
   {  if(T == POSITION_TYPE_BUY && Close(X()+1) <= MA(X()+1) && Close(X()) >= MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()+1) >= MA(X()+1) && Close(X()) <= MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_4(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Low(X()+1) > Low(X()) && MFI(X()+1) > MFI(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && High(X()+1) < High(X()) && MFI(X()+1) > MFI(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrGreen)
   {  if(T == POSITION_TYPE_BUY && Close(X()+1) < MA(X()+1) && Close(X()) > MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()+1) > MA(X()+1) && Close(X()) < MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(Color(X()+1) == clrGreen && Color(X()) == clrGreen)
   {  if(T == POSITION_TYPE_BUY && Close(X()+1) > MA(X()+1) && Close(X()) > MA(X()))
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && Close(X()+1) < MA(X()+1) && Close(X()) < MA(X()))
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             |
//+------------------------------------------------------------------+
bool CSignalMFI::IsPattern_7(ENUM_POSITION_TYPE T)
{  if(Color(X()) == clrBrown)
   {  if(T == POSITION_TYPE_BUY && RSI(X()+1) <= 30.0 && RSI(X()) >= 30.0)
      {  return(true);
      }
      else if(T == POSITION_TYPE_SELL && RSI(X()+1) >= 70.0 && RSI(X()) <= 70.0)
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
