//+------------------------------------------------------------------+
//|                                                       MQL5EA.mq5 |
//|                                                       crownsoyin |
//|                                             crownsoyin@gmail.com |
//+------------------------------------------------------------------+
#property copyright "crownsoyin"
#property link      "crownsoyin@gmail.com"
#property version   "1.00"
#include <Trade/Trade.mqh> // Include the trade library for trading functions

// Create an instance of the CTrade class for trading operations
CTrade trade;

// Flag to indicate a new bar has formed
bool newBar;

// Variable to store the time of the last bar
datetime lastBarTime;

// Array to store bar data (OHLC)
MqlRates bar[];

// Unique identifier for the EA's trades
int MagicNumber = 103432;

// Arrays to store the previous day's open and close prices
double daily_close[];
double daily_open[];

// Arrays to store the first H1 bar's open and close prices of the day
double first_h1_price_close[];

// Arrays to store H1 bars' open and close prices
double H1_price_close[];
double H1_price_open[];

// Strings to define the trading start and end times and the first trade time
string start = "00:00";
string end = "20:00";
string firsttrade  = "02:00";

// User-defined input for lot size
input double lotsize = 0; // Specify your lotsize



//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
// Set the magic number for the EA's trades
   trade.SetExpertMagicNumber(MagicNumber);

// Return initialization success
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {

// Convert time strings to datetime format
   datetime start_time = StringToTime(start); // Convert start time string to datetime
   datetime end_time = StringToTime(end); // Convert end time string to datetime
   datetime current_time = TimeCurrent(); // Get the current time
   datetime first_tradetime = StringToTime(firsttrade); // Convert first trade time string to datetime
   
// Copy daily close and open prices
   CopyClose(_Symbol, PERIOD_D1, 1, 1, daily_close); // Copy the close price of the previous day
   CopyOpen(_Symbol, PERIOD_D1, 1, 1, daily_open); // Copy the open price of the previous day


// Set the arrays to be copied from right to left (latest to oldest)
   ArraySetAsSeries(daily_close, true); // Set daily_close array as series
   ArraySetAsSeries(daily_open, true);  // Set daily_open array as series

// Copy close and open prices for the first H1 bar of the day
   CopyClose(_Symbol, PERIOD_H1, start_time, 1, first_h1_price_close); // Copy the close price of the first H1 bar

// Copy close prices for the latest 5 H1 bars
   CopyClose(_Symbol, PERIOD_H1, 0, 5, H1_price_close); // Copy the close prices of the latest 5 H1 bars
   CopyOpen(_Symbol, PERIOD_H1, 0, 5, H1_price_open); // Copy the open prices of the latest 5 H1 bars

// Set the arrays to be copied from right to left (latest to oldest)
   ArraySetAsSeries(H1_price_close, true); // Set H1_price_close array as series
   ArraySetAsSeries(H1_price_open, true); // Set H1_price_open array as series

// Select the trading history within the specified time range
   bool success = HistorySelect(start_time, end_time); // Select the trading history

// Initialize the total number of trades for the day
   int totalDeal = 0;
   if(success)
     {
      for(int i = 0; i < HistoryDealsTotal(); i++)
        {
         // Get the ticket number for the deal
         ulong ticket = HistoryDealGetTicket(i);

         // Check if the deal's magic number matches
         if(HistoryDealGetInteger(ticket, DEAL_MAGIC) == MagicNumber)
           {
            // Check if the deal was an entry
            if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_IN)
              {
               // Increment the total deal count
               totalDeal++;
              }
           }
        }
     }

// Initialize the total number of positions being held
   int totalPositions = 0;
   for(int i = 0; i < PositionsTotal(); i++)
     {
      // Get the ticket number for the position
      ulong ticket = PositionGetTicket(i);

      // Check if the position's magic number matches
      if(PositionGetInteger(POSITION_MAGIC) == MagicNumber)
        {
         // Increment the total positions count
         totalPositions++;
        }
     }

// Initialize the total profit
   double totalProfit = 0;
   long dealsMagic = 0;
   double profit = 0;
   if(success)
     {
      for(int i = 0; i < HistoryDealsTotal(); i++)
        {
         // Get the ticket number for the deal
         ulong ticket = HistoryDealGetTicket(i);

         // Check if the deal was an entry
         if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_IN)
           {
            // Get the magic number of the deal
            dealsMagic = HistoryDealGetInteger(ticket, DEAL_MAGIC);
           }

         // Check if the deal was an exit
         if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_OUT)
           {
            // Get the profit of the deal
            profit = HistoryDealGetDouble(ticket, DEAL_PROFIT);

            // Check if the magic number matches
            if(MagicNumber == dealsMagic)
              {
               // Add the profit to the total profit
               totalProfit += profit;
              }
           }
        }
     }

//getting the day of week and month
   MqlDateTime day; //Declare an MqlDateTime structure to hold the current time and date
   TimeCurrent(day); // Get the current time and fill the MqlDateTime structure
   int week_day = day.day_of_week; //Extract the day of the week (0 = Sunday, 1 = Monday, ..., 6 = Saturday)

//getting the current month
   MqlDateTime month; //Declare a structure to hold current month information
   TimeCurrent(month); //Get the current date and time
   int year_month = month.mon; //Extract the month component (1 for January, 2 for February, ..., 12 for December)


   if(week_day == 5)
     {

      Comment("No trades on fridays", "\nday of week: ",week_day);

     }
   else if(week_day == 4)
        {

         Comment("No trades on Thursdays", "\nday of week: ",week_day);

        }
      else
        {

         Comment(week_day);

        }


// Get the symbol point size
   double symbol_point = SymbolInfoDouble(_Symbol, SYMBOL_POINT); // Get the point size of the symbol

// Check for a new bar
   CopyRates(_Symbol, PERIOD_H1, 0, 3, bar); // Copy the latest 3 H1 bars
   if(bar[0].time > lastBarTime)  // Check if the latest bar time is greater than the last recorded bar time
     {
      newBar = true; // Set the newBar flag to true
      lastBarTime = bar[0].time; // Update the last bar time
     }
   else
     {
      newBar = false; // Set the newBar flag to false
     }

// If a new bar has formed
   if(newBar == true)
     {
      // Check if conditions are met for trading
      if(totalPositions < 1 && totalDeal < 2 && totalProfit < 1)
        {
         // If the last daily bar is bearish
         if(daily_close[0] < daily_open[0])
           {
            // Check specific conditions for a sell trade
            if(H1_price_close[2] >= first_h1_price_close[0] && H1_price_close[1] < first_h1_price_close[0] && current_time >= first_tradetime)
              {
               // Get the current Bid price
               double Bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);

               // Calculate the take profit price
               double tp = Bid - 400 * symbol_point;

               // Calculate the stop loss price
               double sl = Bid + 100 * symbol_point;

               // Ensure trades are not made on Thursdays and Fridays
               if(week_day < 4 || week_day > 5)
                 {
                  // Execute the sell trade
                  trade.Sell(lotsize, _Symbol, Bid, sl, tp);
                 }
              }
           }

         // If the last daily bar is bullish
         if(daily_close[0] > daily_open[0])
           {
            // Check specific conditions for a buy trade
            if(H1_price_close[2] <= first_h1_price_close[0] && H1_price_close[1] > first_h1_price_close[0] && current_time >= first_tradetime)
              {
               // Get the current Ask price
               double Ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);

               // Calculate the take profit price
               double tp = Ask + 400 * symbol_point;

               // Calculate the stop loss price
               double sl = Ask - 100 * symbol_point;

               // Ensure trades are not made on Thursdays and Fridays
               if(week_day < 4 || week_day > 5)
                 {
                  // Execute the buy trade
                  trade.Buy(lotsize, _Symbol, Ask, sl, tp);
                 }
              }
           }
        }
     }

// Close trades at the specified end time
   for(int i = 0; i < PositionsTotal(); i++)
     {
      // Get the ticket number for the position
      ulong ticket = PositionGetTicket(i);

      // Check if the position's magic number matches and if it's the end time
      if(PositionGetInteger(POSITION_MAGIC) == MagicNumber && current_time == end_time)
        {
         // Close the position
         trade.PositionClose(ticket);
        }
     }
  }
