//Version  April 2, 2008
//+X================================================================X+
//|                                                   TestReport.mqh |
//|                             Copyright  2008,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
//----     
extern datetime Start_Time = D'2007.01.01'; //    
                                                        //
extern int Opt_Period = 3; //    ,  
   //   ,      
extern int Test_Period = 2; //    
extern int Period_Shift = 1; //     
                                                             //
extern int Opt_Number = 0; //   
//+X================================================================X+
//| IsBackTestingTime()                                              |
//+X================================================================X+
bool IsBackTestingTime()
 {
//----+
  //----    
  static datetime OptStart_Time, OptEnd_Time, TestEnd_Time;
  //----    
  static bool SecondStart;
  
  if (!SecondStart)
   {
    //----+      
    if (Opt_Period > 0)
     {  
      //----+    
      int newmonth, newyear;
      string StartTime, OptDay; 
      //---
      StartTime = TimeToStr(Start_Time, TIME_DATE);
      OptDay = 
         StringSubstr(StartTime, 8, 9);
      newyear = 
         StrToInteger(StringSubstr(StartTime, 0, 4));
      newmonth = 
         StrToInteger(StringSubstr(StartTime, 5, 6));
      //---
      newmonth += Opt_Number * Period_Shift;
      OptStart_Time = 
               CountTime(newmonth, newyear, OptDay);     
      //----
      newmonth += MathAbs(Opt_Period);                      
      OptEnd_Time = 
               CountTime(newmonth, newyear, OptDay);  
      //----
      newmonth += Test_Period;
      TestEnd_Time = 
               CountTime(newmonth, newyear, OptDay);
      SecondStart = true;
     } 
    //----+     
    if (Opt_Period < 0)
     {
      //----+    
      OptStart_Time = Start_Time + 
                    Opt_Number  * Period_Shift * 3600 * 24;
      OptEnd_Time = 
           OptStart_Time + MathAbs(Opt_Period) * 3600 * 24;
      TestEnd_Time = OptEnd_Time + Test_Period * 3600 * 24;
      SecondStart = true;
     }                               
   }           
  //----+    
  //----+ +--------------------------------------------------------+
  datetime TimeCar = TimeCurrent();   
  if (IsOptimization())
      if (TimeCar < OptStart_Time || TimeCar > OptEnd_Time)
                                                     return(false);
  if (!IsOptimization() && IsTesting())
      if (TimeCar < OptEnd_Time || TimeCar > TestEnd_Time)
                                                     return(false);
  //----+ +--------------------------------------------------------+
  return(true);
//----+
 }
//+X================================================================X+
//| CountTime() //    IsBackTestingTime()   |
//+X================================================================X+
datetime CountTime(int& newmonth, int&newyear, string OptDay)
 {
//----+
   string sResaltTime;
   datetime dResaltTime;
   //---
   if (newmonth > 12)
       {
         newyear +=  MathFloor(newmonth / 12.0);
         newmonth = MathMod(newmonth, 12); 
       }
      //---          
   if (newmonth > 9)
       sResaltTime = StringConcatenate
                    (newyear, ".", newmonth, ".", OptDay);
   else
     sResaltTime = StringConcatenate
                   (newyear, ".0", newmonth, ".", OptDay);
   //---                                
   dResaltTime = StrToTime(sResaltTime);
   return(dResaltTime);
//----+
 }
//+X================================================================X+
//| Read_Write_File.mqh                                              |
//+X================================================================X+
#include <Read_Write_File.mqh>
//+X================================================================X+ 
//| CountProfit() function                                           |
//+X================================================================X+
double CountProfit(int cmd)
  {
//----+
  double Profit;      
  int pos, Total = OrdersHistoryTotal();
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
    if (OrderType() == cmd || cmd < 0 || cmd > 1)
      if (OrderType() < 2)
           Profit += OrderProfit()
                    + OrderCommission() + OrderSwap(); 
   return(Profit);
//----+
  } 
//+X================================================================X+ 
//| CountMaxDrawdownPrs() function                                   |
//+X================================================================X+
double CountMaxDrawdownPrs(int cmd)
  {
//----+
  double MaxDepo, Profit, Depo;
  double MaxDrawdown, MaxDrawdownPr, Drawdown;
      
  int pos, Total = OrdersHistoryTotal();
  //----
  Depo = AccountBalance() - AccountProfit();
  MaxDepo = Depo;
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
     if (OrderType() == cmd || cmd < 0 || cmd > 1)
      if (OrderType() < 2)
       {
         Profit = OrderProfit() 
                    + OrderCommission()
                              + OrderSwap();
         Depo += Profit;
         if (Depo > MaxDepo)
                     MaxDepo = Depo;
                        
         Drawdown = MaxDepo - Depo;
         if (Drawdown > MaxDrawdown)
                  MaxDrawdown = Drawdown;
       }
  MaxDrawdownPr = 
             MaxDrawdown * 100 / MaxDepo;
             
  return(MaxDrawdownPr);
//----+
  }
//+X================================================================X+ 
//| CountMaxDrawdown() function                                      |
//+X================================================================X+
double CountMaxDrawdown(int cmd)
  {
//----+
  double MaxDepo, Profit, Depo;
  double MaxDrawdown, Drawdown;
      
  int pos, Total = OrdersHistoryTotal();
  //----
  Depo = AccountBalance() - AccountProfit();
  MaxDepo = Depo;
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
     if (OrderType() == cmd || cmd < 0 || cmd > 1)
      if (OrderType() < 2)
       {
         Profit = OrderProfit() 
                    + OrderCommission() 
                               + OrderSwap();
         if (Profit == 0)
                   continue;                    
         Depo += Profit;
         if (Depo > MaxDepo)
                     MaxDepo = Depo;
                        
         Drawdown = MaxDepo - Depo;
         if (Drawdown > MaxDrawdown)
                      MaxDrawdown = Drawdown;
       }
  return(MaxDrawdown);
//----+
  }
//+X================================================================X+ 
//| CountAbsDrawdown() function                                      |
//+X================================================================X+
double CountAbsDrawdown(int cmd)
  {
//----+
  double MinDepo, Profit, StartDepo;
  double AbsDrawdown, Depo;
      
  int pos, Total = OrdersHistoryTotal();
  //----
  StartDepo = AccountBalance() - AccountProfit();
  MinDepo = StartDepo;
  Depo = StartDepo;
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
     if (OrderType() == cmd || cmd < 0 || cmd > 1)
      if (OrderType() < 2)
       {
         Profit = OrderProfit() 
                    + OrderCommission()
                               + OrderSwap();
         if (Profit == 0)
                   continue; 
         Depo += Profit;
         if (Depo < MinDepo)
                     MinDepo = Depo;
       }
  AbsDrawdown = StartDepo - MinDepo;
  if (AbsDrawdown > 0)
         return(AbsDrawdown);
  else 
    return(0.0);
//----+
  }
//+X================================================================X+ 
//| CountProfitFactor() function                                     |
//+X================================================================X+
double CountProfitFactor(int cmd)
  {
//----+
  double Profit, GrossProfit, LossProfit, ProfitFactor;
      
  int pos, Total = OrdersHistoryTotal();
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
     if (OrderType() == cmd || cmd < 0 || cmd > 1)
       if (OrderType() < 2)
       {
         Profit = OrderProfit() 
                    + OrderCommission()
                                 + OrderSwap();
         if (Profit == 0)
                   continue; 
         if (Profit > 0)
              GrossProfit += Profit;
                        
         if (Profit < 0)
               LossProfit -= Profit;
       }
  if (LossProfit == 0)
               return(0.0); 
  else   
     ProfitFactor = GrossProfit / LossProfit;
  return(ProfitFactor);
//----+
  } 
//+X================================================================X+ 
//| CountProfitTrades() function                                     |
//+X================================================================X+
int CountProfitTrades(int cmd)
  {
//----+
  double Profit;
      
  int ProfitTradesSum, pos, Total = OrdersHistoryTotal();
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
     if (OrderType() == cmd || cmd < 0 || cmd > 1)
                 if (OrderType() < 2)
          {
           Profit = OrderProfit() 
                       + OrderCommission() 
                                 + OrderSwap();

           if (Profit > 0)
                   ProfitTradesSum++;
           }
  return(ProfitTradesSum);
//----+
  }
//+X================================================================X+ 
//| CountTotalTrades() function                                      |
//+X================================================================X+
int CountTotalTrades(int cmd)
  {
//----+      
  int TotalTrades, pos, Total = OrdersHistoryTotal();
  //----
  for(pos = 0; pos < Total; pos++)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_HISTORY))
      if (OrderType() == cmd || cmd < 0 || cmd > 1)
                 if (OrderType() < 2)
                            TotalTrades++;
  return(TotalTrades);
//----+
  }
//+X================================================================X+ 
//| CountExpectedPayoff() function                                   |
//+X================================================================X+
double CountExpectedPayoff(int cmd)
  {
//----+ 
  int TotalTrades = CountTotalTrades(cmd);
  if (TotalTrades == 0)
                 return(0.0);
  double ExpectedPayoff = 
              CountProfit(cmd) / TotalTrades; 
  return(ExpectedPayoff);
//----+
  } 
//+X================================================================X+ 
//|  Write_Param_htm() function                                      |
//+X================================================================X+
void Write_Param_htm
  (bool ToResolveWrite_Up, int Timeframe_Up, string ExtrVarblsNemes_Up, string ExtrVarblsVelues_Up, 
    bool ToResolveWrite_Dn, int Timeframe_Dn, string ExtrVarblsNemes_Dn, string ExtrVarblsVelues_Dn)
  {
//----+
   string n_Start, Title, Text;
   string Stop, n_Width, d_Width;
   string Path_Up, Path_Dn;
   string OptStartTime, OptEndTime;
   string StartTime, OptDay;
   int    newmonth, newyear;
   //----+       
   n_Start = "</tr><td><center>";
   n_Width = "</td><td><center>";
   d_Width = "</td><td class=mspt><center>";
   Stop = "</td></tr>";
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10); 
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Up) 
     if (CountProfit(OP_BUY) > 0)
      {
        Path_Up = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe_Up, "_Long.htm");
        if (_lopen(Path_Up, 0) < 0) 
            { 
              //----                                    
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path_Up + "\"" + "\n");
                                    
              if(_FileSize(Path_Up) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                            Symbol(), " Timeframe = ", Timeframe_Up, " Long Trades");
                  Text = StringConcatenate(             
                  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 6.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n",
						"<html><head>\n",
						"    <title>\"", Title, "\"</title>\n",
						"    <meta name=\"Description\" content=\"", Title, "\">\n",
						"    <meta name=\"generator\" content=\"MetaQuotes Software Corp.\">\n",
						"    <meta name=\"version\" content=\"<!--VERSION-->\">\n",
						"    <meta name=\"server\" content=\"<!--SERVER-->\">\n",
						"    <link rel=\"help\" href=\"http://www.metaquotes.net\">\n",
						"    <style type=\"text/css\" media=\"screen\">\n",
						"   <!--\n",
						"    td { font: 8pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\" media=\"print\">\n");
						WriteFile(Path_Up, Text);
						
						Text = StringConcatenate(
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=White><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#6C2DC7\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#347235\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=White style=\'color:#000000\'><td>\n",
						"<tr bgcolor=\"#C6AEC7\" style=\'color:#000000\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path_Up, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes_Up, Stop);
                  WriteFile(Path_Up, Text);
                            
                  //----              
                  WriteFile(Path_Up, "\n");                          
                }
            }
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(OP_BUY), 2), // 3
                      n_Width, CountTotalTrades(OP_BUY),                // 4
                        d_Width, DoubleToStr(CountProfitFactor(OP_BUY), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(OP_BUY), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(OP_BUY), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(OP_BUY), 2));   // 8
       
       //----                          
       WriteFile (Path_Up, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Up, Stop);
       //----                         
       WriteFile(Path_Up, Text);
       //----              
       WriteFile(Path_Up, "\n");                                            
     }
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Dn)
     if (CountProfit(OP_SELL) > 0)
      {  
        Path_Dn = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe_Dn, "_Short.htm"); 
                                                               
        if (_lopen(Path_Dn, 0) < 0) 
            {                            
              //----         
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path_Dn + "\"" + "\n");
                                    
              if(_FileSize(Path_Dn) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                              Symbol(), " Timeframe = ", Timeframe_Dn, " Short Trades");
                  Text = StringConcatenate(             
                  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 6.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n",
						"<html><head>\n",
						"    <title>\"", Title, "\"</title>\n",
						"    <meta name=\"Description\" content=\"", Title,"\">\n",
						"    <meta name=\"generator\" content=\"MetaQuotes Software Corp.\">\n",
						"    <meta name=\"version\" content=\"<!--VERSION-->\">\n",
						"    <meta name=\"server\" content=\"<!--SERVER-->\">\n",
						"    <link rel=\"help\" href=\"http://www.metaquotes.net\">\n",
						"    <style type=\"text/css\" media=\"screen\">\n",
						"   <!--\n",
						"    td { font: 8pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\" media=\"print\">\n");
						WriteFile(Path_Dn, Text);
						
						Text = StringConcatenate(
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=White><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#6C2DC7\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#347235\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=White style=\'color:#000000\'><td>\n",
						"<tr bgcolor=\"#C6AEC7\" style=\'color:#000000\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path_Dn, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes_Dn, Stop);
                  WriteFile(Path_Dn, Text);
                            
                  //----              
                  WriteFile(Path_Dn, "\n");                         
                }
             }   
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(OP_SELL), 2), // 3
                      n_Width, CountTotalTrades(OP_SELL),                 // 4
                        d_Width, DoubleToStr(CountProfitFactor(OP_SELL), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(OP_SELL), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(OP_SELL), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(OP_SELL), 2));   // 8
       
       //----                          
       WriteFile (Path_Dn, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Dn, Stop);
       //----                         
       WriteFile(Path_Dn, Text);
       //----              
       WriteFile(Path_Dn, "\n");                      
      }                       
   //----+ +---------------------------------------------------------------------------+
//----+ 
  } 
//+X================================================================X+ 
//|  Write_Param_1htm() function                                     |
//+X================================================================X+
void Write_Param_1htm
  (int Timeframe, string ExtrVarblsNemes, string ExtrVarblsVelues)
 {
//----+
   string n_Start, Title, Text;
   string Stop, n_Width, d_Width;
   string Path, Path_Dn;
   string OptStartTime, OptEndTime;
   string StartTime, OptDay;
   int    newmonth, newyear;
   //----+       
   n_Start = "</tr><td><center>";
   n_Width = "</td><td><center>";
   d_Width = "</td><td class=mspt><center>";
   Stop = "</td></tr>";
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10); 
   //----
   if (CountProfit(10) > 0)
      {
        Path = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe, ".htm");
        if (_lopen(Path, 0) < 0) 
            { 
              //----                                    
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path + "\"" + "\n");
                                    
              if(_FileSize(Path) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                                            Symbol(), " Timeframe = ", Timeframe);
                  Text = StringConcatenate(             
                  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 6.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n",
						"<html><head>\n",
						"    <title>\"", Title, "\"</title>\n",
						"    <meta name=\"Description\" content=\"", Title, "\">\n",
						"    <meta name=\"generator\" content=\"MetaQuotes Software Corp.\">\n",
						"    <meta name=\"version\" content=\"<!--VERSION-->\">\n",
						"    <meta name=\"server\" content=\"<!--SERVER-->\">\n",
						"    <link rel=\"help\" href=\"http://www.metaquotes.net\">\n",
						"    <style type=\"text/css\" media=\"screen\">\n",
						"   <!--\n",
						"    td { font: 8pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\" media=\"print\">\n");
						WriteFile(Path, Text);
						
						Text = StringConcatenate(
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=White><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#6C2DC7\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#347235\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=White style=\'color:#000000\'><td>\n",
						"<tr bgcolor=\"#C6AEC7\" style=\'color:#000000\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes, Stop);
                  WriteFile(Path, Text);
                            
                  //----              
                  WriteFile(Path, "\n");                          
                }
            }
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(10), 2), // 3
                      n_Width, CountTotalTrades(10),                // 4
                        d_Width, DoubleToStr(CountProfitFactor(10), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(10), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(10), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(10), 2));   // 8
       
       //----                          
       WriteFile (Path, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues, Stop);
       //----                         
       WriteFile(Path, Text);
       //----              
       WriteFile(Path, "\n");                                            
     }
//----+ 
  } 
//+X================================================================X+ 
//|  Write_Param_txt() function                                      |
//+X================================================================X+
void Write_Param_txt
   (bool ToResolveWrite_Up, int Timeframe_Up, string ExtrVarblsVelues_Up,
     bool ToResolveWrite_Dn, int Timeframe_Dn, string ExtrVarblsVelues_Dn)
  {
//----+
   string Text, Path_Up, Path_Dn;
   string OptStartTime, OptEndTime;
   //----+  
   int newmonth, newyear;
   string StartTime, OptDay; 
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Opt_Period * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);                                                                    
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Up) 
    {
     if (CountProfit(OP_BUY) > 0)
      {
        Path_Up = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe_Up, "_Long.txt");
                                 
        //----         
        if (_lopen(Path_Up, 0) < 0)                             
              WriteFile("C:\MetatraderTester.log", 
                              "\""+ Path_Up + "\"" + "\n");
       //----       
       Text = StringConcatenate(
                OptStartTime, // 1
                  " ", OptEndTime,       // 2
                    " ", CountProfit(OP_BUY), // 3
                      " ", CountTotalTrades(OP_BUY), // 4
                        " ", CountProfitFactor(OP_BUY), // 5
                          " ", CountExpectedPayoff(OP_BUY), // 6
                            " ", CountAbsDrawdown(OP_BUY),     // 7
                               " ", CountMaxDrawdown(OP_BUY));   // 8
       //----                          
       WriteFile (Path_Up, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Up, ";");
       //----                         
       WriteFile (Path_Up, Text);
       //----                       
       WriteFile (Path_Up, "\n"); 
     }                       
    }
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Dn)
    {
     if (CountProfit(OP_SELL) > 0)
      {
       Path_Dn = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                "_", Timeframe_Dn, "_Short.txt");
                                
       //----         
       if (_lopen(Path_Dn, 0) < 0)                             
              WriteFile("C:\MetatraderTester.log",
                              "\"" + Path_Dn + "\"" + "\n");
       //----       
       Text = StringConcatenate(
                OptStartTime, // 1
                  " ", OptEndTime,       // 2
                    " ", CountProfit(OP_SELL), // 3
                      " ", CountTotalTrades(OP_SELL), // 4
                        " ", CountProfitFactor(OP_SELL), // 5
                          " ", CountExpectedPayoff(OP_SELL), // 6
                            " ", CountAbsDrawdown(OP_SELL),     // 7
                               " ", CountMaxDrawdown(OP_SELL));   // 8
       //----                    
       WriteFile (Path_Dn, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Dn, ";");
       //----        
       WriteFile (Path_Dn, Text);
       //----              
       WriteFile (Path_Dn, "\n");
      }                          
    }
   //----+ +---------------------------------------------------------------------------+
//----+ 
  }
//+X================================================================X+ 
//|  Write_Param_1txt() function                                     |
//+X================================================================X+
void Write_Param_1txt
   (int Timeframe, string ExtrVarblsVelues)
  {
//----+
   string Text, Path;
   string OptStartTime, OptEndTime;
   //----+  
   int newmonth, newyear;
   string StartTime, OptDay; 
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Opt_Period * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);                                                                    
   //----+ +------------------------------------------------------+
   if (CountProfit(10) > 0)
     {
        Path = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe, ".txt");
                                 
        //----         
        if (_lopen(Path, 0) < 0)                             
              WriteFile("C:\MetatraderTester.log", 
                              "\""+ Path + "\"" + "\n");
       //----       
       Text = StringConcatenate(
                OptStartTime, // 1
                  " ", OptEndTime,       // 2
                    " ", CountProfit(10), // 3
                      " ", CountTotalTrades(10), // 4
                        " ", CountProfitFactor(10), // 5
                          " ", CountExpectedPayoff(10), // 6
                            " ", CountAbsDrawdown(10),     // 7
                               " ", CountMaxDrawdown(10));   // 8
       //----                          
       WriteFile (Path, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues, ";");
       //----                         
       WriteFile (Path, Text);
       //----                       
       WriteFile (Path, "\n");                       
    }
//----+ 
  }
//+X================================================================X+ 
//|  Write_Param_htm_B() function                                    |
//+X================================================================X+
void Write_Param_htm_B
  (bool ToResolveWrite_Up, int Timeframe_Up, string ExtrVarblsNemes_Up, string ExtrVarblsVelues_Up, 
    bool ToResolveWrite_Dn, int Timeframe_Dn, string ExtrVarblsNemes_Dn, string ExtrVarblsVelues_Dn)
  {
//----+
   string n_Start, Title, Text;
   string Stop, n_Width, d_Width;
   string Path_Up, Path_Dn;
   string OptStartTime, OptEndTime;
   string StartTime, OptDay;
   int    newmonth, newyear;
   //----+       
   n_Start = "</tr><td><center>";
   n_Width = "</td><td><center>";
   d_Width = "</td><td class=mspt><center>";
   Stop = "</td></tr>";
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10); 
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Up) 
     if (CountProfit(OP_BUY) > 0)
      {
        Path_Up = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe_Up, "_Long.htm");
        if (_lopen(Path_Up, 0) < 0) 
            { 
              //----                                    
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path_Up + "\"" + "\n");
                                    
              if(_FileSize(Path_Up) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                            Symbol(), " Timeframe = ", Timeframe_Up, " Long Trades");
                  Text = StringConcatenate(                         
                  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 6.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n",
						"<html><head>\n",
						"    <title>\"", Title, "\"</title>\n",
						"    <meta name=\"Description\" content=\"", Title, "\">\n",
						"    <meta name=\"generator\" content=\"MetaQuotes Software Corp.\">\n",
						"    <meta name=\"version\" content=\"<!--VERSION-->\">\n",
						"    <meta name=\"server\" content=\"<!--SERVER-->\">\n",
						"    <link rel=\"help\" href=\"http://www.metaquotes.net\">\n",
						"    <style type=\"text/css\" media=\"screen\">\n",
						"   <!--\n",
						"    td { font: 8pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\" media=\"print\">\n");
						WriteFile(Path_Up, Text);
						
						Text = StringConcatenate(
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=#330066><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#FFFFFF\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#FFFF00\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=Black style=\'color:#9E7BFF\'><td>\n",
						"<tr bgcolor=\"#151B54\" style=\'color:#33FF33\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path_Up, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes_Up, Stop);
                  WriteFile(Path_Up, Text);
                            
                  //----              
                  WriteFile(Path_Up, "\n");                         
                }
             }   
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(OP_BUY), 2), // 3
                      n_Width, CountTotalTrades(OP_BUY),                // 4
                        d_Width, DoubleToStr(CountProfitFactor(OP_BUY), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(OP_BUY), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(OP_BUY), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(OP_BUY), 2));   // 8
       
       //----                          
       WriteFile (Path_Up, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Up, Stop);
       //----                         
       WriteFile(Path_Up, Text);
       //----              
       WriteFile(Path_Up, "\n");                                            
     }
   //----+ +---------------------------------------------------------------------------+
   //----++     1
   if (ToResolveWrite_Dn)
     if (CountProfit(OP_SELL) > 0)
      {  
        Path_Dn = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe_Dn, "_Short.htm"); 
                                                               
        if (_lopen(Path_Dn, 0) < 0) 
            {                            
              //----         
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path_Dn + "\"" + "\n");
                                    
              if(_FileSize(Path_Dn) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                              Symbol(), " Timeframe = ", Timeframe_Dn, " Short Trades");
                  Text = StringConcatenate(             
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=#330066><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#FFFFFF\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#FFFF00\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=Black style=\'color:#9E7BFF\'><td>\n",
						"<tr bgcolor=\"#151B54\" style=\'color:#33FF33\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path_Dn, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes_Dn, Stop);
                  WriteFile(Path_Dn, Text);
                            
                  //----              
                  WriteFile(Path_Dn, "\n");                         
                }
             }   
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(OP_SELL), 2), // 3
                      n_Width, CountTotalTrades(OP_SELL),                 // 4
                        d_Width, DoubleToStr(CountProfitFactor(OP_SELL), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(OP_SELL), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(OP_SELL), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(OP_SELL), 2));   // 8
       
       //----                          
       WriteFile (Path_Dn, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues_Dn, Stop);
       //----                         
       WriteFile(Path_Dn, Text);
       //----              
       WriteFile(Path_Dn, "\n");                      
      }                       
   //----+ +---------------------------------------------------------------------------+
//----+ 
  } 
//+X================================================================X+ 
//|  Write_Param_1htm_B() function                                   |
//+X================================================================X+
void Write_Param_1htm_B
  (int Timeframe, string ExtrVarblsNemes, string ExtrVarblsVelues)
  {
//----+
   string n_Start, Title, Text;
   string Stop, n_Width, d_Width;
   string Path, Path_Dn;
   string OptStartTime, OptEndTime;
   string StartTime, OptDay;
   int    newmonth, newyear;
   //----+       
   n_Start = "</tr><td><center>";
   n_Width = "</td><td><center>";
   d_Width = "</td><td class=mspt><center>";
   Stop = "</td></tr>";
   //---
   StartTime = TimeToStr(Start_Time, TIME_DATE);
   OptDay = StringSubstr(StartTime, 8, 9);
   newyear = StrToInteger(StringSubstr(StartTime, 0, 4));
   newmonth = StrToInteger(StringSubstr(StartTime, 5, 6));
   //---
   newmonth += Opt_Number * Period_Shift;
   OptStartTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10);
   //----
   newmonth += Opt_Period;
   OptEndTime = StringSubstr(TimeToStr
           (CountTime(newmonth, newyear, OptDay)), 0, 10); 
   //----
   if (CountProfit(10) > 0)
      {
        Path = StringConcatenate("C:\OptReport_", 
                         WindowExpertName(), "_", Symbol(), 
                                 "_", Timeframe, ".htm");
        if (_lopen(Path, 0) < 0) 
            { 
              //----                                    
              WriteFile("C:\MetatraderTester.log", 
                             "\"" + Path + "\"" + "\n");
                                    
              if(_FileSize(Path) == 0) 
                { 
                  Title = StringConcatenate(WindowExpertName(), " ", 
                                            Symbol(), " Timeframe = ", Timeframe);
                  Text = StringConcatenate(             
                  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 6.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n",
						"<html><head>\n",
						"    <title>\"", Title, "\"</title>\n",
						"    <meta name=\"Description\" content=\"", Title, "\">\n",
						"    <meta name=\"generator\" content=\"MetaQuotes Software Corp.\">\n",
						"    <meta name=\"version\" content=\"<!--VERSION-->\">\n",
						"    <meta name=\"server\" content=\"<!--SERVER-->\">\n",
						"    <link rel=\"help\" href=\"http://www.metaquotes.net\">\n",
						"    <style type=\"text/css\" media=\"screen\">\n",
						"   <!--\n",
						"    td { font: 8pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\" media=\"print\">\n");
						WriteFile(Path, Text);
						
						Text = StringConcatenate(
						"    <!--\n",
						"    td { font: 7pt Tahoma,Arial; }\n",
						"    //-->\n",
						"    </style>\n",
						"    <style type=\"text/css\">\n",
						"    <!--\n",
						"    .msdate { mso-number-format:\"General Date\"; }\n",
						"    .mspt   { mso-number-format:\#\,\#\#0\.00;  }\n",
						"    //-->",
						"   </style>\n",
						"</head>\n",
						"<body  topmargin=1 marginheight=1 bgcolor=#330066><center>\n",
						"<div style=\"font: 20pt Times New Roman\" style=\'color:#FFFFFF\'><b>Optimization Reports</b></div>\n",
						"<div style=\"font: 16pt Times New Roman\" style=\'color:#FFFF00\'><b>", Title, "</b></div><br>\n",
						"   <table width=820 cellspacing=1 cellpadding=3 border=0 bgcolor=Black style=\'color:#9E7BFF\'><td>\n",
						"<tr bgcolor=\"#151B54\" style=\'color:#33FF33\' align=center>\n",
						"<td>Optimizations start</td><td>Optimizations end</td><td>Profit</td><td>Total trades</td><td>Profit ",
						"factor</td><td>Expected Payoff</td><td>Drawdown $</td><td>Drawdown %");
						WriteFile(Path, Text);
                             
                  Text = StringConcatenate(ExtrVarblsNemes, Stop);
                  WriteFile(Path, Text);
                            
                  //----              
                  WriteFile(Path, "\n");                         
                }
             }   
       //----       
       Text = 
            StringConcatenate(
               n_Start, OptStartTime, // 1
                  n_Width, OptEndTime,      // 2
                    d_Width, DoubleToStr(CountProfit(10), 2), // 3
                      n_Width, CountTotalTrades(10),                // 4
                        d_Width, DoubleToStr(CountProfitFactor(10), 2), // 5
                          d_Width, DoubleToStr(CountExpectedPayoff(10), 2), // 6
                           d_Width, DoubleToStr(CountMaxDrawdown(10), 2),     // 7
                             d_Width, DoubleToStr(CountMaxDrawdownPrs(10), 2));   // 8
       
       //----                          
       WriteFile (Path, Text);
       //----       
       Text = StringConcatenate(ExtrVarblsVelues, Stop);
       //----                         
       WriteFile(Path, Text);
       //----              
       WriteFile(Path, "\n");                                            
     }
   //----+ +---------------------------------------------------------------------------+
//----+ 
  }   
//+------------------------------------------------------------------+