//+X================================================================X+  
//|                                              Read_Write_File.mqh | 
//|                                    Copyright  2005,     mandorr | 
//|                                                mandorr@gmail.com | 
//+X================================================================X+  

//+==================================================================+
//| kernel32.dll functions                                           |
//+==================================================================+
#include <WinUser32.mqh>
#import "kernel32.dll"
   int _lopen  (string path, int of);
   int _lcreat (string path, int attrib);
   int _llseek (int handle, int offset, int origin);
   int _lread  (int handle, int& buffer[], int bytes);
   int _lwrite (int handle, string buffer, int bytes);
   int _lclose (int handle);
#import
//+==================================================================+
//| _FileSize() function                                             |
//+==================================================================+  
int _FileSize(string path)
  {
//----+
    int handle, result, Size; 
    //----
    handle = _lopen(path, 0);
    //----
    if(handle < 0) 
      {
        handle = _lcreat(path, 0);
        if (handle < 0) 
          {
            Print ("_FileSize():    ", path);
            return(-1);
          }
       }
    //----
    Size = _llseek(handle, 0, 2);  
    result = _lclose(handle);
    //----
    if (result < 0) 
      { 
        Print ("_FileSize():    ", path);
        return(-1);
      }
    return(Size);
//----+
  }
//+==================================================================+
//| WriteFile() function                                             |
//+==================================================================+  
bool WriteFile(string path, string buffer) 
  {
//----+
    int handle, result, count=StringLen(buffer); 
    //----
    handle=_lopen(path, 0);
    //----
    if(handle < 0) 
      {
        handle = _lcreat(path, 0);
        if (handle < 0) 
          {
            Print("WriteFile():    ", path);
            return(false);
          }
        result=_lclose(handle);
      }
    //----
    handle = _lopen(path, 1); 
    //----             
    if(handle < 0) 
      {
        Print("WriteFile():    ", path); 
        return(false);
      }
    //----
    result = _llseek(handle, 0, 2); 
    //----     
    if(result<0) 
      {
        Print("WriteFile():   "); 
        return(false);
      }
    //----
    result = _lwrite(handle, buffer, count); 
    //----
    if (result < 0) 
      {
        Print("WriteFile():     ", 
                              path, " ", count, " ");
        return(false);
      }
    //----
    result = _lclose(handle);  
    //----            
    if (result < 0)  
      {
        Print("WriteFile():    ", path);
        return(false);
      }
    return(true);
//----+
  }
//+X================================================================X+ 
//| ReadFile() function                                              |
//+X================================================================X+
bool ReadFile(string path, string& StrBuffer[]) 
  {
    int buffer[], count, handle, iii, result, size;
    handle = _lopen(path, 0); 
    //----             
    if (handle < 0) 
      {
        Print("ReadFile():    ", path); 
        return(false);
      }
    //----
    count = _llseek(handle, 0, 2);
    //----         
    if (count < 0)  
      {
        Print("ReadFile():   "); 
        return(false);
      }
    //----  
    size = 1 + count / 4;
    //----
    if (ArrayResize(buffer, size) < size)
      {
       Print("ReadFile():      buffer[]"); 
       return(false);    
      }
    //----  
    ArrayResize(StrBuffer, count);
    //----
    if (ArrayRange(StrBuffer, 0) < count)
      {
       Print("ReadFile():      StrBuffer[]"); 
       return(false);    
      }
    //----
    result = _llseek(handle, 0, 0);
    //----       
    if (result < 0) 
      {
        Print("ReadFile():   "); 
        return(false);
      }
    //----
    result = _lread(handle,buffer,count);
    //----
    if (result < 0) 
      {
        Print("ReadFile():    " ,path); 
        return(false);
      }
    //----
    result = _lclose(handle);
    //----              
    if (result < 0) 
      {
        Print("ReadFile():    " ,path); 
        return(false);
      }
    //----+      StrBuffer[]   
    for(iii = 0; iii < ArraySize(buffer); iii++) 
      {
        StrBuffer[iii] =
              CharToStr(buffer[iii]       & 0x000000FF)
             + CharToStr(buffer[iii] >>  8 & 0x000000FF)
              + CharToStr(buffer[iii] >> 16 & 0x000000FF)
               + CharToStr(buffer[iii] >> 24 & 0x000000FF);
      }
    //----+
    return (true);
  }
//+X================================================================X+ 
//| SpellFile() function                                             |
//+X================================================================X+
bool SpellFile (string path, string& SpellBuffer[]) 
  {
    int buffer[], size, count, handle, result, iii, kkk;
    //----
    handle = _lopen(path, 0); 
    //----             
    if (handle < 0) 
      {
        Print("SpellFile():    ",path); 
        return(false);
      }
    //----   
    count = _llseek(handle, 0, 2); 
    //----         
    if (count < 0)  
      {
        Print("SpellFile():   "); 
        return(false);
      }
    //----  
    size = 1 + count / 4;
    //----
    if (ArrayResize(buffer, size) < size) 
      {
       Print("SpellFile():      buffer[]"); 
       return(false);    
      }
    //----
    ArrayResize(SpellBuffer, count);
    //----
    if (ArrayRange(SpellBuffer, 0) < count)
      {
       Print("SpellFile():      SpellBuffer[]"); 
       return(false);    
      }
    //----
    result = _llseek(handle, 0, 0);  
    //----        
    if (result < 0) 
      {
        Print("SpellFile():   "); 
        return(false);
      }
    //----
    result = _lread(handle, buffer, count); 
    //----
    if (result < 0) 
      {
        Print("SpellFile():    ", path); 
        return(false);
      }
    //----  
    result = _lclose (handle); 
    //----             
    if (result < 0) 
      {
        Print("SpellFile():    ", path); 
        return(false);
      }
    //----
    size = ArraySize(buffer);
    size--;
    //----+      SpellBuffer[]  
    for(iii = 0; iii < size; iii++) 
      {
        SpellBuffer[kkk] =
              CharToStr(buffer[iii]       & 0x000000FF);
        SpellBuffer[kkk + 1] =       
              CharToStr(buffer[iii] >>  8 & 0x000000FF);
        SpellBuffer[kkk + 2] =      
              CharToStr(buffer[iii] >> 16 & 0x000000FF);
        SpellBuffer[kkk + 3] =
              CharToStr(buffer[iii] >> 24 & 0x000000FF);
        kkk += 4; 
      } 
    //----    
    if (kkk < count)
        SpellBuffer[kkk] =
             CharToStr(buffer[size]       & 0x000000FF);
    //----         
    if (kkk < count)
        SpellBuffer[kkk + 1] =       
             CharToStr(buffer[size] >>  8 & 0x000000FF);
    //----         
    if (kkk < count)
        SpellBuffer[kkk + 2] =      
             CharToStr(buffer[size] >> 16 & 0x000000FF);
    //----        
    if (kkk < count)
        SpellBuffer[kkk + 3] =
             CharToStr(buffer[size] >> 24 & 0x000000FF);
    //----+    
    return (true);
  }
//+ +----------------------------------------------------------------+