//     Metatrader\EXPERTS\indicators  
//  5c_OsMA.mq4
//+==================================================================+
//|                                                      Exp_5_2.mq4 |
//|                             Copyright  2008,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+==================================================================+
#property copyright "Copyright  2008, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//+==================================================================+
//| TestReport.mqh                                                   |
//+==================================================================+
#include <TestReport.mqh>
//----+ +--------------------------------------------------------------------------+
//----     BUY  
extern bool   Test_Up = true;//   
extern int    Timeframe_Up = 240;
extern double Money_Management_Up = 0.1;
extern double IndLevel_Up = 0; //   
extern int    FastEMA_Up = 12;  //   EMA
extern int    SlowEMA_Up = 26;  //   EMA
extern int    SignalSMA_Up = 9;  //   SMA
extern int    STOPLOSS_Up = 50;  // 
extern int    TAKEPROFIT_Up = 100; // 
extern int    TRAILINGSTOP_Up = 0; // 
extern int    PriceLevel_Up =40; //      
                                         //    
extern bool   ClosePos_Up = true; //    
//----+ +--------------------------------------------------------------------------+
//----     SELL  
extern bool   Test_Dn = true;//   
extern int    Timeframe_Dn = 240;
extern double Money_Management_Dn = 0.1;
extern double IndLevel_Dn = 0; //   
extern int    FastEMA_Dn = 12;  //   EMA
extern int    SlowEMA_Dn = 26;  //   EMA
extern int    SignalSMA_Dn = 9;  //   SMA
extern int    STOPLOSS_Dn = 50;  // 
extern int    TAKEPROFIT_Dn = 100; // 
extern int    TRAILINGSTOP_Dn = 0; // 
extern int    PriceLevel_Dn = 40; //      
                                         //    
extern bool   ClosePos_Dn = true; //    
//----+ +--------------------------------------------------------------------------+
//----      
int MinBar_Up, MinBar_Dn;
//----     
datetime OptStart_Time, OptEnd_Time, TestEnd_Time;  
//+==================================================================+
//| TimeframeCheck() functions                                       |
//+==================================================================+
void TimeframeCheck(string Name, int Timeframe)
  {
//----+
   //----    Timeframe  
   if (Timeframe != 1)
    if (Timeframe != 5)
     if (Timeframe != 15)
      if (Timeframe != 30)
       if (Timeframe != 60)
        if (Timeframe != 240)
         if (Timeframe != 1440)
           Print(StringConcatenate(" ",Name,
                     "   ", "  ", Timeframe, "!!!"));    
//----+ 
  }
//+==================================================================+
//| Custom Expert functions                                          |
//+==================================================================+
#include <Lite_EXPERT1.mqh>
//+==================================================================+
//| Custom Expert initialization function                            |
//+==================================================================+
int init()
  {
//----    Timeframe_Up  
   TimeframeCheck("Timeframe_Up", Timeframe_Up);                                                          
//----    Timeframe_Dn   
   TimeframeCheck("Timeframe_Dn", Timeframe_Dn);  
//----               
   MinBar_Up  = 3 + MathMax(FastEMA_Up, SlowEMA_Up) + SignalSMA_Up;
   MinBar_Dn  = 3 + MathMax(FastEMA_Dn, SlowEMA_Dn) + SignalSMA_Dn;   
//----  
   return(0);
  }
//+==================================================================+
//| expert deinitialization function                                 |
//+==================================================================+  
int deinit()
  {
//----+
     //----      
    if (IsOptimization())
      {
        string ExtVarNemes_Up, ExtVarVelues_Up, Width;
        string ExtVarNemes_Dn, ExtVarVelues_Dn, n_Width, d_Width;
        
        //----     Write_Param_txt()
        //----+ +-------------------------------------------------------+
        Width = " ";
        //---- 
        ExtVarVelues_Up = 
              StringConcatenate(
                  Width, DoubleToStr(IndLevel_Up, Digits), // 9
                    Width, FastEMA_Up,  // 10
                      Width, SlowEMA_Up,  // 11
                        Width, SignalSMA_Up, // 12
                          Width, STOPLOSS_Up,   // 13
                            Width, TAKEPROFIT_Up,   // 14
                              Width, TRAILINGSTOP_Up, // 15
                                Width, PriceLevel_Up,  // 16
                                  Width, ClosePos_Up);   // 17 
        //----+ +-------------------------------------------------------+                          
        ExtVarVelues_Dn = 
              StringConcatenate(
                  Width, DoubleToStr(IndLevel_Dn, Digits), // 9
                    Width, FastEMA_Dn,  // 10
                      Width, SlowEMA_Dn,  // 11
                        Width, SignalSMA_Dn, // 12
                          Width, STOPLOSS_Dn,   // 13
                            Width, TAKEPROFIT_Dn,   // 14
                              Width, TRAILINGSTOP_Dn, // 15
                                Width, PriceLevel_Dn,  // 16
                                  Width, ClosePos_Dn);   // 17 
                                                       
        //----     
        Write_Param_txt
                (Test_Up, Timeframe_Up, ExtVarVelues_Up,  
                   Test_Dn, Timeframe_Dn, ExtVarVelues_Dn);
                   
        //----     Write_Param_htm           
        //----+ +-------------------------------------------------------+                  
        n_Width = "</td><td><center>";
        d_Width = "</td><td class=mspt><center>";
        //---- 
        ExtVarNemes_Up =
            StringConcatenate( 
             n_Width, "IndLevel_Up",
              n_Width, "FastEMA_Up",
               n_Width, "SlowEMA_Up",
                n_Width, "SignalSMA_Up",
                 n_Width, "STOPLOSS_Up",
                  n_Width, "TAKEPROFIT_Up",
                   n_Width, "TRAILINGSTOP_Up",
                    n_Width, "PriceLevel_Up",
                     n_Width, "ClosePos_Up");
                                          
        ExtVarVelues_Up = 
              StringConcatenate(
                d_Width, DoubleToStr(IndLevel_Up, Digits), // 9
                    n_Width, FastEMA_Up, // 10
                      n_Width, SlowEMA_Up, // 11
                        n_Width, SignalSMA_Up, // 12
                          n_Width, STOPLOSS_Up,  // 13
                            n_Width, TAKEPROFIT_Up,  // 14
                              n_Width, TRAILINGSTOP_Up, // 15
                                n_Width, PriceLevel_Up,  // 16
                                  n_Width, ClosePos_Up);   // 17 
        //----+ +-------------------------------------------------------+
        ExtVarNemes_Dn =
            StringConcatenate( 
             n_Width, "IndLevel_Dn",
              n_Width, "FastEMA_Dn",
               n_Width, "SlowEMA_Dn",
                n_Width, "SignalSMA_Dn",
                 n_Width, "STOPLOSS_Dn",
                  n_Width, "TAKEPROFIT_Dn",
                   n_Width, "TRAILINGSTOP_Dn",
                    n_Width, "PriceLevel_Dn",
                     n_Width, "ClosePos_Dn");        
                                  
        ExtVarVelues_Dn = 
              StringConcatenate(
                d_Width, DoubleToStr(IndLevel_Dn, Digits), // 9
                    n_Width, FastEMA_Dn, // 10
                      n_Width, SlowEMA_Dn, // 11
                        n_Width, SignalSMA_Dn, // 12
                          n_Width, STOPLOSS_Dn,  // 13
                            n_Width, TAKEPROFIT_Dn,  // 14
                              n_Width, TRAILINGSTOP_Dn, // 15
                                n_Width, PriceLevel_Dn,  // 16
                                  n_Width, ClosePos_Dn);   // 17               
        
        //----    HTML 
        Write_Param_htm
              (Test_Up, Timeframe_Up, ExtVarNemes_Up, ExtVarVelues_Up, 
                Test_Dn, Timeframe_Dn, ExtVarNemes_Dn,  ExtVarVelues_Dn);
        //----+ +-------------------------------------------------------+
      }
    //----   
    return(0);
//----+ 
  }
//+==================================================================+
//| Custom Expert iteration function                                 |
//+==================================================================+
int start()
  {
   //----+     
   if (!IsBackTestingTime())
                       return(0);              
   //----+ +---------------------------------------------------------------+ 
   //----+   
   int MagicNumber;
   double Osc1, Osc2;
   //----+   
   //----+ +---------------------------------------------------------------+
   static datetime StopTime_Up, StopTime_Dn; 
   static int LastBars_Up, LastBars_Dn;
   static bool BUY_Sign1, BUY_Stop1, SELL_Sign1, SELL_Stop1;
   //----+ +---------------------------------------------------------------+
   //----++     1
   if (Test_Up) 
    {
      int IBARS_Up = iBars(NULL, Timeframe_Up);
      
      if (IBARS_Up >= MinBar_Up)
       {
         if (LastBars_Up != IBARS_Up)
          {
           //----+   
           BUY_Sign1 = false;
           BUY_Stop1 = false;
           LastBars_Up = IBARS_Up;
           StopTime_Up = iTime(NULL, Timeframe_Up, 1)
                                            + 2 * 60 * Timeframe_Up;
           
           //----+                
           Osc1 = iCustom(NULL, Timeframe_Up, 
                         "5c_OsMA", FastEMA_Up, SlowEMA_Up,
                                               SignalSMA_Up, 5, 1);
                                
           Osc2 = iCustom(NULL, Timeframe_Up, 
                         "5c_OsMA", FastEMA_Up, SlowEMA_Up,
                                               SignalSMA_Up, 5, 2);
           
           //----+                                               
           if (Osc2 < IndLevel_Up)
             if (Osc1 > IndLevel_Up)
                          BUY_Sign1 = true;
                          
           if (Osc1 < IndLevel_Up)
                          BUY_Stop1 = true;                                           
          }
         MagicNumber = 1;
         //----+  
         if (!OpenBuyLimitOrder1(BUY_Sign1, MagicNumber, 
              Money_Management_Up, STOPLOSS_Up, TAKEPROFIT_Up,
                                            PriceLevel_Up, StopTime_Up))
                                                                 return(-1);
         if (ClosePos_Up)
                if (!CloseOrder1(BUY_Stop1, MagicNumber))
                                                  return(-1);
                                        
         if (!Make_TreilingStop(MagicNumber, TRAILINGSTOP_Up))
                                                       return(-1);
        }
     }
   //----+ +---------------------------------------------------------------+
   //----++     1
   if (Test_Dn) 
    {
      int IBARS_Dn = iBars(NULL, Timeframe_Dn);
      
      if (IBARS_Dn >= MinBar_Dn)
       {
         if (LastBars_Dn != IBARS_Dn)
          {
           //----+   
           SELL_Sign1 = false;
           SELL_Stop1 = false;
           LastBars_Dn = IBARS_Dn;
           StopTime_Dn = iTime(NULL, Timeframe_Dn, 1) 
                                            + 2 * 60 * Timeframe_Dn; 
           
           //----+                
           Osc1 = iCustom(NULL, Timeframe_Dn, 
                         "5c_OsMA", FastEMA_Dn, SlowEMA_Dn,
                                               SignalSMA_Dn, 5, 1);
                                
           Osc2 = iCustom(NULL, Timeframe_Dn, 
                         "5c_OsMA", FastEMA_Dn, SlowEMA_Dn,
                                               SignalSMA_Dn, 5, 2);
           
           //----+                                               
           if (Osc2 > IndLevel_Dn)
             if (Osc1 < IndLevel_Dn)
                          SELL_Sign1 = true;
                          
           if (Osc1 > IndLevel_Dn)
                          SELL_Stop1 = true;                                           
          }
         MagicNumber = 2;
         //----+  
         if (!OpenSellLimitOrder1(SELL_Sign1, MagicNumber, 
              Money_Management_Dn, STOPLOSS_Dn, TAKEPROFIT_Dn,
                                            PriceLevel_Dn, StopTime_Dn))
                                                                 return(-1);
          if (ClosePos_Dn)
                if (!CloseOrder1(SELL_Stop1, MagicNumber))
                                                   return(-1);
                                        
          if (!Make_TreilingStop(MagicNumber, TRAILINGSTOP_Dn))
                                                        return(-1);
        }
     }
   //----+ +---------------------------------------------------------------+
//----+ 
    
    return(0);
  }
//+ +----------------------------------------------------------------+

