import requests
from bs4 import BeautifulSoup
from textblob import TextBlob

def get_eurusd_news():
    url = 'https://www.investing.com/currencies/eur-usd-news'
    headers = {'User-Agent': 'Mozilla/5.0'}
    response = requests.get(url, headers=headers)
    soup = BeautifulSoup(response.content, 'html.parser')

    # Encontrar todos los elementos <li> que contienen artículos de noticias
    articles = soup.find_all('li', class_='border-b')
    
    news = []
    for article in articles:
        title_tag = article.find('a', class_='mb-2 inline-block text-sm font-bold leading-5 hover:underline sm:text-base sm:leading-6 md:text-lg md:leading-7')
        
        if title_tag:
            title = title_tag.get_text(strip=True)
            news.append(title)
    
    return news

def analyze_sentiment(news):
    sentiment_results = []
    for article in news:
        analysis = TextBlob(article)
        sentiment = analysis.sentiment.polarity
        sentiment_results.append((article, sentiment))
    
    return sentiment_results

def summarize_sentiment(sentiments):
    positive = sum(1 for _, sentiment in sentiments if sentiment > 0)
    negative = sum(1 for _, sentiment in sentiments if sentiment < 0)
    neutral = len(sentiments) - positive - negative
    
    total = len(sentiments)
    summary = {
        'total': total,
        'positive': positive,
        'negative': negative,
        'neutral': neutral
    }
    
    return summary

news = get_eurusd_news()
if news:
    sentiments = analyze_sentiment(news)
    summary = summarize_sentiment(sentiments)

    for i, (article, sentiment) in enumerate(sentiments, 1):
        sentiment_type = 'Positive' if sentiment > 0 else 'Negative' if sentiment < 0 else 'Neutral'
        print(f"{i}. {article}\n   Sentiment: {sentiment_type} (Polarity: {sentiment})\n")

    print(f"Sentiment Summary: {summary}")
    print(f"Total articles: {summary['total']}, Positive: {summary['positive']}, Negative: {summary['negative']}, Neutral: {summary['neutral']}")
else:
    print("No news articles found for EUR/USD.")
