//------------------------------*
//STATISTIK.CPP					|   
//Copyright  2007 Nevi			|
//nevid@inbox.ru				|
//------------------------------*
#include "windows.h"
#include "math.h"
#include "stdlib.h"
#include "statistik.h"
#include "utils.h"
#include "fstream.h"

//    
char		*p			= NULL;
HANDLE		hSem		= NULL;	// 
HANDLE		hData		= NULL;	//    
Data		*pData		= NULL;	//    	
HANDLE		hDeals		= NULL;
DealRec		*pDeals		= NULL;
HANDLE		hDlsJournal	= NULL;
DealRec		*pDlsJournal= NULL;
HANDLE		hCaptions	= NULL;
MqlStr		*pCaptions	= NULL;
HANDLE		hDigits     = NULL;
int			*pDigits    = NULL;
		
LPCTSTR pSemCaption			= "N_STAT_SEM";			// 
LPCTSTR pDataCaption		= "N_STAT_DATA";		//  
LPCTSTR pDealsCaption		= "N_STAT_DEALS";		//  
LPCTSTR pDlsJournalCaption	= "N_STAT_DLSJOURNAL";	//  
LPCTSTR pCaptionsCaption	= "N_STAT_CAPTIONS";	//  
LPCTSTR pDigitsCaption      = "N_STAT_DIGITS";

int DTsize;			//   
int JTsize;			//   
int CTsize;			//  
int Cur		= -1;	//,    
int Id		= 0;	//,    

// DLL-
BOOL APIENTRY DllMain(HANDLE hModule,DWORD ul_reason_for_call,LPVOID lpReserved)
{
//----
   switch(ul_reason_for_call)
     {
      case DLL_PROCESS_ATTACH:
      case DLL_THREAD_ATTACH:
      case DLL_THREAD_DETACH:
	  case DLL_PROCESS_DETACH:
      break;
     }
//----
   return(TRUE);
}

//----------------------------
// 	/
//-------------------------
// id     
int GetID(MqlStr cap, CapType type)
{
	int begin;
	int end;
	switch(type)
	{
	case INS:
		begin = 0;
		end	= pData->CurNum;
		break;
	case BROKER:
		begin = pData->CurNum;
		end = CTsize;
		break;
	default:
		return -1;
	}
	for(int i = begin; i < end; i++)
	{
		if(EqvStr(&pCaptions[i], &cap))
			return i;
	}
	return -1;
}

//     , ,  magik
int FindDeal(int br, int cur, int magik)
{
	int i;
	//  
	for(i = 0; i < DTsize; i++)
		if((pDeals[i].Cur == cur) && (pDeals[i].Broker == br) && (pDeals[i].Magik == magik))
			return i;
	return -1;
}

//   
void ClearDeal(int index)
{	
	pDeals[index].Index			= -1;
	pDeals[index].Broker		= -1;
	pDeals[index].Cur			= -1;
	pDeals[index].Magik			= -1;
	pDeals[index].PriceOpen		= 0;
	pDeals[index].SlipOpen		= 0;
	pDeals[index].ReqOpen		= 0;
	pDeals[index].TimeForOpen	= 0;
	pDeals[index].PriceClose	= 0;
	pDeals[index].ReqClose		= 0;
	pDeals[index].SlipClose		= 0;
	pDeals[index].TimeForClose	= 0;
	pDeals[index].Checked		= false;
}

//----------------------------
// 	/
//-------------------------
//  -!    
__declspec(dllexport) bool __stdcall NewExpert(char *isBrokerName, char *isInstrument, int Digit)
{
	MqlStr BrokerName, Instrument;

	StrCopy(&BrokerName, isBrokerName);
	StrCopy(&Instrument, isInstrument);
	// 
	if(!hSem)
	{
		hSem = OpenMutex(SYNCHRONIZE, false, pSemCaption);
		if(!hSem)	return false;
	}
	//  :    ,   ,   FALSE
	if(!hData)
	{
		hData = OpenFileMapping(FILE_MAP_WRITE, FALSE, pDataCaption);
		if(hData)
		{
			p = (char*)MapViewOfFile(hData, FILE_MAP_WRITE, 0, 0, 0);
			pData = (Data*)p;
			if(!pData) return false;
					
			hDeals = OpenFileMapping(FILE_MAP_WRITE, FALSE, pDealsCaption);
			if(!hDeals) return false;
			p = (char*)MapViewOfFile(hDeals, FILE_MAP_WRITE, 0, 0, 0);
			pDeals = (DealRec*)p;
			if(!pDeals)
			{
				MessageBox(NULL, "!     .", " DLL", MB_OK);
				return false;
			}
			
			hDlsJournal = OpenFileMapping(FILE_MAP_WRITE, FALSE, pDlsJournalCaption);
			if(!hDlsJournal) return false;
			p = (char*)MapViewOfFile(hDlsJournal, FILE_MAP_WRITE, 0, 0, 0);
			pDlsJournal = (DealRec*)p;
			if(!pDlsJournal)
			{
				MessageBox(NULL, "!     .", " DLL", MB_OK);
				return false;
			}

			hCaptions = OpenFileMapping(FILE_MAP_WRITE, FALSE, pCaptionsCaption);
			if(!hCaptions) return false;
			p = (char*)MapViewOfFile(hCaptions, FILE_MAP_WRITE, 0, 0, 0);
			pCaptions = (MqlStr*)p;
			if(!pCaptions)
			{
				MessageBox(NULL, "!     .", " DLL", MB_OK);
				return false;
			}

			hDigits = OpenFileMapping(FILE_MAP_WRITE, FALSE, pDigitsCaption);
			if(!hDigits) return false;
			pDigits = (int*)MapViewOfFile(hDigits, FILE_MAP_WRITE, 0, 0, 0);
			if(!pDigits)
			{
				MessageBox(NULL, "!     Digits.", " DLL", MB_OK);
				return false;
			}
		}
		else
		{
			MessageBox(NULL, "!     ", " DLL", MB_OK);
			return false;
		}
	}

	int id = -1;
	int cur = -1;
	
	
	// ""
	MqlStr zero;
	StrCopy(&zero, " ");
//  
WaitForSingleObject(hSem, INFINITE);
	// 
	CTsize	= pData->BrokerNum + pData->CurNum;
	//  
	if((id = GetID(BrokerName, BROKER)) == -1)
	{
		//   (    )   id
		if((id = GetID(zero, BROKER)) != -1)
			MqlStrCopy(&pCaptions[id], &BrokerName);
	
		if(id == -1)
		{
			ReleaseMutex(hSem);
			MessageBox(NULL, "   ,     .", " DLL", MB_OK);
			return false;
		}		
		DTsize = pData->DealTableSize;
		JTsize = pData->JournalTableSize;
		Id = id;
	}	
	//    
	if((cur = GetID(Instrument, INS)) == -1)
	{
		if((cur = GetID(zero, INS)) != -1)
			MqlStrCopy(&pCaptions[cur], &Instrument);
		else
		{
			ReleaseMutex(hSem);
			MessageBox(NULL, "   ,     .", "", MB_OK);
			return false;
		}
		//
		if(Digit > 4)
		{
			ReleaseMutex(hSem);
			MessageBox(NULL, "!    ( 4 ).", "", MB_OK);
			return false;
		}
		//     
		pDigits[cur] = 1;
		while(Digit)
		{
			pDigits[cur] *= 10;
			Digit--;
		}
	}
ReleaseMutex(hSem);	
	return true;
}

//  
__declspec(dllexport) bool __stdcall NewDeal(char *isInstrument, int Action, int magik, double PriceOpen, int Slippage, int TimeForOpen, int Requotes)
{
	if(!pData) return false;

	MqlStr Instrument;
	StrCopy(&Instrument, isInstrument);
	int index = 0;
WaitForSingleObject(hSem, INFINITE);//
	if((Cur = GetID(Instrument, INS)) == -1)
	{
		MessageBox(NULL, "!    .", " DLL", MB_OK);
		ReleaseMutex(hSem);//
		return true;
	}
	if((index = FindDeal(-1, -1, -1)) == -1)
	{
		MessageBox(NULL, "!     .", " DLL", MB_OK);
		ReleaseMutex(hSem);//
		return true;
	}
	pDeals[index].Index			= index;
	pDeals[index].Broker		= Id;
	pDeals[index].Cur			= Cur;
	pDeals[index].Action		= Action;
	pDeals[index].Magik			= magik;
	pDeals[index].PriceOpen		= PriceOpen;
	pDeals[index].SlipOpen		= Slippage;
	pDeals[index].ReqOpen		= Requotes;
	pDeals[index].TimeForOpen	= TimeForOpen;
	pDeals[index].Checked		= false;
	ReleaseMutex(hSem);//
	return true;
}

// 
__declspec(dllexport) bool __stdcall CloseDeal(char *isInstrument, int magik, double PriceClose, int Slippage, int TimeForClose, int Requotes)
{
	if(!pData) return false;

	MqlStr Instrument;
	StrCopy(&Instrument, isInstrument);
	int index = 0;
	int i;
WaitForSingleObject(hSem, INFINITE);//
	if((Cur = GetID(Instrument, INS)) == -1)
	{
		MessageBox(NULL, "!    .", " DLL", MB_OK);
		ReleaseMutex(hSem);//
		return true;
	}
	if((index = FindDeal(Id, Cur, magik)) == -1)
	{
		MessageBox(NULL, "!     .", " DLL", MB_OK);
		ReleaseMutex(hSem);//
		return true;
	}
	pDeals[index].PriceClose	= PriceClose;
	pDeals[index].ReqClose		= Requotes;
	pDeals[index].SlipClose		= Slippage;
	pDeals[index].TimeForClose	= TimeForClose;
	if(pDeals[index].Action == BUY)
		pDeals[index].Profit =	
			Round((pDeals[index].PriceClose - pDeals[index].PriceOpen) * pDigits[Cur]);
	else
		pDeals[index].Profit =	
			Round((pDeals[index].PriceOpen - pDeals[index].PriceClose) * pDigits[Cur]);
	//   
	for(i = 0; i < JTsize; i++)
		if(pDlsJournal[i].Broker == -1)
		{
			pDlsJournal[i] = pDeals[index];
			pDlsJournal[i].Checked = false;
			break;
		}
	ClearDeal(index);
	ReleaseMutex(hSem);//
	return true;
}
//.  !
