//+------------------------------------------------------------------+
//|                                               Complex_pairs1.mq4 |
//|                                                           arzuma |
//|              http://onix-trade.net/forum/index.php?showtopic=107 |
//+------------------------------------------------------------------+
#property copyright "arzuma"
#property link      "http://onix-trade.net/forum/index.php?showtopic=107"
//----
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Green
//---- buffers
double pair[];
//---- parameters
// for monthly
int mn_per = 12;
int mn_fast = 3;
// for weekly
int w_per = 9;
int w_fast = 3;
// for daily
int d_per = 5;
int d_fast = 3;
// for H4
int h4_per = 12;
int h4_fast = 2;
// for H1
int h1_per = 24;
int h1_fast = 8;
// for M30
int m30_per = 16;
int m30_fast = 2;
// for M15
int m15_per = 16;
int m15_fast = 4;
// for M5
int m5_per = 12;
int m5_fast = 3;
// for M1
int m1_per = 30;
int m1_fast = 10;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, pair);
   IndicatorShortName(Symbol() + "(" + Period() + "): ");
   SetIndexLabel(0, Symbol()); 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars = IndicatorCounted();
   double OPEN, HIGH, LOW, CLOSE;
//---- checking for possible errors
   if(counted_bars < 0) 
       return(-1);
//---- the last bar will be recounted
   if(counted_bars > 0) 
       counted_bars -= 10;
   limit = Bars - counted_bars;
//---- main cycle
   int Price = 6;
   int Mode = 3;
   int per1, per2;
   switch(Period())
     {
       case 1:     per1 = m1_per;  per2 = m1_fast;  break;
       case 5:     per1 = m5_per;  per2 = m5_fast;  break;
       case 15:    per1 = m15_per; per2 = m15_fast; break;
       case 30:    per1 = m30_per; per2 = m30_fast; break;
       case 60:    per1 = h1_per;  per2 = h1_fast;  break;
       case 240:   per1 = h4_per;  per2 = h4_fast;  break;
       case 1440:  per1 = d_per;   per2 = d_fast;   break;
       case 10080: per1 = w_per;   per2 = w_fast;   break;
       case 43200: per1 = mn_per;  per2 = mn_fast;  break;
     }
   for(int i = 0; i < limit; i++)
     {
       OPEN = pp(Mode, PRICE_OPEN, i, per1, per2);
       HIGH = pp(Mode, PRICE_HIGH, i, per1, per2);
       LOW = pp(Mode, PRICE_LOW, i, per1, per2);
       CLOSE = pp(Mode, PRICE_CLOSE, i, per1, per2);
       pair[i] = (OPEN + HIGH + LOW + CLOSE) / 4;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double pp(int Mode, int Price, int i, int per1, int per2)
  {
   return((iMA(Symbol(), 0, per2, 0, Mode,Price, i)-
           iMA(Symbol(), 0, per1, 0, Mode,Price, i)));
  }   
//+------------------------------------------------------------------+


--------+


