//+------------------------------------------------------------------+
//|                                             Corrected SMA II.mq4 |
//|                                     Copyright  2007, Amir Aliev |
//|                                       http://finmat.blogspot.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Amir Aliev"
#property link      "http://finmat.blogspot.com"
 
#property indicator_chart_window
#property indicator_color1 Red
//---- input parameters
extern int MA_Ticks = 1000;
//---- indicator buffers
double sum = 0;                               
int ticks = 0;
bool collected = false;
bool started = false;
int fbar = 0;
double ExtMapBuffer[];
int oldRange = 0;
int lbarVol = 0;
 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----
   SetIndexStyle(0,DRAW_LINE);
   IndicatorDigits(Digits);
//---- indicator buffers mapping
   SetIndexBuffer(0, ExtMapBuffer);
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int rest = Bars - IndicatorCounted();
   
   if(! rest) return (0);

   Print("Ticks = ", ticks);
   Print("Rest = ", rest);
   Print("fbar = ", fbar);  
   
   rest--;
   fbar += rest;

   while(!collected && (rest >= 0))
   {
      if(ticks + Volume[rest] < MA_Ticks)
      {
         ticks += Volume[rest];
         sum += Volume[rest] * Open[rest];
         if(!started)
         {
            fbar = rest;
            started = true;
         }
         rest--;
         continue;
      } 
      collected = true;
   }
   if(! collected) return (0);
   
   ticks += (Volume[rest] - lbarVol);
   sum += (Volume[rest] - lbarVol) * Open[rest];
   lbarVol = Volume[rest];

   while(ticks > MA_Ticks)
   {
       Print("fbar-- because bar ticks reaches 1000");
       ticks -= Volume[fbar];
       sum -= Volume[fbar] * Open[fbar];
       fbar--;
   }
   ExtMapBuffer[rest] = sum / ticks;
   rest--;
  
   while(rest >= 0)
   {
      ticks += Volume[rest];
      sum += Volume[rest] * Open[rest];
      lbarVol = Volume[rest];
        
      while(ticks > MA_Ticks)
      {
         Print("fbar-- because of new bar ");
         ticks -= Volume[fbar];
         sum -= Volume[fbar] * Open[fbar];
         fbar--;
      }
      ExtMapBuffer[rest] = sum / ticks;
      rest--;
   } 
  
//----
   return(0);
  }
//+------------------------------------------------------------------+