//+------------------------------------------------------------------+
//|                                                Corrected SMA.mq4 |
//|                                     Copyright  2006, Amir Aliev |
//|                                        http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Amir Aliev"
#property link      "http://www.metaquotes.net/"
 
#property indicator_chart_window
#property indicator_color1 Red
//---- input parameters
extern int MA_Ticks = 10000;
extern int MA_Shift = 0;
extern int MA_Start = 500;
//---- indicator buffers
double ExtMapBuffer[];
double ExpVolBuffer[];
 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----
   SetIndexStyle(0,DRAW_LINE);
   SetIndexShift(0,MA_Shift);
   IndicatorBuffers(2);
   IndicatorDigits(Digits);
//---- indicator buffers mapping
   SetIndexBuffer(0, ExtMapBuffer);
   SetIndexBuffer(1, ExpVolBuffer);
   SetIndexDrawBegin(0,0);  
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int rest = Bars - counted_bars;
   int restt= Bars - counted_bars;
   double sum;                               
   int ts;                                   // ticks sumed;
   int evol;                                 // expected volume;
   int volsum;
   int j;
//----
  
   while(restt >= 0)
   {
      volsum = 0;
      for(int k = 0; k < 30; k++) 
         volsum += iVolume(NULL, 0, restt + k*24); 
      ExpVolBuffer[restt] = volsum / 30;
      restt--;
   }
   
   while(ExpVolBuffer[rest] == 0 && rest >= 0) rest--;
   rest -= MA_Ticks/200;
   if(rest > MA_Start) rest = MA_Start;
   
   while(rest >= 0)
   {
      sum = 0;
      ts = 0;
      j = rest;
      while(ts < MA_Ticks)
      {
         evol = ExpVolBuffer[j];
         Print("Evol = ", evol);
         if(ts + evol < MA_Ticks)
         {
            sum += evol * Open[j];
            ts += evol;
         }
         else
         {
            sum += (MA_Ticks - ts) * Open[j];
            ts = MA_Ticks;
         }
         j++;
      }
      ExtMapBuffer[rest] = sum / MA_Ticks;
      rest--;
   }   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+