//+------------------------------------------------------------------+
//|                                               Corrected MACD.mq4 |
//|                                     Copyright  2007, Amir Aliev |
//|                                       http://finmat.blogspot.com |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2007, Amir Aliev"
#property  link      "http://finmat.blogspot.com"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  Silver
#property  indicator_color2  Red
#property  indicator_width1  2
//---- indicator parameters
extern int FastSMA=5000;
extern int SlowSMA=10000;
extern int SignalSMA=9;
extern int DrawStart = 500;
//---- indicator buffers
double     MacdBuffer[];
double     SignalBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexDrawBegin(1,SignalSMA);
   IndicatorDigits(Digits+1);
//---- indicator buffers mapping
   SetIndexBuffer(0,MacdBuffer);
   SetIndexBuffer(1,SignalBuffer);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MACD("+FastSMA+","+SlowSMA+","+SignalSMA+")");
   SetIndexLabel(0,"MACD");
   SetIndexLabel(1,"Signal");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- macd counted in the 1-st buffer
   for(int i=0; i<limit; i++)
      MacdBuffer[i]=iCustom(NULL,0,"Corrected SMA", FastSMA, 0, DrawStart, 0, i)-iCustom(NULL,0,"Corrected SMA", SlowSMA, 0, DrawStart, 0, i);
//---- signal line counted in the 2-nd buffer
   for(i=0; i<limit; i++)
      SignalBuffer[i]=iMAOnArray(MacdBuffer, Bars,  SignalSMA, 0, MODE_SMA, i);
//---- done
   return(0);
  }